/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.readers;

import com.bmc.ctmconvert.jp1.exceptions.SyntaxErrorException;
import com.bmc.ctmconvert.jp1.readers.JP1Unit;
import com.bmc.ctmconvert.jp1.readers.Jp1UnitDefinition;
import com.bmc.ctmconvert.jp1.readers.UnitHeader;
import com.bmc.ctmconvert.jp1.readers.UnitHeaderExtractor;
import com.bmc.ctmconvert.utils.Pair;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Pattern;

public class JP1Scanner
implements AutoCloseable {
    private final Scanner scanner;
    private static final String OPEN_BRACKKETS = "\\s*\\{\\s*";
    private int currentLineNumber;
    private final StringBuilder hasRead;
    private String currentLine;
    private final Jp1UnitDefinition elementDefinition;
    private CommentHandler commentHandler;

    public JP1Scanner(InputStream inputStream, String charSet) throws FileNotFoundException {
        this.scanner = new Scanner(inputStream, charSet);
        this.scanner.useDelimiter("[\r\n]");
        this.hasRead = new StringBuilder();
        this.elementDefinition = new Jp1UnitDefinition();
        this.commentHandler = new EmptyCommentHandler();
    }

    public void setCommentHandler(CommentHandler commentHandler) {
        if (commentHandler != null) {
            this.commentHandler = commentHandler;
        }
    }

    @Override
    public void close() {
        this.scanner.close();
    }

    public String handleComment() {
        Pattern beginCommentPattern = this.elementDefinition.getBeginCommentPattern();
        Pattern endCommentPattern = this.elementDefinition.getEndCommentPattern();
        String comment = "";
        boolean retVal = this.scanner.hasNext(beginCommentPattern);
        if (retVal) {
            retVal = this.scanner.hasNext(endCommentPattern);
            if (retVal) {
                comment = this.scanner.nextLine();
                ++this.currentLineNumber;
                this.commentHandler.handleComment(comment);
            } else {
                while (!this.scanner.hasNext(endCommentPattern)) {
                    comment = this.scanner.nextLine();
                    ++this.currentLineNumber;
                    this.commentHandler.handleComment(comment);
                }
                if (this.scanner.hasNext(endCommentPattern)) {
                    comment = this.scanner.nextLine();
                    ++this.currentLineNumber;
                    this.commentHandler.handleComment(comment);
                }
            }
        }
        return comment;
    }

    public boolean hasNextUnit() {
        Pattern oldDelimiter = this.scanner.delimiter();
        Pattern unitDelimiter = this.elementDefinition.getElementDelinmiterPattern();
        this.scanner.useDelimiter(unitDelimiter);
        Pattern unitPattern = this.elementDefinition.getElementPattern();
        Pattern openBracketsPattern = this.elementDefinition.getOpenBracketsPattern();
        boolean ret = this.scanner.hasNext(unitPattern);
        if (!ret) {
            ret = this.scanner.hasNext(openBracketsPattern);
        }
        this.scanner.useDelimiter(oldDelimiter);
        return ret;
    }

    public String readNextUnitHeader() {
        String unitHeader = "";
        if (this.hasNextUnit()) {
            unitHeader = this.readUnitHeader();
        }
        unitHeader = unitHeader.trim();
        return unitHeader;
    }

    private String readUnitHeader() {
        String headerPattern = this.elementDefinition.getElementHeader();
        if (this.scanner.hasNext(headerPattern)) {
            String header = this.getNextLine();
            if (this.scanner.hasNext(OPEN_BRACKKETS)) {
                this.readNextLine();
            }
            return header;
        }
        return "";
    }

    public boolean hasNextAttribute() {
        return this.scanner.hasNext(this.elementDefinition.getAttributePattern());
    }

    public String readNextLine() {
        return this.getNextLine();
    }

    private String getNextLine() {
        this.currentLine = this.scanner.nextLine();
        ++this.currentLineNumber;
        this.skipIgnoredLines();
        return this.currentLine;
    }

    public boolean skipIgnoredLines() {
        boolean enterLoop = false;
        Pattern ignoredLinePattern = this.elementDefinition.getIgnoredPattern();
        while (this.scanner.hasNext(ignoredLinePattern) && !this.scanner.hasNext(this.elementDefinition.getElementPattern())) {
            this.handleComment();
            this.handleEmptyLine();
            enterLoop = true;
        }
        return enterLoop;
    }

    public String handleEmptyLine() {
        String emptyLine = "-1";
        boolean hasNoCharacter = false;
        Pattern emptyLinePattern = this.elementDefinition.getEmptyLinePattern();
        boolean hasNexEmptyLine = this.scanner.hasNext(emptyLinePattern);
        if (!hasNexEmptyLine) {
            hasNoCharacter = this.scanner.hasNext(Pattern.compile(".{0}"));
        }
        if (hasNoCharacter || hasNexEmptyLine) {
            emptyLine = this.scanner.nextLine();
            ++this.currentLineNumber;
        }
        return String.valueOf(emptyLine.length());
    }

    public boolean hasNextEndOfUnit() {
        return this.scannerHasNextPattern(this.elementDefinition.getEndOfElementPattern());
    }

    private boolean scannerHasNextPattern(Pattern pattern) {
        Pattern oldDelimiter = this.scanner.delimiter();
        Pattern delimitedPattern = this.delimitedPattern(pattern);
        this.scanner.useDelimiter(delimitedPattern);
        boolean ret = this.scanner.hasNext(pattern);
        this.scanner.useDelimiter(oldDelimiter);
        return ret;
    }

    private Pattern delimitedPattern(Pattern attributePattern) {
        return Pattern.compile("^(?=(" + String.valueOf(attributePattern) + ").*?)", 8);
    }

    public String skipCloseBrackets() {
        String ret = "";
        if (this.hasNextEndOfUnit()) {
            ret = this.getNextLine();
        }
        return ret;
    }

    public List<Pair<String, String>> readNextAttributes() {
        ArrayList<Pair<String, String>> attributes = new ArrayList<Pair<String, String>>();
        while (!this.hasNextEndOfUnit() && !this.hasNextUnit()) {
            String attributeLine = this.getAttributeLine();
            if (attributeLine.endsWith(";")) {
                attributeLine = attributeLine.substring(0, attributeLine.length() - 1);
            }
            if (!attributeLine.contains("=")) continue;
            String[] args = attributeLine.split("=", 2);
            String key = args[0].trim();
            String value = args[1].trim();
            value = value.replaceAll("^\"|\"$", "");
            attributes.add((Pair<String, String>)new Pair((Object)key, (Object)value));
        }
        return attributes;
    }

    private StringBuilder teAttributeParse(String nextLine) {
        StringBuilder stringbuilder = new StringBuilder();
        String DOT_MATCHS_ALL = "(?s)";
        String tePattern = "(?s)\\s*te=\".*?[^#]\";";
        try {
            StringBuilder nextLineBuilder = new StringBuilder(nextLine);
            while (!nextLineBuilder.toString().matches("(?s)\\s*te=\".*?[^#]\";")) {
                nextLineBuilder.append("\n").append(this.getNextLine());
            }
            nextLine = nextLineBuilder.toString();
        }
        catch (NoSuchElementException e) {
            throw new SyntaxErrorException(this.getCurrentLineNumber(), nextLine);
        }
        if (nextLine.matches("(?s)\\s*te=\".*?[^#]\";")) {
            stringbuilder.append(nextLine);
        }
        return stringbuilder;
    }

    private String getAttributeLine() {
        StringBuilder stringbuilder = new StringBuilder();
        if (this.hasNextAttribute()) {
            String nextLine = this.getNextLine();
            if (nextLine.matches("\\s*te=.*")) {
                stringbuilder = this.teAttributeParse(nextLine);
            } else {
                stringbuilder.append(nextLine);
                while (!nextLine.matches(".*;\\s*$") && this.scanner.hasNext()) {
                    nextLine = this.getNextLine();
                    stringbuilder.append("\n").append(nextLine);
                }
            }
        } else {
            throw new SyntaxErrorException(this.getCurrentLineNumber(), this.getLastLineRead());
        }
        return stringbuilder.toString();
    }

    public boolean isEndOfFile() {
        return !this.scanner.hasNext();
    }

    public JP1Unit readNextUnit() {
        JP1Unit unit = null;
        if (this.hasNextUnit()) {
            String unitHeaderLine = this.readNextUnitHeader();
            UnitHeaderExtractor unitHeaderExtractor = new UnitHeaderExtractor(unitHeaderLine);
            UnitHeader unitHeader = unitHeaderExtractor.extract();
            unit = new JP1Unit(unitHeader);
            unit.addAllAttributes(this.readNextAttributes());
            return unit;
        }
        return unit;
    }

    public int getCurrentLineNumber() {
        return this.currentLineNumber;
    }

    public String getLastLineRead() {
        return this.currentLine;
    }

    public String toString() {
        return this.hasRead.toString();
    }

    public static class EmptyCommentHandler
    implements CommentHandler {
        @Override
        public void handleComment(String comment) {
        }
    }

    @FunctionalInterface
    public static interface CommentHandler {
        public void handleComment(String var1);
    }
}

