/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.message;

import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.dataObject.Attributes;
import com.bmc.ctmconvert.common.dataObject.DataObject;
import com.bmc.ctmconvert.common.message.IMessage;
import com.bmc.ctmconvert.common.message.MessageHandler;
import com.bmc.ctmconvert.common.transformer.workspaces.WorkspaceEntity;
import com.bmc.ctmconvert.jp1.globs.Jp1HierarchyUtils;
import com.bmc.ctmconvert.jp1.message.Jp1Message;
import java.util.ArrayList;
import java.util.Optional;

public class Jp1MessageHandler
implements MessageHandler {
    private int jobId;
    private DataObject dataObject;
    private WorkspaceEntity job;

    public Jp1MessageHandler(int jobId, DataObject dObject, WorkspaceEntity job) {
        this.jobId = jobId;
        this.dataObject = dObject;
        this.job = job;
    }

    public void handleMessage(String messageID, String ... params) {
        StringBuilder fullPath = new StringBuilder();
        if (Jp1MessageHandler.notTopLevel(this.dataObject, this.jobId)) {
            Integer parentID = (Integer)this.dataObject.getParent(this.jobId).get();
            if (Jp1HierarchyUtils.getDirectGroupParent(parentID, this.dataObject).isPresent()) {
                Attributes parentAttributes;
                Optional typeAttribute;
                fullPath.append(Jp1HierarchyUtils.getGroupPath(this.jobId, this.dataObject, false));
                fullPath.append("/");
                String subApp = Jp1HierarchyUtils.getUnitNameByType(parentID, this.dataObject, "n");
                if (subApp.length() > 0) {
                    fullPath.append(subApp);
                    fullPath.append("/");
                }
                if (!(typeAttribute = (parentAttributes = new Attributes(this.dataObject.getAttributes(parentID))).findFirstValue("ty")).equals(Optional.of("g"))) {
                    String folderName = this.dataObject.findFirstAttribute("UNIT_NAME", parentID).orElse("");
                    if (this.job.getParent() != null) {
                        folderName = Optional.of(this.job.getParent().getName()).orElse("");
                    }
                    fullPath.append(folderName);
                    fullPath.append("/");
                }
            } else {
                fullPath.append(Jp1HierarchyUtils.getPath(parentID, this.dataObject, false));
                fullPath.append("/");
            }
        }
        fullPath.append(this.job.getName());
        ArrayList messages = new ArrayList();
        Reporter.addMessage(messages, (String)messageID, (String)fullPath.toString(), (String[])params);
        this.job.addMessage((IMessage)new Jp1Message((String)messages.get(0)));
    }

    private static boolean notTopLevel(DataObject dataObject, int id) {
        return dataObject.getParent(id).isPresent() && id != 0;
    }
}

