/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.convertors.scheduling;

import com.bmc.ctmconvert.Rbc.Rbc;
import com.bmc.ctmconvert.common.rbc.RbcNamer;
import java.util.HashMap;
import java.util.Properties;

public class JP1RbcNamer {
    private static HashMap<Properties, String> PropertiesToName = new HashMap();
    private static int anonymousRbcCount = 0;

    public static void nameRbc(Rbc rbcToName) {
        Properties rbcProps = rbcToName.getProperties();
        rbcProps.setProperty("NAME", "");
        Properties rbcPropsKey = (Properties)rbcProps.clone();
        if (!PropertiesToName.containsKey(rbcPropsKey)) {
            String suggestedName = "";
            boolean named = RbcNamer.nameRbc((Properties)rbcProps, (String)"MON");
            if (!named) {
                suggestedName = JP1RbcNamer.attemptToNameByCalendar(rbcProps) ? JP1RbcNamer.extractUniqueNameFromProps(rbcProps) : JP1RbcNamer.getNextAnonymous();
            } else {
                JP1RbcNamer.renameByCalendar(rbcProps);
                suggestedName = JP1RbcNamer.extractUniqueNameFromProps(rbcProps);
            }
            PropertiesToName.put(rbcPropsKey, suggestedName);
        }
        rbcToName.setName(PropertiesToName.get(rbcPropsKey));
    }

    private static boolean attemptToNameByCalendar(Properties rbcProps) {
        boolean named = false;
        if (JP1RbcNamer.isCalendarAndDayCombo(rbcProps)) {
            named = true;
            JP1RbcNamer.setDayAndCalName(rbcProps);
        } else if (JP1RbcNamer.onlyDefinitionIsCalendar(rbcProps)) {
            JP1RbcNamer.forceNameBayCalendar(rbcProps);
            JP1RbcNamer.renameByCalendar(rbcProps);
            named = true;
        }
        return named;
    }

    private static void forceNameBayCalendar(Properties rbcProps) {
        String[] calendars = new String[]{"DAYSCAL", "WEEKSCAL", "CONFCAL"};
        rbcProps.setProperty("NAME", "");
        for (int i = 0; rbcProps.getProperty("NAME", "").isEmpty() && i < calendars.length; ++i) {
            rbcProps.setProperty("NAME", rbcProps.getProperty(calendars[i], ""));
        }
    }

    private static boolean onlyDefinitionIsCalendar(Properties rbcProps) {
        boolean singleCalendarUsed = rbcProps.getProperty("DAYSCAL", "").isEmpty() && rbcProps.getProperty("WEEKSCAL", "").isEmpty() && !rbcProps.getProperty("CONFCAL", "").isEmpty() || rbcProps.getProperty("DAYSCAL", "").isEmpty() && !rbcProps.getProperty("WEEKSCAL", "").isEmpty() && rbcProps.getProperty("CONFCAL", "").isEmpty() || !rbcProps.getProperty("DAYSCAL", "").isEmpty() && rbcProps.getProperty("WEEKSCAL", "").isEmpty() && rbcProps.getProperty("CONFCAL", "").isEmpty();
        boolean noDaysDefined = rbcProps.getProperty("DAYS", "").isEmpty() && rbcProps.getProperty("WEEKDAYS", "").isEmpty();
        return singleCalendarUsed && noDaysDefined;
    }

    public static String extractUniqueNameFromProps(Properties rbcProps) {
        String baseName;
        String suggestedName = baseName = rbcProps.getProperty("NAME");
        Integer count = 1;
        while (PropertiesToName.values().contains(suggestedName)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = baseName;
            Integer n = count;
            count = count + 1;
            objectArray[1] = n;
            suggestedName = String.format("%s#%d", objectArray);
        }
        return suggestedName;
    }

    private static void renameByCalendar(Properties rbcProps) {
        if (JP1RbcNamer.isNamedBycalendar(rbcProps)) {
            if (rbcProps.getProperty("NAME").startsWith("WORKDAYS")) {
                rbcProps.setProperty("NAME", "WORKDAYS");
            } else if (rbcProps.getProperty("NAME").startsWith("NON_WORKDAYS")) {
                rbcProps.setProperty("NAME", "NON_WORKDAYS");
            }
        }
        if (JP1RbcNamer.isCalendarAndDayCombo(rbcProps)) {
            JP1RbcNamer.setDayAndCalName(rbcProps);
        }
    }

    private static void setDayAndCalName(Properties rbcProps) {
        String days = rbcProps.getProperty("DAYS");
        String calendar = rbcProps.getProperty("DAYSCAL");
        boolean fromEnd = days.startsWith("L");
        String day = days.substring(1);
        if (calendar.startsWith("WORKDAYS") || calendar.startsWith("NON_WORKDAYS")) {
            rbcProps.setProperty("NAME", JP1RbcNamer.getNameByCombo(day, calendar.startsWith("WORKDAYS"), fromEnd));
        } else {
            rbcProps.setProperty("NAME", JP1RbcNamer.getNextAnonymous());
        }
    }

    private static String getNameByCombo(String day, boolean isWorkDay, boolean fromEnd) {
        Object nameFormat = "";
        if (fromEnd) {
            Object object = nameFormat = isWorkDay ? "LastWorkday" : "LastNonWorkday";
            if (!day.equals(Integer.toString(1))) {
                nameFormat = "%s" + (String)nameFormat;
            }
        } else {
            nameFormat = isWorkDay ? "%s_workday" : "%s_non_workday";
        }
        return String.format((String)nameFormat, JP1RbcNamer.toOrdinal(day));
    }

    private static String toOrdinal(String numStr) {
        int num = Integer.valueOf(numStr);
        String suffix = "th";
        if (num > 20 || num < 10) {
            switch (num % 10) {
                case 1: {
                    suffix = "st";
                    break;
                }
                case 2: {
                    suffix = "nd";
                    break;
                }
                case 3: {
                    suffix = "rd";
                    break;
                }
                default: {
                    suffix = "th";
                }
            }
        }
        return String.format("%d%s", num, suffix);
    }

    private static String getNextAnonymous() {
        return String.format("RBC#%d", ++anonymousRbcCount);
    }

    private static boolean isCalendarAndDayCombo(Properties rbcProps) {
        return !rbcProps.getProperty("DAYSCAL", "").isEmpty() && JP1RbcNamer.isRelativeSingleMonthDay(rbcProps.getProperty("DAYS", ""));
    }

    private static boolean isRelativeSingleMonthDay(String daysStr) {
        return daysStr.matches("[LD][0-9]{1,2}");
    }

    private static boolean isNamedBycalendar(Properties rbcProps) {
        return rbcProps.getProperty("NAME").equals(rbcProps.getProperty("DAYSCAL", "no such name")) || rbcProps.getProperty("NAME").equals(rbcProps.getProperty("WEEKSCAL", "no such name"));
    }
}

