/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.convertors.scheduling;

import com.bmc.ctmconvert.common.dataObject.DataObject;
import com.bmc.ctmconvert.common.dataObject.query.DataObjectQuery;
import com.bmc.ctmconvert.common.transformer.workspaces.WorkspaceEntity;
import com.bmc.ctmconvert.jp1.Queries.ChildrenOfTypeJobQuery;
import com.bmc.ctmconvert.jp1.convertors.JP1Calendar;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.JobnetRule;
import com.bmc.ctmconvert.jp1.convertors.scheduling.CalendarGetter;
import com.bmc.ctmconvert.jp1.convertors.scheduling.Jp1Scheduler;
import com.bmc.ctmconvert.jp1.convertors.scheduling.RbcFactory;
import com.bmc.ctmconvert.jp1.convertors.scheduling.RulesConvertor;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;

public class DailyCyclicHandler
implements Consumer<Integer> {
    private DataObject dataobject;
    private Jp1Scheduler.DataObjectEntityToCtmJobResolver dataObjectEntityToCtmJobResolver;
    private Jp1Scheduler.RulesGetter rulesGetter;
    private Jp1Scheduler.GroupIdToCalendarResolver calendarResolver;

    public DailyCyclicHandler(DataObject dataobject, Jp1Scheduler.DataObjectEntityToCtmJobResolver dataObjectEntityToCtmJobResolver, Jp1Scheduler.RulesGetter rulesGetter, Jp1Scheduler.GroupIdToCalendarResolver calendarResolver) {
        this.dataobject = dataobject;
        this.dataObjectEntityToCtmJobResolver = dataObjectEntityToCtmJobResolver;
        this.rulesGetter = rulesGetter;
        this.calendarResolver = calendarResolver;
    }

    @Override
    public void accept(Integer jobnetId) {
        List<JobnetRule> rules = this.rulesGetter.getRules(jobnetId);
        CalendarGetter calendarGetter = new CalendarGetter();
        Optional<JP1Calendar> calendar = calendarGetter.getCalendar(jobnetId, this.dataobject, this.calendarResolver);
        RbcFactory rbcFactory = new RbcFactory(calendar);
        RulesConvertor rulesConvertor = new RulesConvertor(rbcFactory);
        List<Properties> rbcs = rulesConvertor.createRbcs(rules);
        Consumer<Integer> adder = dataEntityId -> {
            WorkspaceEntity job = this.dataObjectEntityToCtmJobResolver.getWorkspaceEntityFromDataObjectEntityId((Integer)dataEntityId);
            for (Properties rbc : rbcs) {
                job.addScheduling(rbc);
            }
        };
        ChildrenOfTypeJobQuery newJobs = new ChildrenOfTypeJobQuery(jobnetId);
        this.dataobject.stream().filterEntites((DataObjectQuery)newJobs).forEachEntityId(adder);
    }
}

