/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.convertors.jp1Entities;

import com.bmc.ctmconvert.common.rbc.RBC;
import java.time.LocalDate;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RuleStartDate {
    private static final String RULENUMBER = "((?<RULENUMBER>\\d+)\\s*,\\s*)?";
    private static final String DAYS_GROUP = "DAYS";
    private static final String DATE_MONTH_FORMAT = "\\d{2}";
    private static final String DATE_YEARS_FORMAT = "\\d{4}";
    private static final String DATE_DAYS_FORMAT = "\\d{2}";
    private static final String DAYS_FORMAT = "(?<DAYS>\\d{2})?";
    private static final String WEEKDAY_GROUP = "WEEKDAY";
    private static final String WEEKNUMBER_GROUP = "WEEKNUMBER";
    private static final String COLON_FORMAT = "(:(?<WEEKNUMBER>\\d{1}|b))?";
    private static final String WEEKDAY_FORMAT = "(?<WEEKDAY>su|mo|tu|we|th|fr|sa)?(:(?<WEEKNUMBER>\\d{1}|b))?";
    private static final String B_GROUP = "B";
    private static final String B_DAYS_GROUP = "BDAYS";
    private static final String DAYS_BEFORE_END_FORMAT = "((?<B>b)(-(?<BDAYS>\\d{2}))?)?";
    private static final String OPEN_SIGN = "*";
    private static final String CLOSE_SIGN = "@";
    private static final String SIGN_STRING = "SIGN";
    private static final String RELATIVE_SIGN = "+";
    private static final String SIGN_FORMAT = "(?<SIGN>[\\*@\\+]?)";
    static final String YEARGROUP = "YEAR";
    static final String MONTHGROUP = "MONTH";
    private static final String YEAR_AND_MONTH = "((?<YEAR>\\d{4})/)?((?<MONTH>\\d{2})/)?";
    private static final String START_DATE_PATTERN = "((?<RULENUMBER>\\d+)\\s*,\\s*)?((?<YEAR>\\d{4})/)?((?<MONTH>\\d{2})/)?(?<SIGN>[\\*@\\+]?)((?<DAYS>\\d{2})?|((?<B>b)(-(?<BDAYS>\\d{2}))?)?|(?<WEEKDAY>su|mo|tu|we|th|fr|sa)?(:(?<WEEKNUMBER>\\d{1}|b))?)\\s*$";
    private static final String SD_PATTERN = "(((?<RULENUMBER>\\d+)\\s*,\\s*)?(?<SIGN>[\\*@\\+]).*)";
    private static final String SPECIFIC_DATE_PATTERN = "(((?<RULENUMBER>\\d+)\\s*,\\s*)?(?<YEAR>\\d{4})/(?<MONTH>\\d{2})/(?<SIGN>[\\*@\\+]?)(?<DAYS>\\d{2}))";
    private String sdValue;

    public RuleStartDate(String sdValue) {
        this.sdValue = sdValue;
        if (this.sdValue == null) {
            this.sdValue = "";
        }
    }

    public Optional<LocalDate> getLocalDate() {
        Optional<LocalDate> ret = Optional.empty();
        Pattern r = Pattern.compile(SPECIFIC_DATE_PATTERN);
        Matcher m = r.matcher(this.sdValue);
        if (!m.find()) {
            return Optional.empty();
        }
        Integer year = Integer.valueOf(m.group(YEARGROUP));
        Integer month = Integer.valueOf(m.group(MONTHGROUP));
        Integer days = Integer.valueOf(m.group(DAYS_GROUP));
        LocalDate startDate = LocalDate.of((int)year, month, (int)days);
        ret = Optional.of(startDate);
        return ret;
    }

    public boolean isOpen() {
        String sdSign = this.getSign();
        return sdSign.equals(OPEN_SIGN);
    }

    public boolean isClosed() {
        String sdSign = this.getSign();
        return sdSign.equals(CLOSE_SIGN);
    }

    private String getSign() {
        String retSign = "";
        retSign = this.extractSignFromSDKey(this.sdValue, SD_PATTERN);
        if (retSign.isEmpty()) {
            retSign = this.extractSignFromSDKey(this.sdValue, START_DATE_PATTERN);
        }
        return retSign;
    }

    private String extractSignFromSDKey(String sdValue, String sdFormat) {
        String signValue = "";
        Pattern r = Pattern.compile(sdFormat);
        Matcher m = r.matcher(sdValue);
        if (m.find()) {
            signValue = m.group(SIGN_STRING);
        }
        return signValue;
    }

    public Optional<String> getweekNumber() {
        return this.getGroupValue(START_DATE_PATTERN, WEEKNUMBER_GROUP);
    }

    public Optional<Integer> getYear() {
        return this.getGroupValueAsInteger(START_DATE_PATTERN, YEARGROUP);
    }

    public Optional<Integer> getMonth() {
        return this.getGroupValueAsInteger(START_DATE_PATTERN, MONTHGROUP);
    }

    public Optional<RBC.WEEKDAYS> getWeekDay() {
        Optional<LocalDate> localDate = this.getLocalDate();
        if (localDate.isPresent()) {
            return Optional.empty();
        }
        String weekday = "";
        Pattern r = Pattern.compile(START_DATE_PATTERN);
        Matcher m = r.matcher(this.sdValue);
        if (m.matches()) {
            weekday = m.group(WEEKDAY_GROUP);
        }
        if (weekday == null) {
            weekday = "";
        }
        return switch (weekday) {
            case "su" -> Optional.of(RBC.WEEKDAYS.SUNDAY);
            case "mo" -> Optional.of(RBC.WEEKDAYS.MONDAY);
            case "tu" -> Optional.of(RBC.WEEKDAYS.TUESDAY);
            case "we" -> Optional.of(RBC.WEEKDAYS.WEDNESDAY);
            case "th" -> Optional.of(RBC.WEEKDAYS.THURSDAY);
            case "fr" -> Optional.of(RBC.WEEKDAYS.FRIDAY);
            case "sa" -> Optional.of(RBC.WEEKDAYS.SATURDAY);
            default -> Optional.empty();
        };
    }

    public Optional<Integer> getMonthDay() {
        String daysExpression;
        Optional<Integer> ret = Optional.empty();
        Pattern r = Pattern.compile(START_DATE_PATTERN);
        Matcher m = r.matcher(this.sdValue);
        if (m.find() && (daysExpression = m.group(DAYS_GROUP)) != null && !daysExpression.isEmpty()) {
            Integer days = Integer.valueOf(daysExpression);
            ret = Optional.of(days);
        }
        return ret;
    }

    public boolean isRelative() {
        return this.getSign().equals(RELATIVE_SIGN);
    }

    public boolean isRegistered() {
        return this.sdValue.matches("((?<RULENUMBER>\\d+)\\s*,\\s*)?en\\s*");
    }

    public String toString() {
        return "RuleStartDate [sdValue=" + this.sdValue + "]";
    }

    public boolean isBeforeEndMonthDays() {
        Optional<String> bExp = this.getGroupValue(START_DATE_PATTERN, B_GROUP);
        return bExp.isPresent();
    }

    public Optional<Integer> getBeforedays() {
        Optional<Integer> days = this.getGroupValueAsInteger(START_DATE_PATTERN, B_DAYS_GROUP);
        return days;
    }

    private Optional<Integer> getGroupValueAsInteger(String pattern, String groupName) {
        Optional<String> retString = this.getGroupValue(pattern, groupName);
        Optional<Integer> ret = Optional.empty();
        try {
            Integer result = Integer.parseInt(retString.get());
            ret = Optional.of(result);
        }
        catch (NumberFormatException | NoSuchElementException e) {
            ret = Optional.empty();
        }
        return ret;
    }

    private Optional<String> getGroupValue(String pattern, String groupName) {
        Optional<String> ret = Optional.empty();
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(this.sdValue);
        if (m.matches()) {
            String groupValue = m.group(groupName);
            ret = Optional.ofNullable(groupValue);
        }
        return ret;
    }
}

