/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.convertors;

import com.bmc.ctmconvert.common.transformer.workspaces.Folder;
import com.bmc.ctmconvert.common.transformer.workspaces.Workspace;
import com.bmc.ctmconvert.utils.Pair;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class Jp1FolderCreator {
    private Workspace workSpace;
    private UniqueValueGenerator uniqueValue;
    private List<String> jobnetTypes = Arrays.asList("n", "rn", "rr");

    public Jp1FolderCreator(Workspace workSpace) {
        this.workSpace = workSpace;
    }

    public Folder createFolder(UniqueValueGenerator uniqueValue, Optional<String> parentType, List<Pair<String, String>> entityAttributes) {
        this.uniqueValue = uniqueValue;
        String folderName = this.getFolderName(entityAttributes, parentType);
        Folder folder = this.workSpace.createFolder(folderName);
        return folder;
    }

    private String getUniqueTableName(String name) {
        return this.uniqueValue.getUniqueValue("TABLE_NAME", name, 64, "#", true);
    }

    private String getFolderName(List<Pair<String, String>> attributes, Optional<String> parentType) {
        String name = "";
        for (Pair<String, String> pair : attributes) {
            if (!((String)pair.getKey()).equals("UNIT_NAME")) continue;
            name = (String)pair.getValue();
            if (this.jobnetTypes.contains(parentType.orElse(""))) break;
            name = this.getUniqueTableName(name);
            break;
        }
        return name;
    }
}

