/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.convertors;

import com.bmc.ctmconvert.JP1Globals;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.dataObject.DataObject;
import com.bmc.ctmconvert.common.dataObject.OnMemoryStorer;
import com.bmc.ctmconvert.common.dataObject.query.DataObjectQuery;
import com.bmc.ctmconvert.common.dataObject.query.HasAttributeQuery;
import com.bmc.ctmconvert.common.message.MessageHandler;
import com.bmc.ctmconvert.common.transformer.workspaces.Folder;
import com.bmc.ctmconvert.common.transformer.workspaces.Job;
import com.bmc.ctmconvert.common.transformer.workspaces.Workspace;
import com.bmc.ctmconvert.common.transformer.workspaces.WorkspaceEntity;
import com.bmc.ctmconvert.jp1.Queries.JobNetsQuery;
import com.bmc.ctmconvert.jp1.Queries.JobsQuery;
import com.bmc.ctmconvert.jp1.actions.Action;
import com.bmc.ctmconvert.jp1.actions.ApplicationSetterAction;
import com.bmc.ctmconvert.jp1.actions.AutoEditPrmAction;
import com.bmc.ctmconvert.jp1.actions.NameSetterAction;
import com.bmc.ctmconvert.jp1.actions.SubApplicationSetterAction;
import com.bmc.ctmconvert.jp1.actions.TaskTypeAttributesAction;
import com.bmc.ctmconvert.jp1.convertors.DependecyFinder;
import com.bmc.ctmconvert.jp1.convertors.Jp1ActionsFactory;
import com.bmc.ctmconvert.jp1.convertors.Jp1FolderCreator;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.RulesAttributesList;
import com.bmc.ctmconvert.jp1.convertors.scheduling.Jp1Scheduler;
import com.bmc.ctmconvert.jp1.dependencies.DependencyRules;
import com.bmc.ctmconvert.jp1.dependencies.JobsCondition;
import com.bmc.ctmconvert.jp1.dependencies.NullDependencyRules;
import com.bmc.ctmconvert.jp1.message.Jp1MessageHandler;
import com.bmc.ctmconvert.utils.Pair;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import dependencies.DependencyAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Jp1Convertor {
    private final Jp1FolderCreator folderCreator;
    private final UniqueValueGenerator uniqueValue = new UniqueValueGenerator();
    private final Jp1ActionsFactory actionsFactory;
    private DependencyRules dependencyRules;
    private final Map<Integer, Integer> DataEntityToWorkspaceEntityMap = new HashMap<Integer, Integer>();
    public final OnMemoryStorer dataobject;
    private final Workspace workspace;

    public Jp1Convertor(OnMemoryStorer dataObject, Workspace workSpace) {
        this(dataObject, workSpace, new Jp1ActionsFactory());
    }

    public Jp1Convertor(OnMemoryStorer dataObject, Workspace workspace, Jp1ActionsFactory actionsFactory) {
        this.dataobject = dataObject;
        this.workspace = workspace;
        this.folderCreator = new Jp1FolderCreator(workspace);
        this.actionsFactory = actionsFactory;
        this.dependencyRules = new NullDependencyRules();
    }

    public Integer getEquivalentControlMEntity(int id) {
        if (!this.DataEntityToWorkspaceEntityMap.containsKey(id)) {
            throw new EntityNotFoundException(id);
        }
        return this.DataEntityToWorkspaceEntityMap.get(id);
    }

    public void setDependencyRules(DependencyRules dependencyRules) {
        this.dependencyRules = dependencyRules;
    }

    public void convert() {
        this.createFolders();
        this.createJobs();
        this.createHirarchy();
        this.createDependencies();
        this.createScheduling();
    }

    private void createScheduling() {
        Jp1Scheduler.DataObjectEntityToCtmJobResolver dataObjectEntityToCtmJobResolver = id -> {
            Integer ctmId = this.getEquivalentControlMEntity(id);
            return this.workspace.getEntityById(ctmId);
        };
        new Jp1Scheduler(this.dataobject, dataObjectEntityToCtmJobResolver).addSchedulingToJobs();
    }

    public void createFolders() {
        JobNetsQuery query = new JobNetsQuery();
        this.dataobject.stream().filterEntites((DataObjectQuery)query).forEachAttributes(this::createFolder);
    }

    private Optional<String> getParentType(int childID) {
        Integer parentID = this.getParentIDForChildID(childID);
        return this.getEntityType(parentID);
    }

    private Integer getParentIDForChildID(int childID) {
        OnMemoryStorer.OnMemoryStream stream = this.dataobject.stream();
        JobNetsQuery condition = new JobNetsQuery();
        HashMap ids = new HashMap();
        stream.filterEntites((DataObjectQuery)condition).forEachChildesIds(ids::put);
        return (Integer)ids.get(childID);
    }

    private Optional<String> getEntityType(Integer parentId) {
        String type = null;
        if (parentId != null) {
            List list = this.dataobject.getAttributes(parentId);
            for (Pair pair : list) {
                if (!((String)pair.getKey()).equals("ty")) continue;
                type = (String)pair.getValue();
                break;
            }
        }
        return Optional.ofNullable(type);
    }

    public void createJobs() {
        List<Action> jobActions = this.createJobActions();
        this.dataobject.stream().filterEntites((DataObjectQuery)new JobsQuery()).forEachAttributes((id, entityAttributes) -> {
            Job job = this.workspace.createJob("");
            job.setMessageHandler((MessageHandler)new Jp1MessageHandler(id, (DataObject)this.dataobject, (WorkspaceEntity)job));
            this.DataEntityToWorkspaceEntityMap.put(id, job.getId());
            for (Action action : jobActions) {
                action.act(id, (WorkspaceEntity)job);
            }
        });
    }

    private List<Action> createJobActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        NameSetterAction nameSetter = new NameSetterAction((DataObject)this.dataobject);
        actions.add(nameSetter);
        actions.add(this.actionsFactory.makeRunAsAction((DataObject)this.dataobject));
        actions.add(this.actionsFactory.makeNodeIdAction((DataObject)this.dataobject));
        actions.addAll(this.getCommonActions());
        AutoEditPrmAction autoEditPrmAction = new AutoEditPrmAction((DataObject)this.dataobject);
        actions.add(autoEditPrmAction);
        TaskTypeAttributesAction taskTypeAction = new TaskTypeAttributesAction((DataObject)this.dataobject);
        actions.add(taskTypeAction);
        return actions;
    }

    private void executeActions(int id, WorkspaceEntity job, List<Action> actions) {
        for (Action action : actions) {
            action.act(id, job);
        }
    }

    private void createFolder(int dataEntityId, List<Pair<String, String>> entityAttributes) {
        Optional<String> parentType = this.getParentType(dataEntityId);
        Folder folder = this.folderCreator.createFolder(this.uniqueValue, parentType, entityAttributes);
        folder.setMessageHandler((MessageHandler)new Jp1MessageHandler(dataEntityId, (DataObject)this.dataobject, (WorkspaceEntity)folder));
        this.issueMessageIfFolderNameChanged(dataEntityId, (WorkspaceEntity)folder);
        Integer folderId = folder.getId();
        List<Action> commonActions = this.getCommonActions();
        this.executeActions(dataEntityId, (WorkspaceEntity)folder, commonActions);
        this.handleFolderMessages((WorkspaceEntity)folder, entityAttributes);
        this.DataEntityToWorkspaceEntityMap.put(dataEntityId, folderId);
    }

    private void issueMessageIfFolderNameChanged(int dataEntityId, WorkspaceEntity folder) {
        String newName;
        boolean isNameChanged;
        Optional originalName = this.dataobject.findFirstAttribute("UNIT_NAME", Integer.valueOf(dataEntityId));
        boolean bl = isNameChanged = !originalName.equals(Optional.of(newName = folder.getName()));
        if (isNameChanged) {
            folder.addMessage("INF17500", new String[]{originalName.orElse(""), newName});
        }
    }

    private void handleFolderMessages(WorkspaceEntity folder, List<Pair<String, String>> entityAttributes) {
        for (Pair<String, String> pair : entityAttributes) {
            String attributeName = (String)pair.getKey();
            if (!RulesAttributesList.messagedAttributes.contains(attributeName)) continue;
            switch (attributeName) {
                case "ln": {
                    folder.addMessage("WRN17013", new String[]{(String)pair.getValue()});
                    break;
                }
                case "ed": {
                    folder.addMessage("WRN17014", new String[]{(String)pair.getValue()});
                    break;
                }
                case "ejn": {
                    folder.addMessage("WRN17015", new String[]{(String)pair.getValue()});
                }
            }
        }
    }

    private List<Action> getCommonActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        ApplicationSetterAction applicationAction = new ApplicationSetterAction((DataObject)this.dataobject);
        actions.add(applicationAction);
        SubApplicationSetterAction subApplicationAction = new SubApplicationSetterAction((DataObject)this.dataobject);
        actions.add(subApplicationAction);
        actions.add(this.actionsFactory.makeCreatedByAction((DataObject)this.dataobject));
        actions.add(this.actionsFactory.makeDescriptionAction((DataObject)this.dataobject));
        return actions;
    }

    public void createHirarchy() {
        JobNetsQuery jobNetQuery = new JobNetsQuery();
        this.dataobject.stream().filterEntites((DataObjectQuery)jobNetQuery).forEachChildesIds(this::insertChildToParent);
    }

    private void insertChildToParent(int childId, int parentId) {
        try {
            Integer ctmChildId = this.getEquivalentControlMEntity(childId);
            Integer ctmParentId = this.getEquivalentControlMEntity(parentId);
            this.workspace.insertChildToParent(ctmChildId.intValue(), ctmParentId.intValue());
        }
        catch (EntityNotFoundException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    public void createDependencies() {
        HasAttributeQuery condition = new HasAttributeQuery("ar");
        DataObject.SpecificAttributeHandler consumer = new DataObject.SpecificAttributeHandler(){

            public void handle(int id, String AttributeValue) {
                Integer ctmjobBId;
                Integer ctmjobAId;
                DependecyFinder finder = new DependecyFinder((DataObject)Jp1Convertor.this.dataobject, id, AttributeValue);
                Integer jobA_Id = finder.getJobAId();
                Integer jobB_Id = finder.getJobBId();
                try {
                    ctmjobAId = Jp1Convertor.this.getEquivalentControlMEntity(jobA_Id);
                    ctmjobBId = Jp1Convertor.this.getEquivalentControlMEntity(jobB_Id);
                }
                catch (EntityNotFoundException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                    return;
                }
                WorkspaceEntity entityA = Jp1Convertor.this.workspace.getEntityById(ctmjobAId);
                WorkspaceEntity entityB = Jp1Convertor.this.workspace.getEntityById(ctmjobBId);
                String relationType = "OUT_COND";
                Optional type = Jp1Convertor.this.dataobject.findFirstAttribute("ty", jobA_Id);
                if (type.isPresent() && "jdj".equalsIgnoreCase((String)type.get()) && finder.getRelationType().equalsIgnoreCase("con")) {
                    entityA.addMessage("WRN17003", new String[]{AttributeValue});
                }
                type = Jp1Convertor.this.dataobject.findFirstAttribute("ty", jobB_Id);
                JobsCondition.EndStatus endedStatus = JobsCondition.EndStatus.ENDED_OK;
                if (type.isPresent() && JP1Globals.UnitAttributes.RECOVERY_JOB_TYPES.contains(type.get())) {
                    relationType = "ON_DO_COND";
                    endedStatus = JobsCondition.EndStatus.ENDED_NOT_OK;
                }
                String condName = Jp1Convertor.this.dependencyRules.getConditionNameAndStatus(new JobsCondition(finder.getJobAId(), finder.getJobAName(), finder.getJobBName(), endedStatus));
                boolean addDeleteCond = Jp1Convertor.this.dependencyRules.needToCleanUp();
                boolean isEndedOK = endedStatus == JobsCondition.EndStatus.ENDED_OK;
                Jp1Convertor.this.workspace.addDependency(new DependencyAdapter(entityA, entityB, relationType, addDeleteCond, condName, isEndedOK));
            }
        };
        this.dataobject.stream().filterEntites((DataObjectQuery)condition).forEachEntityIdWithSpecificAttribute("ar", consumer);
    }

    private static class EntityNotFoundException
    extends RuntimeException {
        public EntityNotFoundException(int id) {
            super("id '" + id + "' not found");
        }
    }
}

