/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.convertors;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.calendars.CtmCalendar;
import com.bmc.ctmconvert.common.dataObject.Attributes;
import com.bmc.ctmconvert.jp1.convertors.JP1Calendar;
import com.bmc.ctmconvert.utils.Pair;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import com.bmc.ctmconvert.vc.EncodingValidator;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public class CalendarConvertor {
    private final UniqueValueGenerator uniqueValueGenerator = new UniqueValueGenerator();

    public JP1Calendar getCalendar(Integer groupId, List<Pair<String, String>> attributes) {
        return new InnerCalendarGetter(groupId, attributes).getCalendar();
    }

    private class InnerCalendarGetter {
        private final Integer groupId;
        private final String groupName;
        private final List<Pair<String, String>> attributes;
        private CtmCalendar openCalendar;
        private CtmCalendar closedCalendar;

        public InnerCalendarGetter(Integer groupId, List<Pair<String, String>> attributes) {
            this.groupId = groupId;
            this.groupName = this.getGroupName(new Attributes(attributes)).orElse("");
            this.attributes = attributes;
            this.setValidateCalendarsName();
            this.initByAttrs();
        }

        private Optional<String> getGroupName(Attributes attributes) {
            return attributes.findFirstValue("UNIT_NAME");
        }

        private void setValidateCalendarsName() {
            String validateOpenCalendarName = "";
            String validateClosedCalendarName = "";
            String originalCalendarName = this.groupName;
            boolean isLatin1Name = new EncodingValidator().isValidLatin1(this.groupName);
            if (isLatin1Name) {
                String openCalendarName = String.format("%s-%s", "WORKDAYS", this.groupName);
                String closedCalendarName = String.format("%s-%s", "NON_WORKDAYS", this.groupName);
                validateOpenCalendarName = FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", openCalendarName);
                validateClosedCalendarName = FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", closedCalendarName);
                validateOpenCalendarName = CalendarConvertor.this.uniqueValueGenerator.getUniqueValue("TAG_NAME", validateOpenCalendarName, 20);
                validateClosedCalendarName = CalendarConvertor.this.uniqueValueGenerator.getUniqueValue("TAG_NAME", validateClosedCalendarName, 20);
            } else {
                String newCalendarName = String.format("GROUP_%d", this.groupId);
                this.handleMeesages(originalCalendarName, newCalendarName);
                validateOpenCalendarName = String.format("%s-%s", "WORKDAYS", newCalendarName);
                validateClosedCalendarName = String.format("%s-%s", "NON_WORKDAYS", newCalendarName);
            }
            this.openCalendar = new CtmCalendar(validateOpenCalendarName, Params.instance().getDatacenterName());
            this.closedCalendar = new CtmCalendar(validateClosedCalendarName, Params.instance().getDatacenterName());
        }

        private void handleMeesages(String originName, String newGroupName) {
        }

        private void addOpenWeekday(String weekday) {
            for (LocalDate date : this.weekdayToDateList(weekday)) {
                this.openCalendar.addDay(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
            }
        }

        private void addOpenDate(String yyyymmdd) {
            LocalDate date = this.jp1DateToLocalDate(yyyymmdd);
            this.openCalendar.addDay(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
            this.closedCalendar.removeDay(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
        }

        private void addClosedWeekday(String weekday) {
            for (LocalDate date : this.weekdayToDateList(weekday)) {
                this.closedCalendar.addDay(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
            }
        }

        private void addClosedDates(Collection<String> closedList) {
            for (String yyyymmdd : closedList) {
                this.addClosedDate(yyyymmdd);
            }
        }

        private void addOpenDates(Collection<String> openList) {
            for (String yyyymmdd : openList) {
                this.addOpenDate(yyyymmdd);
            }
        }

        private void addClosedDate(String yyyymmdd) {
            LocalDate date = this.jp1DateToLocalDate(yyyymmdd);
            this.openCalendar.removeDay(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
            this.closedCalendar.addDay(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
        }

        private void initByAttrs() {
            HashSet<String> closedDateList = new HashSet<String>();
            HashSet<String> openDateList = new HashSet<String>();
            for (Pair<String, String> attr : this.attributes) {
                if (((String)attr.getKey()).equals("op")) {
                    if (this.isWeekDayStr((String)attr.getValue())) {
                        this.addOpenWeekday((String)attr.getValue());
                        continue;
                    }
                    openDateList.add((String)attr.getValue());
                    continue;
                }
                if (!((String)attr.getKey()).equals("cl")) continue;
                if (this.isWeekDayStr((String)attr.getValue())) {
                    this.addClosedWeekday((String)attr.getValue());
                    continue;
                }
                closedDateList.add((String)attr.getValue());
            }
            this.addOpenDates(openDateList);
            this.addClosedDates(closedDateList);
        }

        private boolean isWeekDayStr(String value) {
            String[] weekdays = GlobalFunctions.getWeekDaysArray((String)"SUN");
            for (int i = 0; i < weekdays.length; ++i) {
                if (!weekdays[i].toLowerCase().startsWith(value.toLowerCase())) continue;
                return true;
            }
            return false;
        }

        private LocalDate jp1DateToLocalDate(String date) {
            DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy/MM/dd");
            return LocalDate.from(dateFormatter.parse(date));
        }

        private Collection<LocalDate> weekdayToDateList(String weekday) {
            LocalDate until = LocalDate.of(LocalDate.now().getYear() + 2, 12, 31);
            HashSet<LocalDate> toRet = new HashSet<LocalDate>();
            LocalDate toAdd = this.getFirstWeekdayStartingFrom(weekday, LocalDate.of(LocalDate.now().getYear() - 2, 1, 1));
            while (toAdd.isBefore(until)) {
                toRet.add(toAdd);
                toAdd = toAdd.plusDays(7L);
            }
            return toRet;
        }

        private LocalDate getFirstWeekdayStartingFrom(String weekday, LocalDate startDate) {
            while (!startDate.getDayOfWeek().toString().toLowerCase().startsWith(weekday.toLowerCase())) {
                startDate = startDate.plusDays(1L);
            }
            return startDate;
        }

        public JP1Calendar getCalendar() {
            return new JP1Calendar(this.groupName, this.openCalendar, this.closedCalendar);
        }
    }
}

