/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.Jp1DataObjectReciver;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.TopLevelAttrHolder;
import com.bmc.ctmconvert.common.dataObject.OnMemoryStorer;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.source_definition.NullSourceDefinitions;
import com.bmc.ctmconvert.common.transformer.workspaces.OnMemoryWorkspace;
import com.bmc.ctmconvert.common.transformer.workspaces.Workspace;
import com.bmc.ctmconvert.jp1.convertors.Jp1Convertor;
import com.bmc.ctmconvert.jp1.dependencies.Jp1DependencyRules;
import com.bmc.ctmconvert.rules.RuleManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Jp1GeneralSourceDefinitions
extends NullSourceDefinitions {
    private final Workspace workSpace = new OnMemoryWorkspace();
    private final List<String> generalMessages = new ArrayList<String>();

    public void init() throws ConvertorCancelClickException {
        this.init(Jp1DataObjectReciver.get());
    }

    public void init(OnMemoryStorer data) {
        Jp1Convertor convertor = new Jp1Convertor(data, this.workSpace);
        Jp1DependencyRules dependencyRules = new Jp1DependencyRules(RuleManager.instance().getCurrentRules());
        convertor.setDependencyRules(dependencyRules);
        convertor.convert();
    }

    public Workspace getWorkspace() {
        return this.workSpace;
    }

    public AttrHolderList getTopLevelEntities() {
        List topLevelIds = this.workSpace.getTopLevelEnteties();
        AttrHolderList ret = new AttrHolderList();
        for (Integer topLevelId : topLevelIds) {
            IntegerIdAttrHolder attributeHolder = new IntegerIdAttrHolder(topLevelId);
            ret.add((Object)attributeHolder);
        }
        return ret;
    }

    public boolean hasChildren(String entId) {
        return this.hasChildren(Integer.parseInt(entId));
    }

    public boolean hasChildren(int entId) {
        return this.workSpace.isFolder(entId);
    }

    public boolean isContainerEntity(IAttrHolder entAttr) {
        if (!(entAttr instanceof IntegerIdAttrHolder)) {
            return false;
        }
        Integer id = ((IntegerIdAttrHolder)entAttr).getIdNumber();
        return this.workSpace.isFolder(id.intValue());
    }

    public SchedEntity spawnJob(String table, IAttrHolder attributes) {
        if (!table.isEmpty()) {
            throw new TableMustBEmptyException();
        }
        if (!(attributes instanceof IntegerIdAttrHolder)) {
            throw new WorngAttributeHolderException();
        }
        IntegerIdAttrHolder idAttr = (IntegerIdAttrHolder)attributes;
        return this.workSpace.getEntityById(idAttr.getIdNumber()).getSchedEntity();
    }

    public void addGeneralMessage(String msgID, String reportDisplayKey, String ... msgParams) {
        Reporter.addMessage(this.generalMessages, (String)msgID, (String)reportDisplayKey, (String[])msgParams);
    }

    public ArrayList<String> getGeneralMessages() {
        return new ArrayList<String>(this.generalMessages);
    }

    public static class IntegerIdAttrHolder
    extends TopLevelAttrHolder {
        private static final long serialVersionUID = 5629414632699466689L;

        public IntegerIdAttrHolder(Integer id) {
            super(new String[0], new HashMap(), id.toString());
        }

        public Integer getIdNumber() {
            return Integer.parseInt(this.getIdValue());
        }
    }

    public class TableMustBEmptyException
    extends RuntimeException {
        private static final long serialVersionUID = -4867486046144114500L;
    }

    private static class WorngAttributeHolderException
    extends RuntimeException {
        private static final long serialVersionUID = 334646479754380327L;

        private WorngAttributeHolderException() {
        }
    }
}

