/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.AppData;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.dataObject.OnMemoryStorer;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.jp1.readers.CommentsToFileWriter;
import com.bmc.ctmconvert.jp1.readers.Jp1FileReader;
import com.bmc.ctmconvert.services.VendorDataManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class Jp1DataObjectReciver {
    public static OnMemoryStorer get() {
        AppData vendorData = (AppData)VendorDataManager.instance().getVendorData();
        String unitFileName = vendorData.getImportEntry("UNIT_DEFINITION_FILE").getDestinationFileName();
        File unitFile = new File(Params.instance().getDatasourcePath() + unitFileName);
        String path = Params.instance().getDatasourcePath() + "comments.txt";
        OnMemoryStorer storage = new OnMemoryStorer();
        try (CommentsToFileWriter commentHandler = new CommentsToFileWriter(path);){
            Jp1FileReader reader = new Jp1FileReader(new Jp1FileReader.UnitHandler(storage), commentHandler);
            reader.readFile(unitFile);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        Jp1DataObjectReciver.getCalendarFiles().forEach(calendarPath -> {
            try {
                storage.storeCalendar(calendarPath.getFileName().toString().replaceFirst("[.][^.]+$", ""), Files.readString(calendarPath));
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        });
        return storage;
    }

    private static List<Path> getCalendarFiles() {
        AppData vendorData = (AppData)VendorDataManager.instance().getVendorData();
        ImportEntry calendarEntry = vendorData.getImportEntry("CALENDAR_FILES_DIRECTORY");
        String calendarDirectory = calendarEntry.getDestinationFileName();
        ArrayList<Path> files = new ArrayList<Path>();
        try (DirectoryStream<Path> fileStream = Files.newDirectoryStream(Path.of(Params.instance().getDatasourcePath(), calendarDirectory));){
            fileStream.forEach(files::add);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        return files;
    }
}

