/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.session;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseSessionAttributes;
import com.bmc.ctmconvert.dollar_universe.Tree;
import com.bmc.ctmconvert.dollar_universe.hdpmu.HDPFactory;
import com.bmc.ctmconvert.dollar_universe.hdpmu.HDPRelationship;
import com.bmc.ctmconvert.dollar_universe.session.SessionEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class DollarUniverseSessionTree {
    private final List<SessionEntry> sessionEntryList;
    private final String sessionName;
    private final Tree<SessionElement> sessionTree;

    public DollarUniverseSessionTree(DollarUniverseSessionAttributes taskSession) {
        ArrayList<IAttrHolder> sessionAttributes = new ArrayList<IAttrHolder>();
        sessionAttributes.add(taskSession.getAttributes());
        this.sessionName = taskSession.getAttributes().getAttr("ses");
        sessionAttributes.addAll((Collection<IAttrHolder>)taskSession.getUprs());
        this.sessionEntryList = this.getSessionList(sessionAttributes);
        this.sessionTree = this.createSessionTree();
    }

    private Tree<SessionElement> createSessionTree() {
        Tree<SessionElement> sessions = new Tree();
        try {
            sessions = this.createSessionTreeFromEntryList();
        }
        catch (Exception e) {
            this.logError(e, "cannot creat session tree \n in Session:\n" + String.valueOf(this));
        }
        return sessions;
    }

    private Tree<SessionElement> createSessionTreeFromEntryList() {
        List<SessionEntry> entriesSortedByFather = this.getEntriesSortedByFather();
        SessionEntry firstEntry = entriesSortedByFather.get(0);
        SessionElement headerElement = new SessionElement(firstEntry.getFatherNumber(), firstEntry.getFatherUprocName(), firstEntry.isPathOK(), firstEntry.getNodeName());
        Tree<SessionElement> sessions = new Tree<SessionElement>(headerElement);
        for (SessionEntry sessionEntry : entriesSortedByFather) {
            this.insertEnrtyToTree(sessions, sessionEntry);
        }
        return sessions;
    }

    private void insertEnrtyToTree(Tree<SessionElement> sessionTree, SessionEntry sessionEntry) {
        Integer fatherNumber = sessionEntry.getFatherNumber();
        Optional<SessionElement> fatherElement = sessionTree.toList().stream().filter(this.isSessionElementHasNumber(fatherNumber)).findFirst();
        SessionElement sonElement = new SessionElement(sessionEntry);
        fatherElement.ifPresent(element -> sessionTree.addChild((SessionElement)element, sonElement));
    }

    public Predicate<SessionElement> isSessionElementHasNumber(Integer fatherNumber) {
        return element -> element.getUprocId().equals(fatherNumber);
    }

    private void logError(Exception e, String message) {
        ConversionLogger.getLogger().info(message);
        ConversionLogger.getLogger().info(e.getMessage());
    }

    private List<SessionEntry> getEntriesSortedByFather() {
        ArrayList<SessionEntry> ret = new ArrayList<SessionEntry>(this.sessionEntryList);
        ret.sort(Comparator.comparing(SessionEntry::getFatherNumber));
        return ret;
    }

    private List<SessionEntry> getSessionList(List<IAttrHolder> sessionAttributes) {
        ArrayList<SessionEntry> ret = new ArrayList<SessionEntry>();
        for (IAttrHolder entryHolder : sessionAttributes) {
            SessionEntry entry = new SessionEntry(entryHolder, this);
            if (!entry.isValid()) continue;
            ret.add(entry);
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DollarUniverseSession [sessionName=").append(this.getSessionName()).append("\n");
        for (SessionEntry sessionEntry : this.sessionEntryList) {
            sb.append(sessionEntry).append("\n");
        }
        sb.append("]");
        return sb.toString();
    }

    public Tree<SessionElement> getSessionTree() {
        return this.sessionTree;
    }

    public List<SessionEntry> getSessionEntryList() {
        return this.sessionEntryList;
    }

    public boolean isValid() {
        return !this.sessionTree.isEmpty() && !this.sessionEntryList.isEmpty();
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public boolean isUprocInHdpContext(Integer uprocNumber) {
        return false;
    }

    public Set<String> getUprocMus(Integer fatherNumber) {
        return null;
    }

    public static class SessionElement {
        private final Integer uprocId;
        private final String originalName;
        private final boolean isPathOK;
        private HDPRelationship hdp;

        protected SessionElement(Integer uprocId, HDPRelationship hdpRelationship, String son, boolean isPathOK) {
            this.uprocId = uprocId;
            this.hdp = hdpRelationship;
            this.originalName = son;
            this.isPathOK = isPathOK;
        }

        protected SessionElement(Integer headerNumber, String son, boolean isPathOK, String commandNode) {
            this(headerNumber, new HDPFactory().makeRelationShip("", commandNode), son, isPathOK);
        }

        protected SessionElement(SessionEntry sessionEntry) {
            this(sessionEntry.getSonNumber(), sessionEntry.getHDPMU(), sessionEntry.getSonUprocName(), sessionEntry.isPathOK());
        }

        public Integer getUprocId() {
            return this.uprocId;
        }

        public HDPRelationship getHdpRelationship() {
            return this.hdp;
        }

        public void setHdpExpression(HDPRelationship hdp) {
            this.hdp = hdp;
        }

        public String getUprOriginalName() {
            return this.originalName;
        }

        public boolean isPathOK() {
            return this.isPathOK;
        }

        public String toString() {
            return "SessionElement [name=" + this.originalName + ", sessionNumber=" + this.uprocId + ", hdp=" + String.valueOf(this.hdp) + "]";
        }
    }
}

