/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.launch_window;

import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseTaskAttributes;
import com.bmc.ctmconvert.dollar_universe.launch_window.LaunchWindow;
import com.bmc.ctmconvert.dollar_universe.launch_window.MultiLaunchWindowATConvertor;
import com.bmc.ctmconvert.dollar_universe.launch_window.MultiLaunchWindowFROMConvertor;
import com.bmc.ctmconvert.dollar_universe.launch_window.MultiLaunchWindowTimeMatcher;
import java.util.Optional;

public class MultiLaunchWindowFactory {
    public DollarUniverseTaskAttributes sourceTaskDefinition;
    public DollarUniverseJob job;

    public MultiLaunchWindowFactory(DollarUniverseTaskAttributes sourceTaskDefinition, DollarUniverseJob jobDU) {
        this.job = jobDU;
        this.sourceTaskDefinition = sourceTaskDefinition;
    }

    public Optional<LaunchWindow> getMultiLuanchWindowConvertor() {
        Optional<String> elapse = this.getElapseTime();
        MultiLaunchWindowTimeMatcher multiLaunchWindowTimeMatcher = new MultiLaunchWindowTimeMatcher(elapse);
        Optional<LaunchWindow> launchWindow = Optional.empty();
        String mulw = this.sourceTaskDefinition.getAttributes().getAttr("mulw");
        if (multiLaunchWindowTimeMatcher.isLaunchWindowWithATOption(mulw)) {
            launchWindow = Optional.of(new MultiLaunchWindowATConvertor(this.job, mulw, elapse));
        } else if (multiLaunchWindowTimeMatcher.isLaunchWindowWithFROMOption(mulw)) {
            launchWindow = Optional.of(new MultiLaunchWindowFROMConvertor(this.job, mulw, elapse));
        }
        if (launchWindow.isPresent()) {
            ((LaunchWindow)launchWindow.get()).convertLaunchWindow();
        } else {
            this.job.addReporterMessage("WRN7033", this.job.getOriginalJobName(), mulw.replaceAll("\n", " "), this.job.getJobName());
        }
        return launchWindow;
    }

    private Optional<String> getElapseTime() {
        Optional<String> elapse = Optional.empty();
        String elapseAttr = this.sourceTaskDefinition.getAttributes().getAttr("elapse");
        if (elapseAttr != null && !elapseAttr.isEmpty()) {
            elapse = Optional.of(elapseAttr);
        }
        return elapse;
    }
}

