/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.launch_window;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import com.bmc.ctmconvert.dollar_universe.TimeToCalculator;
import com.bmc.ctmconvert.dollar_universe.launch_window.LaunchWindow;
import com.bmc.ctmconvert.dollar_universe.launch_window.MultiLaunchFROMWindowParser;
import com.bmc.ctmconvert.dollar_universe.launch_window.MultiLaunchWindowTimeMatcher;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class MultiLaunchWindowFROMConvertor
implements LaunchWindow {
    private HashMap<String, String> windowAttributes;
    private final Optional<String> elapse;
    private final DollarUniverseJob job;
    private final String mulw;
    private static final int MAX_TOLERANCE = 999;

    public MultiLaunchWindowFROMConvertor(DollarUniverseJob job, String mulw, Optional<String> elapse) {
        this.elapse = elapse;
        this.job = job;
        this.mulw = mulw;
        this.windowAttributes = new HashMap();
    }

    @Override
    public HashMap<String, String> getAttributes() {
        return this.windowAttributes;
    }

    @Override
    public void convertLaunchWindow() {
        this.windowAttributes = new HashMap();
        this.init(this.mulw);
    }

    private void init(String mulw) {
        List<String> windows = this.getTimes(mulw);
        if (windows.size() > 1) {
            this.windowAttributes.putAll(GlobalFunctions.attributesCyclicSpecificSequence((String)this.convertToSpecificTimes(windows)));
        } else {
            MultiLaunchFROMWindowParser parser = new MultiLaunchFROMWindowParser(windows.get(0));
            String fromTime = parser.getFromTime();
            String untilTime = parser.getUntilTime();
            String everyTime = parser.getEveryTime();
            TimeToCalculator.Time durationTime = parser.getDurationTime();
            this.windowAttributes.putAll(GlobalFunctions.attributesCyclicInterval((String)fromTime, (String)(everyTime + "M")));
            this.windowAttributes.put("TIMETO", untilTime);
            if (durationTime.getHourInDay() > 0 || durationTime.getMinutesInDAy() > 0) {
                this.job.addReporterMessage("WRN7039", this.job.getOriginalJobName(), this.job.getJobName(), String.format("%02d:%02d", durationTime.getHourInDay(), durationTime.getMinutesInDAy()));
            }
        }
    }

    private String convertToSpecificTimes(List<String> windows) {
        StringBuilder timeSequenceBuilder = new StringBuilder();
        for (String window : windows) {
            MultiLaunchFROMWindowParser parser = new MultiLaunchFROMWindowParser(window);
            if (!timeSequenceBuilder.isEmpty()) {
                timeSequenceBuilder.append(",");
            }
            timeSequenceBuilder.append(parser.generateTimeIntervals(timeSequenceBuilder));
            if (this.windowAttributes.containsKey("CYCLIC_TOLERANCE")) continue;
            int tolerance = parser.getDurationTotalMinutes();
            if (tolerance > 999) {
                this.job.addReporterMessage("WRN7030", this.job.getOriginalJobName(), String.valueOf(tolerance));
                tolerance = 999;
            }
            this.windowAttributes.put("CYCLIC_TOLERANCE", String.valueOf(tolerance));
        }
        return timeSequenceBuilder.toString();
    }

    private List<String> getTimes(String mulw) {
        MultiLaunchWindowTimeMatcher timeMatcher = new MultiLaunchWindowTimeMatcher(this.elapse);
        return timeMatcher.getTimesOfFROMWindowOption(mulw);
    }
}

