/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.launch_window;

import com.bmc.ctmconvert.dollar_universe.TimeToCalculator;
import com.bmc.ctmconvert.dollar_universe.launch_window.TimePattern;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MultiLaunchATWindowParser {
    private String mulwRow;
    private Optional<String> elapse;
    private Integer windowHours;
    private Integer windowMinutes;

    public MultiLaunchATWindowParser(String mulwRow) {
        this(mulwRow, Optional.empty());
    }

    public MultiLaunchATWindowParser(String multiWindow, Optional<String> elapse) {
        this.elapse = elapse;
        this.mulwRow = multiWindow;
        this.initTimeWindow();
    }

    public String getMulwTimeAsString() {
        String timeFormat = "(?<TIME>[0-9]{4})";
        TimePattern timePattern = new TimePattern(timeFormat, this.mulwRow);
        String ret = timePattern.getPattern("TIME");
        return ret;
    }

    public TimeToCalculator.Time getMulwTime() {
        Integer minutes;
        Integer hour;
        String timeAsString = this.getMulwTimeAsString();
        String timeFormat = "(?<HOUR>[0-9]{2})(?<MINUTES>[0-9]{2})";
        TimePattern timePattern = new TimePattern(timeFormat, timeAsString);
        String hourAsString = timePattern.getPattern("HOUR");
        String minutesAsString = timePattern.getPattern("MINUTES");
        try {
            hour = Integer.valueOf(hourAsString);
            minutes = Integer.valueOf(minutesAsString);
        }
        catch (NumberFormatException e) {
            hour = 0;
            minutes = 0;
        }
        TimeToCalculator.Time time = new TimeToCalculator.Time(hour, minutes);
        return time;
    }

    public Integer getTolarance() {
        Integer tolaranceInMinutes = null;
        if (this.windowHours != null && this.windowMinutes != null) {
            tolaranceInMinutes = this.windowHours * 60 + this.windowMinutes;
        }
        return tolaranceInMinutes;
    }

    private void initTimeWindow() {
        String mulwRow = this.elapse.orElse(this.mulwRow);
        String timePattern = ".*(?<HOURS>[0-9]{3}),(?<MINUTES>[0-9]{2})";
        Pattern compiledTimePattern = Pattern.compile(timePattern);
        Matcher timeMatcher = compiledTimePattern.matcher(mulwRow);
        if (timeMatcher.find()) {
            this.windowHours = Integer.parseInt(timeMatcher.group("HOURS"));
            this.windowMinutes = Integer.parseInt(timeMatcher.group("MINUTES"));
        }
    }

    public TimeToCalculator.Time getWindowTime() {
        TimeToCalculator.Time ret = null;
        if (this.windowHours != null && this.windowMinutes != null) {
            ret = new TimeToCalculator.Time(this.windowHours, this.windowMinutes);
        }
        return ret;
    }
}

