/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.hdpmu;

import com.bmc.ctmconvert.dollar_universe.hdpmu.HDPRelationship;
import com.bmc.ctmconvert.dollar_universe.hdpmu.MuHierarchy;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BrothersRelationship
extends HDPRelationship
implements HDPRelationship.TypedReleaionship {
    private String childType;
    private String parentType;
    public static final String BROTHERS_PATTERN = "\\{([a-zA-Z0-9_])([a-zA-Z0-9_])\\}";
    private static final String HDP_BROTHERS_GROUP_FORMAT = "%s%s_%s";

    public BrothersRelationship(String hdpExpr, String commandNode) {
        super(hdpExpr, commandNode);
        Pattern pattern = Pattern.compile(BROTHERS_PATTERN);
        Matcher matcher = pattern.matcher(hdpExpr);
        if (matcher.matches()) {
            this.childType = matcher.group(1);
            this.parentType = matcher.group(2);
        }
    }

    @Override
    public String getRelationshipString() {
        return String.format(HDP_BROTHERS_GROUP_FORMAT, new Object[]{this.childType, this.parentType, HDPRelationship.HDPRelationShip.BROTHERS});
    }

    @Override
    public Set<String> resolveNodes(String currentMu, MuHierarchy muHierarchy) {
        HashSet<String> allBrothers = new HashSet<String>();
        Set<String> allparent = muHierarchy.getParents(currentMu);
        Set<String> parentByType = this.filterType(allparent, this.parentType);
        for (String parent : parentByType) {
            Set<String> allchilds = muHierarchy.getChildren(parent);
            Set<String> childsByType = this.filterType(allchilds, this.childType);
            allBrothers.addAll(childsByType);
        }
        allBrothers.remove(currentMu);
        return allBrothers;
    }

    @Override
    public String toString() {
        return "BrothersRelationship [childType=" + this.childType + ", parentType=" + this.parentType + ", getName()=" + this.getRelationshipString() + "]";
    }

    @Override
    public Boolean isHdp() {
        return true;
    }

    @Override
    public HDPRelationship.HDPRelationShip getRelationship() {
        return HDPRelationship.HDPRelationShip.BROTHERS;
    }

    @Override
    public String getType() {
        return this.childType + this.parentType;
    }
}

