/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.handlers;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseSessionAttributes;
import com.bmc.ctmconvert.dollar_universe.UprTable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SessionUprocsUsageHandler {
    private Set<String> inUseUprocs;
    private Set<String> inUseSessions;
    private Map<String, DollarUniverseSessionAttributes> sessionNameTosessionAttributes;

    public SessionUprocsUsageHandler(Map<String, DollarUniverseSessionAttributes> sessionNameTosessionAttributes, Set<String> inUseSessions) {
        this.sessionNameTosessionAttributes = sessionNameTosessionAttributes;
        this.inUseSessions = inUseSessions;
        this.inUseUprocs = new HashSet<String>();
    }

    public void collectUprocsFromInUseSessions() {
        for (String session : this.inUseSessions) {
            DollarUniverseSessionAttributes sessionAttributes = this.sessionNameTosessionAttributes.get(session);
            if (sessionAttributes == null) continue;
            String nodeName = sessionAttributes.getNodeName();
            String headerName = UprTable.getUprID(sessionAttributes.getHeaderUprName(), nodeName);
            this.inUseUprocs.add(headerName);
            AttrHolderList uprocs = sessionAttributes.getUprs();
            for (IAttrHolder uproc : uprocs) {
                String uprName = UprTable.getUprID(uproc.getAttr("Son"), nodeName);
                this.inUseUprocs.add(uprName);
            }
        }
    }

    public Set<String> getUprocsFromInUseSessions() {
        return new HashSet<String>(this.inUseUprocs);
    }
}

