/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.handlers;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseDefs;
import com.bmc.ctmconvert.dollar_universe.handlers.HandlerDepcon;
import com.bmc.ctmconvert.dollar_universe.handlers.HandlerRescon;
import com.bmc.ctmconvert.dollar_universe.handlers.HandlerSap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;

public class ExtensionHandler {
    private HashMap<String, IAttrHolder> m_UprsIncconUpr = new HashMap();
    private HandlerDepcon handlerDepcon;
    private HandlerRescon handlerRescon;
    private HandlerSap handlerSap;

    public ExtensionHandler(HandlerDepcon handlerDepcon, HandlerRescon handlerRescon) {
        this.handlerDepcon = handlerDepcon;
        this.handlerRescon = handlerRescon;
        this.handlerSap = new HandlerSap();
    }

    public void handleExtension(IAttrHolder upr) {
        this.handlerDepcon.updateDepconLists(upr);
        this.handlerRescon.updateResconLists(upr);
        this.handlerSap.updateNameMap(upr);
        this.updateIncconLists(upr);
    }

    private void updateIncconLists(IAttrHolder upr) {
        String type = upr.getAttr("ENTRY_TYPE");
        if (!type.equalsIgnoreCase("inccon")) {
            return;
        }
        String uprId = upr.getAttr("PARENT_UPR");
        String condno = upr.getAttr("condno");
        String res = upr.getAttr("inc");
        if (res.isEmpty()) {
            return;
        }
        String key = this.buildDepconKey(uprId, condno);
        this.m_UprsIncconUpr.put(key, upr);
    }

    public IAttrHolder getUprsDepconByUpr(String uprId, String condno) {
        return this.handlerDepcon.getUprsDepconByUpr(uprId, condno);
    }

    public IAttrHolder getUprsIncconByUpr(String uprId, String condno) {
        String key = this.buildDepconKey(uprId, condno);
        return this.m_UprsIncconUpr.get(key);
    }

    public AttrHolderList getUprsDepconByDep(String dep) {
        return this.handlerDepcon.getUprsDepconByDep(dep);
    }

    public IAttrHolder getUprsResconByUpr(String uprId, String condno) {
        return this.handlerRescon.getUprsResconByUpr(uprId, condno);
    }

    public String buildDepconKey(String dep, String condno) {
        return dep + DollarUniverseDefs.HASH_SEPARATOR + condno;
    }

    public Optional<ArrayList<String>> getInconditionNameByUprName(String uprName) {
        return this.handlerDepcon.getInconditionNameByUprName(uprName);
    }

    public Optional<AttrHolderList> getUprsResconsByUpr(String uprId) {
        return this.handlerRescon.getUprsResconsByUpr(uprId);
    }

    public boolean isSapUpr(String uprId) {
        return this.handlerSap.isUprSap(uprId);
    }

    public String getSapName(String uprId) {
        return this.handlerSap.getSapName(uprId);
    }
}

