/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.dollar_universe.DollarUniverseGlobals;
import com.csvreader.CsvWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Uproc2csv {
    private static String nodeName = "";
    private String pastNode = null;
    private boolean thereIsAnode = false;
    private static final String SAP_XBP_2_STEP = "sap_xbp2_step";
    private static final String SAP_XBP_2_STEP_PR = "sap_xbp2_step_pr";
    private static final String SAP_XBP_2_STEP_AR = "sap_xbp2_step_ar";
    private final String[] subEntries = new String[]{"launchvar", "depcon", "inccon", "rescon", "ftp_get", "ftp_put", "termins", "sap_xbp2_step_ar", "sap_xbp2_step_pr", "sap_xbp2_step", "sap_xbp2", "sap_pchain", "sap_ipack"};
    private final List<Map<String, String>> entries = new ArrayList<Map<String, String>>();
    private final List<Map<String, String>> subEntryValues = new ArrayList<Map<String, String>>();
    private final Pattern condnoPattern = Pattern.compile("condno\\s*:.*");
    private final Pattern termnoPattern = Pattern.compile("termno\\s*:.*");
    private final Pattern resnoPattern = Pattern.compile("resno\\s*:.*");
    private final Pattern varnamePattern = Pattern.compile("varname\\s*:.*");
    private final Pattern newUprocPattern = Pattern.compile("\\s*TYPE\\s*\\|\\s*UPR\\s*");
    private final Pattern nodeNamePattern = Pattern.compile("( *)Command( *):( *)(.*)node=(\\S*)");
    private final Pattern CommandPattern = Pattern.compile("^\\s*Command\\s*:(.*)");
    private final Pattern keyValuePattern = Pattern.compile("\\s*(ITEMS)?\\s*\\|\\s*(\\S+)\\s*(:\\s*(.*))");

    private void updateToTheNextNode(String line) {
        Matcher matcher = this.nodeNamePattern.matcher(line);
        if (matcher.find()) {
            this.thereIsAnode = true;
            String node_Name = matcher.group(5);
            if (!node_Name.isEmpty()) {
                if (this.pastNode != null) {
                    this.pastNode = nodeName;
                    nodeName = node_Name;
                } else {
                    this.pastNode = node_Name;
                    nodeName = node_Name;
                }
            }
        }
    }

    public void readEntries(InputStream sourceUprStream) throws IOException {
        String currLine;
        InputStreamReader uprReader = new InputStreamReader(sourceUprStream);
        BufferedReader input = new BufferedReader(uprReader);
        HashMap<String, String> currentEntry = new HashMap<String, String>();
        StringBuilder value = new StringBuilder();
        String key = "";
        while ((currLine = input.readLine()) != null) {
            currLine = this.removeJclDelimiter(currLine);
            this.updateToTheNextNode(currLine);
            if (this.newUprocPattern.matcher(currLine.toUpperCase()).matches() || this.CommandPattern.matcher(currLine).matches()) {
                if (!currentEntry.isEmpty()) {
                    if (!key.isEmpty()) {
                        currentEntry.put(key, value.toString());
                        key = "";
                        value.delete(0, value.length());
                    }
                    if (this.thereIsAnode) {
                        if (!this.pastNode.equals(nodeName) && this.nodeNamePattern.matcher(currLine).matches()) {
                            currentEntry.put("node_name", this.pastNode);
                            this.pastNode = nodeName;
                        } else {
                            currentEntry.put("node_name", nodeName);
                        }
                    } else {
                        currentEntry.put("node_name", "");
                    }
                    this.entries.add(currentEntry);
                }
                currentEntry = new HashMap();
                continue;
            }
            Matcher keyValMatcher = this.keyValuePattern.matcher(currLine);
            if (keyValMatcher.matches() && this.isKey(keyValMatcher.group(2))) {
                if (!key.isEmpty()) {
                    currentEntry.put(key, value.toString());
                }
                key = keyValMatcher.group(2);
                value.delete(0, value.length());
                value.append(keyValMatcher.group(4) == null ? "" : keyValMatcher.group(4));
                continue;
            }
            if (key.isEmpty() || currLine.trim().equals("|")) continue;
            value.append("\n").append(currLine);
        }
        input.close();
        if (!currentEntry.isEmpty()) {
            if (key != null && !key.isEmpty() && value.length() > 0) {
                currentEntry.put(key, value.toString());
            }
            if (this.thereIsAnode) {
                currentEntry.put("node_name", nodeName);
            } else {
                currentEntry.put("node_name", "");
            }
            this.entries.add(currentEntry);
        }
    }

    void processEntry(Map<String, String> entry) {
        String uprocName = entry.get("upr");
        String uprocNodeName = entry.get("node_name");
        for (String subEntry : this.subEntries) {
            Optional<String> subEntryValue = Optional.ofNullable(entry.get(subEntry));
            subEntryValue.ifPresent(s -> this.processSubEntry(subEntry, s.trim(), uprocName, uprocNodeName));
            entry.remove(subEntry);
        }
    }

    private boolean isMultipleStepEntry(String subEntryType, String key) {
        return subEntryType.equals(SapStepEntry.SAP_XBP_2_STEP.value) && key.equals(SapStepEntry.SAP_XBP_2_STEP.finishValue()) || subEntryType.equals(SapStepEntry.SAP_XBP_2_STEP_AR.value) && key.equals(SapStepEntry.SAP_XBP_2_STEP_AR.finishValue()) || subEntryType.equals(SapStepEntry.SAP_XBP_2_STEP_PR.value) && key.equals(SapStepEntry.SAP_XBP_2_STEP_PR.finishValue());
    }

    private void processSubEntry(String subEntryType, String subEntry, String parentName, String uprocNodeName) {
        if (subEntry == null || subEntry.isEmpty()) {
            return;
        }
        if (subEntry.startsWith("(") && subEntry.endsWith(")")) {
            subEntry = subEntry.substring(1, subEntry.length() - 1);
        }
        if (subEntry.trim().isEmpty()) {
            return;
        }
        String[] lines = subEntry.split("\\s*[\r\n]+\\s*");
        HashMap<String, Object> subEntHash = new HashMap<String, Object>();
        boolean multipleStepFlag = false;
        for (int i = 0; i < lines.length; ++i) {
            String[] keyValArr;
            lines[i] = lines[i].trim();
            if (lines[i].isEmpty() || lines[i].equals("[") || lines[i].equals("]") || lines[i].equals("|")) continue;
            subEntHash.put("NODE", uprocNodeName);
            if (this.isNewSubEntry(lines[i], subEntryType) && subEntHash.size() > 1) {
                subEntHash.put("PARENT_UPR", parentName.trim() + "_" + uprocNodeName);
                subEntHash.put("ENTRY_TYPE", subEntryType);
                this.subEntryValues.add(subEntHash);
                subEntHash = new HashMap();
            }
            if ((keyValArr = lines[i].split("\\s*:\\s*", 2)).length < 2) {
                subEntHash.put(lines[i], "TRUE");
            } else {
                subEntHash.put(keyValArr[0], keyValArr[1]);
            }
            if (!this.isMultipleStepEntry(subEntryType, keyValArr[0])) continue;
            multipleStepFlag = true;
            subEntHash.put("PARENT_UPR", parentName.trim() + "_" + uprocNodeName);
            subEntHash.put("ENTRY_TYPE", subEntryType);
            this.subEntryValues.add(subEntHash);
            subEntHash = new HashMap();
        }
        if (!subEntHash.isEmpty() && !multipleStepFlag) {
            subEntHash.put("PARENT_UPR", parentName.trim() + "_" + uprocNodeName);
            subEntHash.put("ENTRY_TYPE", subEntryType);
            this.subEntryValues.add(subEntHash);
        }
    }

    public void dumpUpr2csv(OutputStream uprCSVOutput, OutputStream uprCSVExtensionOutput) throws IOException {
        for (Map<String, String> entry : this.entries) {
            this.processEntry(entry);
        }
        String[] mainHeader = new String[DollarUniverseGlobals.UPROC_ATTRIBUTES.length - this.subEntries.length];
        HashSet ignored = new HashSet();
        Collections.addAll(ignored, this.subEntries);
        int j = 0;
        for (int i = 0; i < DollarUniverseGlobals.UPROC_ATTRIBUTES.length; ++i) {
            if (ignored.contains(DollarUniverseGlobals.UPROC_ATTRIBUTES[i])) continue;
            mainHeader[j++] = DollarUniverseGlobals.UPROC_ATTRIBUTES[i];
        }
        LinkedHashSet<String> usedKeys = new LinkedHashSet<String>();
        usedKeys.add("PARENT_UPR");
        usedKeys.add("ENTRY_TYPE");
        for (Map<String, String> entry : this.subEntryValues) {
            usedKeys.addAll(entry.keySet());
        }
        String[] subEntriesHeader = usedKeys.toArray(new String[0]);
        this.writeCsv(this.entries, DollarUniverseGlobals.UPROC_ATTRIBUTES, uprCSVOutput);
        this.writeCsv(this.subEntryValues, subEntriesHeader, uprCSVExtensionOutput);
    }

    boolean isNewSubEntry(String testStr, String subEntryType) {
        boolean singleValueSubEntryByDefault = false;
        Matcher condnoMatcher = this.condnoPattern.matcher(testStr);
        if (subEntryType.equals("depcon") || subEntryType.equals("inccon")) {
            return condnoMatcher.matches();
        }
        if (subEntryType.equals("tremins")) {
            return this.termnoPattern.matcher(testStr).matches();
        }
        if (subEntryType.equals("rescon")) {
            return this.resnoPattern.matcher(testStr).matches() || condnoMatcher.matches();
        }
        if (subEntryType.equals("launchvar")) {
            return this.varnamePattern.matcher(testStr).matches();
        }
        return singleValueSubEntryByDefault;
    }

    private boolean isKey(String suspect) {
        for (int i = 0; i < DollarUniverseGlobals.UPROC_ATTRIBUTES.length; ++i) {
            if (!suspect.trim().equalsIgnoreCase(DollarUniverseGlobals.UPROC_ATTRIBUTES[i])) continue;
            return true;
        }
        return false;
    }

    private void writeCsv(List<Map<String, String>> entriesList, String[] header, OutputStream outputStream) throws IOException {
        CsvWriter writer = new CsvWriter((Writer)new OutputStreamWriter(outputStream), ',');
        writer.writeRecord(header);
        for (Map<String, String> entry : entriesList) {
            String[] csvLine = new String[header.length];
            for (int i = 0; i < csvLine.length; ++i) {
                csvLine[i] = entry.get(header[i]);
            }
            writer.writeRecord(csvLine);
        }
        writer.close();
    }

    public List<Map<String, String>> getEntries() {
        return this.entries;
    }

    private String removeJclDelimiter(String line) {
        if (line != null && !line.isEmpty()) {
            line = line.replaceAll("^={50}$", "");
        }
        return line;
    }

    public List<Map<String, String>> getSubEntries() {
        return this.subEntryValues;
    }

    static enum SapStepEntry {
        SAP_XBP_2_STEP("sap_xbp2_step"),
        SAP_XBP_2_STEP_PR("sap_xbp2_step_pr"),
        SAP_XBP_2_STEP_AR("sap_xbp2_step_ar");

        private final String value;

        private SapStepEntry(String value) {
            this.value = value;
        }

        public String finishValue() {
            if (this.value.equals(Uproc2csv.SAP_XBP_2_STEP)) {
                return "language";
            }
            if (this.value.equals(Uproc2csv.SAP_XBP_2_STEP_PR)) {
                return "prcovsys";
            }
            if (this.value.equals(Uproc2csv.SAP_XBP_2_STEP_AR)) {
                return "arcver";
            }
            return "";
        }
    }
}

