/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseUprAttributes;
import com.bmc.ctmconvert.dollar_universe.handlers.ExtensionHandler;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class UprTable
extends CsvFile {
    private HashMap<String, DollarUniverseUprAttributes> m_Uprs = new HashMap();
    private ExtensionHandler extensionHandler;
    protected boolean variableParameters;
    private static Integer m_headerSize = 0;
    private static HashMap<String, Integer> m_header = new HashMap();
    private static Integer m_extensionHeaderSize = 0;
    private static HashMap<String, Integer> m_extensionHeader = new HashMap();

    public UprTable(ExtensionHandler extensionHandler) {
        this.extensionHandler = extensionHandler;
    }

    public void load(InputStream input) {
        this.variableParameters = false;
        this.load(input, false);
        m_headerSize = this.m_header2Index.size();
        m_header = this.m_header2Index;
    }

    public void loadExtension(InputStream input) {
        this.variableParameters = true;
        this.load(input, false);
        m_extensionHeaderSize = this.m_header2Index.size();
        m_extensionHeader = this.m_header2Index;
    }

    protected void handleRecord(IAttrHolder upr, int record_number) {
        if (this.variableParameters) {
            String uprId = upr.getAttr("PARENT_UPR");
            if (this.m_Uprs.containsKey(uprId)) {
                DollarUniverseUprAttributes uprAttr = this.m_Uprs.get(uprId);
                uprAttr.addVariableParameters(upr.getAttr("ENTRY_TYPE"), upr);
                this.extensionHandler.handleExtension(upr);
            }
        } else {
            String uprId = upr.getAttr("upr") + "_" + upr.getAttr("node_name");
            if (this.m_Uprs != null && !uprId.isEmpty() && !this.m_Uprs.containsKey(uprId)) {
                this.m_Uprs.put(uprId, new DollarUniverseUprAttributes(upr));
            }
        }
    }

    public HashMap<String, DollarUniverseUprAttributes> getUprs() {
        return this.m_Uprs;
    }

    public IAttrHolder getUprsDepconByUpr(String uprId, String condno) {
        return this.extensionHandler.getUprsDepconByUpr(uprId, condno);
    }

    public IAttrHolder getUprsIncconByUpr(String uprId, String condno) {
        return this.extensionHandler.getUprsIncconByUpr(uprId, condno);
    }

    public AttrHolderList getUprsDepconByDep(String dep) {
        return this.extensionHandler.getUprsDepconByDep(dep);
    }

    public IAttrHolder getUprsResconByUpr(String uprId, String condno) {
        return this.extensionHandler.getUprsResconByUpr(uprId, condno);
    }

    public Integer getUprTableHeaderSize() {
        return m_headerSize;
    }

    public Integer getUprTableAttrIndex(String attr) {
        return m_header.get(attr);
    }

    public Integer getUprExtensionTableHeaderSize() {
        return m_extensionHeaderSize;
    }

    public Integer getUprExtensionTableAttrIndex(String attr) {
        return m_extensionHeader.get(attr);
    }

    public Optional<ArrayList<String>> getInconditionNamesByUprName(String uprName) {
        return this.extensionHandler.getInconditionNameByUprName(uprName);
    }

    public Optional<AttrHolderList> getUprsResconsByUpr(String uprId) {
        return this.extensionHandler.getUprsResconsByUpr(uprId);
    }

    public boolean isSapUpr(String uprId) {
        return this.extensionHandler.isSapUpr(uprId);
    }

    public String getSapName(String uprId) {
        return this.extensionHandler.getSapName(uprId);
    }

    public static String getUprID(String uprName, String nodeName) {
        return uprName + "_" + nodeName;
    }

    public Map<String, DollarUniverseUprAttributes> getUprsByNode(String nodeName) {
        return this.m_Uprs.entrySet().stream().filter(entry -> ((DollarUniverseUprAttributes)entry.getValue()).getAttributes().getAttr("node_name").equals(nodeName)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @FunctionalInterface
    public static interface UprFunction {
        public IAttrHolder depconResconGetter(String var1, String var2);
    }
}

