/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.csvreader.CsvWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Task {
    private static String nodeName = "";
    private static int counter = 0;
    private CsvWriter taskSessionCSVWriter;
    private CsvWriter taskUPRCSVWriter;
    private TaskRecord nextRecord;
    private boolean taskWithSession;
    private boolean multiLineParam;
    private final StringBuilder multiLineValue;
    private String paramName;
    private final InputStream taskInput;
    private final OutputStream csvTaskSessionStream;
    private final OutputStream csvTaskUPRStream;

    public Task(File taskFile, String convertPath) throws FileNotFoundException {
        this(new FileInputStream(taskFile), new FileOutputStream(convertPath + "task_session.csv"), new FileOutputStream(convertPath + "task_upr.csv"));
    }

    public Task(InputStream inputStreamTask, OutputStream taskSession, OutputStream taskUPR) {
        this.taskInput = inputStreamTask;
        this.csvTaskSessionStream = taskSession;
        this.csvTaskUPRStream = taskUPR;
        this.multiLineValue = new StringBuilder();
        this.multiLineParam = false;
    }

    private boolean isParam(String param) {
        return List.of(Parameters.params).contains(param);
    }

    private boolean isBooleanParam(String param) {
        for (int i = 0; i < Parameters.booleanValuesParams.length; ++i) {
            if (!param.equals(Parameters.booleanValuesParams[i])) continue;
            return true;
        }
        return false;
    }

    private String findExpression(BufferedReader input, String expr) throws IOException {
        String line;
        while ((line = input.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            this.updateToTheNextNode(line);
            if (!line.matches(expr)) continue;
            return line;
        }
        return null;
    }

    private String findNextTask(BufferedReader input) throws IOException {
        String line = this.findExpression(input, "( *)TYPE( *)\\|( *)tsk( *)");
        if (line == null) {
            return null;
        }
        line = this.findExpression(input, "( *)ITEMS( *)\\|(.*)");
        if (line == null) {
            return null;
        }
        line = line.substring(line.indexOf(124));
        return line;
    }

    private void updateToTheNextNode(String line) {
        String nodeName;
        String regex = "( *)Command( *):( *)(.*)node=(\\S*)";
        Pattern pattern = Pattern.compile("( *)Command( *):( *)(.*)node=(\\S*)");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find() && !(nodeName = matcher.group(5)).isEmpty()) {
            Task.nodeName = nodeName;
        }
    }

    private String getTaskName(String input) {
        Pattern itemPattern = Pattern.compile("TSK\\((?<name>.*?)\\).*");
        Matcher matcher = itemPattern.matcher(input);
        if (matcher.matches()) {
            return matcher.group("name");
        }
        return input;
    }

    private boolean handleParameter(String line) {
        String paramValue;
        if (this.multiLineParam) {
            if (line.charAt(0) == '|') {
                if (this.isParam(this.paramName)) {
                    this.nextRecord.setValue(this.paramName, this.multiLineValue.toString());
                }
                this.multiLineParam = false;
                this.multiLineValue.delete(0, this.multiLineValue.length());
            } else {
                this.multiLineValue.append("\n");
                this.multiLineValue.append(line);
                return false;
            }
        }
        if (line.equals("|")) {
            return true;
        }
        int index = (line = line.substring(line.indexOf(124) + 1).trim()).indexOf(58);
        if (index >= 0) {
            this.paramName = line.substring(0, line.indexOf(58)).trim();
            paramValue = line.substring(line.indexOf(58) + 1).trim();
            if (this.paramName.equals("ses")) {
                boolean bl = this.taskWithSession = !paramValue.isEmpty();
            }
            if (this.paramName.equals("launchvar") || this.paramName.equals("mulw") || this.paramName.equals("rule")) {
                this.multiLineParam = true;
                this.multiLineValue.append(paramValue);
                return false;
            }
        } else {
            this.paramName = line;
            paramValue = this.isBooleanParam(this.paramName) ? this.paramName : line;
        }
        if (this.isParam(this.paramName)) {
            if (this.paramName.equals("tsk")) {
                this.nextRecord.setValue(this.paramName, this.getTaskName(paramValue));
            } else {
                this.nextRecord.setValue(this.paramName, paramValue);
            }
        }
        return false;
    }

    private void taskParameters(BufferedReader input, String readLine) throws IOException {
        String line;
        this.handleParameter(readLine);
        while ((line = input.readLine()) != null && ((line = line.trim()).isEmpty() || !this.handleParameter(line))) {
        }
        this.nextRecord.setValue("node name", nodeName);
        this.nextRecord.setId();
        if (this.taskWithSession) {
            this.taskSessionCSVWriter.writeRecord(this.nextRecord.getValues());
        } else {
            this.taskUPRCSVWriter.writeRecord(this.nextRecord.getValues());
        }
        this.nextRecord.initialize();
    }

    public void writeToCSV() {
        this.taskSessionCSVWriter = new CsvWriter((Writer)new OutputStreamWriter(this.csvTaskSessionStream), ',');
        this.taskUPRCSVWriter = new CsvWriter((Writer)new OutputStreamWriter(this.csvTaskUPRStream), ',');
        try {
            String line;
            this.taskSessionCSVWriter.writeRecord(Parameters.CSVTaskHeader);
            this.taskUPRCSVWriter.writeRecord(Parameters.CSVTaskHeader);
            InputStreamReader taskInputReader = new InputStreamReader(this.taskInput);
            BufferedReader tasksFile = new BufferedReader(taskInputReader);
            this.nextRecord = new TaskRecord();
            while ((line = this.findNextTask(tasksFile)) != null) {
                this.taskParameters(tasksFile, line);
            }
            this.taskSessionCSVWriter.close();
            this.taskUPRCSVWriter.close();
            tasksFile.close();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    public static class Parameters {
        public static final String ID = "ID";
        public static final String SES = "ses";
        public static final String VSES = "vses";
        public static final String UPR = "upr";
        public static final String VUPR = "vupr";
        public static final String MU = "mu";
        public static final String MODEL = "model";
        public static final String NOMODEL = "nomodel";
        public static final String TYPE = "type";
        public static final String USER = "user";
        public static final String PRINTER = "printer";
        public static final String PRTY = "prty";
        public static final String QUEUE = "queue";
        public static final String PDATE = "pdate";
        public static final String HOLD = "hold";
        public static final String NOHOLD = "nohold";
        public static final String DISABLE = "disable";
        public static final String ENABLE = "enable";
        public static final String NODENAME = "node name";
        public static final String MULT = "mult";
        public static final String NOMULT = "nomult";
        public static final String AUTOREL = "autorel";
        public static final String NOAUTOREL = "noautorel";
        public static final String FORCE = "force";
        public static final String NOFORCE = "noforce";
        public static final String CENTRAL = "central";
        public static final String NOCENTRAL = "nocentral";
        public static final String HISTORY = "history";
        public static final String NOHISTORY = "nohistory";
        public static final String RESTART = "restart";
        public static final String NORESTART = "norestart";
        public static final String SERIAL = "serial";
        public static final String PARALLEL = "parallel";
        public static final String RULE = "rule";
        public static final String SDATE = "sdate";
        public static final String EDATE = "edate";
        public static final String XDATE = "xdate";
        public static final String EXCLUSION = "exclusion";
        public static final String DALW = "dalw";
        public static final String MON = "mon";
        public static final String TUE = "tue";
        public static final String WED = "wed";
        public static final String THU = "thu";
        public static final String FRI = "fri";
        public static final String SAT = "sat";
        public static final String SUN = "sun";
        public static final String MULW = "mulw";
        public static final String ELAPSE = "elapse";
        public static final String RELW = "relw";
        public static final String PRLW = "prlw";
        public static final String CYCLICAL = "cyclical";
        public static final String LAUNCHVAR = "launchvar";
        public static final String OFFSET = "offset";
        public static final String TSK = "tsk";
        public static final String[] CSVTaskHeader = new String[]{"ID", "tsk", "ses", "vses", "upr", "vupr", "mu", "model", "type", "printer", "queue", "prty", "user", "hold", "force", "central", "restart", "serial", "parallel", "mult", "pdate", "offset", "rule", "sdate", "prlw", "autorel", "history", "edate", "xdate", "exclusion", "dalw", "mon", "tue", "wed", "thu", "fri", "sat", "sun", "mulw", "elapse", "relw", "cyclical", "launchvar", "disable", "enable", "node name"};
        public static final String[] params = new String[]{"ID", "tsk", "ses", "vses", "upr", "vupr", "mu", "model", "nomodel", "type", "printer", "queue", "prty", "user", "hold", "nohold", "force", "noforce", "central", "nocentral", "restart", "norestart", "serial", "parallel", "mult", "nomult", "pdate", "offset", "rule", "sdate", "prlw", "noautorel", "history", "nohistory", "edate", "xdate", "exclusion", "dalw", "mon", "tue", "wed", "thu", "fri", "sat", "sun", "mulw", "elapse", "relw", "cyclical", "launchvar", "disable", "enable", "node name"};
        public static final String[] dualParams = new String[]{"nohold", "nomult", "noautorel", "noforce", "nocentral", "nohistory", "norestart", "nomodel"};
        public static final String[] booleanValuesParams = new String[]{"serial", "parallel"};
    }

    public class TaskRecord {
        private final String[] recordValues = new String[Parameters.CSVTaskHeader.length];

        public TaskRecord() {
            this.initialize();
        }

        private int optionIndex(String option) {
            int i;
            String optionToFind = option;
            for (i = 0; i < Parameters.dualParams.length; ++i) {
                if (!option.equals(Parameters.dualParams[i])) continue;
                optionToFind = Parameters.dualParams[i].substring(2);
            }
            for (i = 0; i < Parameters.CSVTaskHeader.length; ++i) {
                if (!optionToFind.equals(Parameters.CSVTaskHeader[i])) continue;
                return i;
            }
            return -1;
        }

        public void setValue(String option, String value) {
            int index = this.optionIndex(option);
            if (index >= 0) {
                this.recordValues[index] = value;
            }
        }

        public String[] getValues() {
            return this.recordValues;
        }

        public void initialize() {
            for (int i = 0; i < Parameters.CSVTaskHeader.length; ++i) {
                this.recordValues[i] = "";
            }
        }

        public void setId() {
            this.recordValues[this.optionIndex((String)"ID")] = this.recordValues[this.optionIndex("tsk")] + "#" + this.recordValues[this.optionIndex("upr")] + "#" + this.recordValues[this.optionIndex("mu")];
            if (Task.this.taskWithSession) {
                this.recordValues[this.optionIndex((String)"ID")] = this.recordValues[this.optionIndex("ses")] + "#" + this.recordValues[this.optionIndex("ID")] + "#" + counter++;
            }
        }
    }
}

