/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseDefs;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseSessionAttributes;
import com.bmc.ctmconvert.utils.Pair;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class SessionTable
extends CsvFile {
    protected HashMap<String, DollarUniverseSessionAttributes> sessions = new HashMap();
    private HashMap<String, AttrHolderList> m_SessionsBySon = new HashMap();

    public void load(InputStream inputStream) {
        super.load(inputStream);
    }

    protected void handleRecord(IAttrHolder sessionToAdd, int record_number) {
        String sessionId = sessionToAdd.getAttr("ID");
        if (!sessionId.isEmpty()) {
            if (!this.sessions.containsKey(sessionId)) {
                DollarUniverseSessionAttributes sessionAttr = new DollarUniverseSessionAttributes(sessionToAdd);
                this.sessions.put(sessionId, sessionAttr);
            }
            String numS = sessionToAdd.getAttr("NumS");
            String sessionToAdd_nodeName = sessionToAdd.getAttr("node name");
            DollarUniverseSessionAttributes session = this.sessions.get(sessionId);
            String session_nodeName = session.getAttributes().getAttr("node name");
            if (!numS.equals("") && sessionToAdd_nodeName.equals(session_nodeName)) {
                session.appendUpr(sessionToAdd);
                this.updateSessionListBySon(sessionToAdd);
            }
        }
    }

    protected void updateSessionListBySon(IAttrHolder sessionToAdd) {
        this.updateSessionListByAttr(sessionToAdd, "NumS", "Son", this.m_SessionsBySon);
    }

    private void updateSessionListByAttr(IAttrHolder sessionToAdd, String numberAttr, String uprocNameAttr, HashMap<String, AttrHolderList> sessionHash) {
        String sessionId = sessionToAdd.getAttr("ses");
        String uprocNumber = sessionToAdd.getAttr(numberAttr);
        String uprocName = sessionToAdd.getAttr(uprocNameAttr);
        if (uprocName == null) {
            return;
        }
        String key = DollarUniverseDefs.buildJobIdKey(sessionId, uprocName, uprocNumber);
        AttrHolderList list = null;
        list = sessionHash.get(key);
        if (list == null) {
            list = new AttrHolderList();
            sessionHash.put(key, list);
        }
        list.add((Object)sessionToAdd);
    }

    public HashMap<String, DollarUniverseSessionAttributes> getSessions() {
        return this.sessions;
    }

    public AttrHolderList getSessionsBySon(String id, String son, String nums) {
        String key = DollarUniverseDefs.buildJobIdKey(id, son, nums);
        return this.m_SessionsBySon.get(key);
    }

    public boolean sessionHasSon(String sessionName, String sonName) {
        String id = sessionName + "#";
        for (String ses : this.sessions.keySet()) {
            if (!this.sessions.get(ses).getName().startsWith(id) || !this.sessions.get(ses).hasAson(sonName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "SessionTable [m_Sessions=" + String.valueOf(this.sessions) + "]";
    }

    public Map<String, DollarUniverseSessionAttributes> getSessionsByNode(String nodeName) {
        return this.sessions.entrySet().stream().filter(entry -> ((DollarUniverseSessionAttributes)entry.getValue()).getNodeName().equals(nodeName)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, Pair<String, String>> getSessionsHeaderAndTrailer() {
        return this.sessions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> new Pair((Object)((DollarUniverseSessionAttributes)it.getValue()).getHeaderUprName(), (Object)((DollarUniverseSessionAttributes)it.getValue()).getTrailerUprName())));
    }
}

