/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.dollar_universe.DollarUniverseGlobals;
import com.csvreader.CsvWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MU2csv {
    private OutputStream muCsv;
    private InputStream muDeatils;
    private String nodeName = "";

    public MU2csv(File muDetailsFile, File muCreatedFile) throws FileNotFoundException {
        this(new FileInputStream(muDetailsFile), new FileOutputStream(muCreatedFile));
    }

    public MU2csv(InputStream detailedStream, OutputStream createdStream) {
        this.muDeatils = detailedStream;
        this.muCsv = createdStream;
    }

    private void updateToTheNextNode(String line) {
        String nodeName;
        String regex = "( *)Command( *):( *)(.*)node=(\\S*)";
        Pattern pattern = Pattern.compile("( *)Command( *):( *)(.*)node=(\\S*)");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find() && !(nodeName = matcher.group(5)).isEmpty()) {
            this.nodeName = nodeName;
        }
    }

    public void writeToCSV() throws IOException {
        this.entries2csv(this.readEntries());
    }

    private ArrayList<HashMap<String, String>> readEntries() throws IOException {
        InputStreamReader inputReader = new InputStreamReader(this.muDeatils);
        BufferedReader inputStream = new BufferedReader(inputReader);
        ArrayList<HashMap<String, String>> toRet = new ArrayList<HashMap<String, String>>();
        Pattern keyValPat = Pattern.compile("\\s*(ITEMS)?\\s*\\|\\s*(\\S+)\\s*(:\\s*(.*))?");
        String currLine = null;
        HashMap<String, String> record = null;
        while ((currLine = inputStream.readLine()) != null) {
            Matcher matcher = keyValPat.matcher(currLine);
            this.updateToTheNextNode(currLine);
            if (currLine.toUpperCase().matches("\\s*TYPE\\s*\\|\\s*MU\\s*")) {
                if (record != null && !record.isEmpty()) {
                    toRet.add(record);
                }
                record = new HashMap<String, String>();
                record.put("node name", this.nodeName);
                continue;
            }
            if (!matcher.matches()) continue;
            String key = matcher.group(2);
            String value = matcher.group(4);
            if (key == null || value == null || record == null || key.isEmpty() || value.isEmpty()) continue;
            record.put(key, value);
        }
        inputStream.close();
        if (record != null && !record.isEmpty()) {
            toRet.add(record);
        }
        return toRet;
    }

    private void entries2csv(ArrayList<HashMap<String, String>> entries) throws IOException {
        CsvWriter writer = new CsvWriter((Writer)new OutputStreamWriter(this.muCsv), ',');
        writer.writeRecord(DollarUniverseGlobals.MU_ATTRIBUTES);
        for (HashMap<String, String> entry : entries) {
            writer.writeRecord(this.muMap2arr(entry));
        }
        writer.close();
    }

    private String[] muMap2arr(HashMap<String, String> entry) {
        String[] toRet = new String[DollarUniverseGlobals.MU_ATTRIBUTES.length];
        for (int i = 0; i < DollarUniverseGlobals.MU_ATTRIBUTES.length; ++i) {
            if (!entry.containsKey(DollarUniverseGlobals.MU_ATTRIBUTES[i])) continue;
            toRet[i] = entry.get(DollarUniverseGlobals.MU_ATTRIBUTES[i]);
        }
        return toRet;
    }
}

