/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe.Hdp.hostgroups;

import com.bmc.ctmconvert.dollar_universe.NodeGroup;
import com.bmc.ctmconvert.dollar_universe.SessionManipulator;
import com.bmc.ctmconvert.dollar_universe.hdpmu.HDPRelationship;
import com.bmc.ctmconvert.dollar_universe.hdpmu.MuHierarchy;
import com.bmc.ctmconvert.dollar_universe.session.DollarUniverseSession;
import com.bmc.ctmconvert.dollar_universe.session.MuResolver;
import com.bmc.ctmconvert.dollar_universe.session.SessionEntry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class RelationalHdpHostGroupsCreator
implements SessionManipulator.GroupsCreator {
    private BiFunction<String, String, String> muToPhysicalResolver;
    private MuHierarchy muHierarchy;

    public RelationalHdpHostGroupsCreator(MuHierarchy muHierarchy, BiFunction<String, String, String> muToPhysicalResolver) {
        this.muToPhysicalResolver = muToPhysicalResolver;
        this.muHierarchy = muHierarchy;
    }

    @Override
    public List<NodeGroup> getHostGroups(DollarUniverseSession session) {
        ArrayList<NodeGroup> hostGroups = new ArrayList<NodeGroup>();
        MuResolver muResolver = new MuResolver(this.muHierarchy, session);
        for (SessionEntry sessionEntry : session.getSessionEntryList()) {
            if (!sessionEntry.isUsingHdp()) continue;
            HashSet<String> fatherMus = muResolver.getUprocMus(sessionEntry.getFatherNumber());
            HDPRelationship sessionHdpmu = sessionEntry.getHDPMU();
            String nodeName = sessionEntry.getNodeName();
            Map<String, Set<String>> parentTosonMus = sessionHdpmu.resolveNodes(fatherMus, this.muHierarchy);
            parentTosonMus.forEach((fatherMu, childsMu) -> {
                String fatherPhysical = this.muToPhysicalResolver.apply((String)fatherMu, nodeName);
                fatherPhysical = fatherPhysical.toLowerCase();
                String nodeGroupName = sessionHdpmu.resolveNodeGroupName(fatherPhysical);
                Set<String> childsPhysicalMachines = childsMu.stream().map(mu -> this.muToPhysicalResolver.apply((String)mu, nodeName)).collect(Collectors.toSet());
                hostGroups.add(new NodeGroup(nodeGroupName, childsPhysicalMachines));
            });
        }
        return hostGroups;
    }
}

