/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.exceptions.ConvertorException;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.SAXException;

public class FileConfigurationConvertor {
    private static final String PARAMETER_ATTRIBUTE = "PARAMETER";
    private static final String MAP_ELEMENT = "MAP";
    private static final String VALUE_OF_ATTRIBUTE = "DEFAULT_IS_VALUE_OF";
    private static final String TO_ATTRIBUTE = "TO";
    private static final String KEY_ATTRIBUTE = "KEY";
    private static final String SWITCH_ATTRIBUTE = "SWITCH";
    private static final String YES_MATCH_PATTERN = "y|Y|yes|YES";
    private static final String MANDATORY_ATTRIBUTE = "MANDATORY";
    private static final String NAME_ATTRIBUTE = "NAME";
    private static final String AUTOEDIT2_ELEMENT = "AUTOEDIT2";
    private static final String ATTRIBUTE_ELEMENT = "ATTRIBUTE";
    private static final String CONTROL_M_PARAMETERS_ELEMENT = "CONTROL_M_PARAMETERS";
    private static final String MAPPING_ELEMENT = "MAPPING";
    private static final String DEFAULT_ATTRIBUTE = "DEFAULT";
    private static final String PASS_ALL_ATTRIBUTE = "PASS_ALL";
    private static final String VALUE_ATTRIBUTE = "VALUE";
    private static final String CONTROL_M_PARAMETER_ATTRIBUTE = "CONTROL_M_PARAMETER";
    private XmlElement mapElement;
    private HashMap<String, XmlElement> controlMName_element_Map = new HashMap();
    private HashMap<String, Boolean> controlMNameParameter_isUsed_Map = new HashMap();
    private HashMap<String, String> controlMNameParameter_value = new HashMap();
    private HashMap<String, String> vendorParameterTocontrolMParameterMap;

    public boolean loadConfigurations(String filePath) {
        XmlLoader xml = new XmlLoader();
        try {
            xml.loadFile((InputStream)new FileInputStream(filePath));
            XmlElement configurationElement = xml.getXmlElement();
            if (configurationElement == null) {
                return false;
            }
            this.mapElement = configurationElement.getFirstChildElementByName(MAPPING_ELEMENT);
            XmlElement controlMParametersElement = configurationElement.getFirstChildElementByName(CONTROL_M_PARAMETERS_ELEMENT);
            if (this.mapElement == null || controlMParametersElement == null) {
                return false;
            }
            List parameters2 = controlMParametersElement.getDirectchildsElementbyName(new String[]{AUTOEDIT2_ELEMENT, ATTRIBUTE_ELEMENT});
            this.vendorParameterTocontrolMParameterMap = this.mapElement.getDirectChildsElementKeyVAlueAttrByName(MAP_ELEMENT, PARAMETER_ATTRIBUTE, CONTROL_M_PARAMETER_ATTRIBUTE);
            if (parameters2 == null) {
                return true;
            }
            for (XmlElement xmlElement : parameters2) {
                if (!xmlElement.hasAttribute(NAME_ATTRIBUTE)) continue;
                String parameterName = xmlElement.getAttribute(NAME_ATTRIBUTE);
                this.controlMName_element_Map.put(parameterName, xmlElement);
                this.controlMNameParameter_isUsed_Map.put(parameterName, false);
            }
            return true;
        }
        catch (SAXException e) {
            ExceptionHandler.writeToExceptionFile((Exception)new ConvertorException(" sap mapping file '" + filePath + "' could not be loaded. the file is not exist or corrupted"));
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)new ConvertorException(" sap mapping file '" + filePath + "' could not be loaded. the file is not exist or corrupted"));
        }
        return false;
    }

    public String getEquivalentAutoEdit(String vendorPrameterName) {
        XmlElement controlMParameterElement = this.getControlMPrameterElement(vendorPrameterName);
        if (controlMParameterElement == null || !controlMParameterElement.getTagName().equals(AUTOEDIT2_ELEMENT)) {
            return null;
        }
        String controlMParameter = controlMParameterElement.getAttribute(VALUE_ATTRIBUTE);
        if (controlMParameter.isEmpty()) {
            return null;
        }
        return controlMParameter;
    }

    private XmlElement getControlMPrameterElement(String vendorPrameterName) {
        this.vendorParameterTocontrolMParameterMap.get(vendorPrameterName);
        String controlMParameterName = this.vendorParameterTocontrolMParameterMap.get(vendorPrameterName);
        if (!this.vendorParameterTocontrolMParameterMap.containsKey(vendorPrameterName) || controlMParameterName == null || controlMParameterName.isEmpty()) {
            return null;
        }
        return this.controlMName_element_Map.get(controlMParameterName);
    }

    public String getEquivalentParameterValue(String vendorParameterName, String vendorPrameterValue) {
        String ret = null;
        XmlElement vendorParameterElement = this.mapElement.getFirstChildElementByAttrValue(MAP_ELEMENT, PARAMETER_ATTRIBUTE, vendorParameterName);
        if (vendorParameterElement == null || !vendorParameterElement.hasAttribute(CONTROL_M_PARAMETER_ATTRIBUTE)) {
            return null;
        }
        List vendorValuesEntreis = vendorParameterElement.getAllDirectchildsElement();
        XmlElement vendorparameterValueElement = vendorParameterElement.getFirstChildElementByAttrValue(SWITCH_ATTRIBUTE, KEY_ATTRIBUTE, vendorPrameterValue);
        if (vendorValuesEntreis.isEmpty()) {
            if (!vendorPrameterValue.isEmpty() || vendorParameterElement.getAttribute(MANDATORY_ATTRIBUTE).matches(YES_MATCH_PATTERN)) {
                ret = vendorPrameterValue;
            }
        } else {
            ret = vendorparameterValueElement == null || !vendorparameterValueElement.hasAttribute(TO_ATTRIBUTE) ? this.getDefultValue(vendorParameterElement, vendorPrameterValue) : vendorparameterValueElement.getAttribute(TO_ATTRIBUTE);
        }
        if (ret != null) {
            String control_MParamaterName = vendorParameterElement.getAttribute(CONTROL_M_PARAMETER_ATTRIBUTE);
            this.controlMNameParameter_isUsed_Map.put(control_MParamaterName, true);
            this.controlMNameParameter_value.put(control_MParamaterName, ret);
        }
        return ret;
    }

    private String getDefultValue(XmlElement vendorparameterElement, String vendorValue) {
        if (vendorparameterElement.hasAttribute(PASS_ALL_ATTRIBUTE)) {
            return vendorValue;
        }
        if (vendorparameterElement.hasAttribute(DEFAULT_ATTRIBUTE)) {
            return vendorparameterElement.getAttribute(DEFAULT_ATTRIBUTE);
        }
        return null;
    }

    public HashMap<String, String> getLeftMandatoryAutoEdits() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String parameter : this.controlMNameParameter_isUsed_Map.keySet()) {
            boolean isUsed = this.controlMNameParameter_isUsed_Map.get(parameter);
            if (isUsed) continue;
            XmlElement parameterElement = this.controlMName_element_Map.get(parameter);
            if (parameterElement == null) {
                ConversionLogger.getLogger().info(String.valueOf(this.getClass()) + " : cannot find parameter \"" + parameter + "\" in configuration file");
                System.out.println(parameter + " is null\n");
                continue;
            }
            if (!parameterElement.getTagName().equals(AUTOEDIT2_ELEMENT)) continue;
            boolean isMandatoryParameter = parameterElement.getAttribute(MANDATORY_ATTRIBUTE).matches(YES_MATCH_PATTERN);
            String parameterValue = parameterElement.getAttribute(VALUE_ATTRIBUTE);
            String parameterDefaultValue = parameterElement.getAttribute(DEFAULT_ATTRIBUTE);
            if (isUsed || !isMandatoryParameter || parameterValue.isEmpty() || !parameterElement.hasAttribute(DEFAULT_ATTRIBUTE)) continue;
            ret.put(parameterValue, parameterDefaultValue);
        }
        return ret;
    }

    public HashMap<String, String> getLeftMandatoryAttributes() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String parameter : this.controlMNameParameter_isUsed_Map.keySet()) {
            boolean isUsed = this.controlMNameParameter_isUsed_Map.get(parameter);
            if (isUsed) continue;
            XmlElement parameterElement = this.controlMName_element_Map.get(parameter);
            if (parameterElement == null) {
                ConversionLogger.getLogger().info(String.valueOf(this.getClass()) + " : cannot find parameter \"" + parameter + "\" in configuration file");
                System.out.println(parameter + " is null\n");
                continue;
            }
            if (!parameterElement.getTagName().equals(ATTRIBUTE_ELEMENT)) continue;
            boolean isMandatoryParameter = parameterElement.getAttribute(MANDATORY_ATTRIBUTE).matches(YES_MATCH_PATTERN);
            String parameterValue = parameterElement.getAttribute(VALUE_ATTRIBUTE);
            String parameterDefaultValue = this.getParamterDefaultValue(parameterElement);
            if (isUsed || !isMandatoryParameter || parameterValue.isEmpty() || !parameterElement.hasAttribute(DEFAULT_ATTRIBUTE)) continue;
            ret.put(parameterValue, parameterDefaultValue);
        }
        return ret;
    }

    private String getParamterDefaultValue(XmlElement parameterElement) {
        String ret = null;
        ret = parameterElement.getAttribute(DEFAULT_ATTRIBUTE);
        if (!ret.isEmpty()) {
            return ret;
        }
        String anotherElementReffernce = parameterElement.getAttribute(VALUE_OF_ATTRIBUTE);
        if (!anotherElementReffernce.isEmpty() && this.controlMName_element_Map.containsKey(anotherElementReffernce)) {
            Boolean elementUsed = this.controlMNameParameter_isUsed_Map.get(anotherElementReffernce);
            ret = elementUsed != false ? this.controlMNameParameter_value.get(anotherElementReffernce) : this.controlMName_element_Map.get(anotherElementReffernce).getAttribute(DEFAULT_ATTRIBUTE);
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    public ArrayList<String> getControl_MParameters() {
        return new ArrayList<String>(this.controlMName_element_Map.keySet());
    }

    public void restart() {
        for (String parameter : this.controlMNameParameter_isUsed_Map.keySet()) {
            this.controlMNameParameter_isUsed_Map.put(parameter, false);
        }
        this.controlMNameParameter_value.clear();
    }
}

