/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DollarUniverseTimeZone {
    private static DollarUniverseTimeZone instance = null;
    private HashMap<String, String> controlmTimeZones = new HashMap();
    private Pattern tzPat;
    private Matcher tzMatch;
    private int confOffset;
    private String confTimeZone;

    private void init() {
        RulesDataSet rules = RuleManager.instance().getCurrentRules();
        String path = Globs.MODULES_DATA_DIR + Globs.DIRSEP;
        File ctmTimeZoneFile = new File(path + "ctmTimeZones.dat");
        this.confTimeZone = rules.getStringRule("DOLLAR UNIVERSE rules", new String[]{"TIMEZONE"});
        String pattern = "\\s*GMT(\\+|-)(\\d{1,2})\\s*";
        this.tzPat = Pattern.compile(pattern);
        this.tzMatch = this.tzPat.matcher(this.confTimeZone);
        if (this.tzMatch.matches()) {
            this.confOffset = Integer.valueOf(this.tzMatch.group(2)) * (this.tzMatch.group(1).equals("-") ? -1 : 1);
        }
        pattern = "\\s*(\\+|-)(\\d{2}):(\\d{2})\\s*";
        this.tzPat = Pattern.compile(pattern);
        try {
            String line;
            BufferedReader input = new BufferedReader(new FileReader(ctmTimeZoneFile));
            Pattern ctmTzPattern = Pattern.compile("^([^# \t]+)[ \t]*\\(((GMT[+-])([0-9]{1,2}):([0-9]{2}))\\)");
            while ((line = input.readLine()) != null) {
                Matcher tzMatcher;
                if ((line = line.trim()).isEmpty() || !(tzMatcher = ctmTzPattern.matcher(line)).matches()) continue;
                String tzName = tzMatcher.group(1);
                Integer hoursOffset = Integer.valueOf(tzMatcher.group(4));
                Integer minutesOffset = Integer.valueOf(tzMatcher.group(5));
                Object tzGmtOffset = "";
                if (hoursOffset != 0 || minutesOffset != 0) {
                    tzGmtOffset = (String)tzGmtOffset + tzMatcher.group(3);
                    tzGmtOffset = (String)tzGmtOffset + Integer.toString(hoursOffset);
                    if (minutesOffset != 0) {
                        tzGmtOffset = (String)tzGmtOffset + ":";
                        tzGmtOffset = (String)tzGmtOffset + (minutesOffset < 10 ? "0" : "");
                        tzGmtOffset = (String)tzGmtOffset + minutesOffset;
                    }
                } else {
                    tzGmtOffset = "GMT";
                }
                this.controlmTimeZones.put((String)tzGmtOffset, tzName);
            }
            input.close();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    private DollarUniverseTimeZone() {
        this.init();
    }

    public static DollarUniverseTimeZone getInstance() {
        if (instance == null) {
            instance = new DollarUniverseTimeZone();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    public String getTimeZoneName(DollarUniverseJob Job, String timeZoneOffset, String muName) {
        String toRet = null;
        this.tzMatch = this.tzPat.matcher(timeZoneOffset);
        if (this.tzMatch.matches()) {
            int offset = Integer.valueOf(this.tzMatch.group(2));
            if (Integer.valueOf(this.tzMatch.group(3)) == 0) {
                String timeZoneKey = "GMT" + (String)((offset = this.confOffset + offset * (this.tzMatch.group(1).equals("-") ? -1 : 1)) != 0 ? (offset < 0 ? "" : "+") + offset : "");
                toRet = this.controlmTimeZones.get(timeZoneKey);
            }
            if (toRet == null) {
                Reporter.addMessage(Job.getMessages(), (String)"WRN7015", (String)Job.getUniqueId(), (String[])new String[]{timeZoneOffset, Job.getAttr("JOBNAME"), muName, this.confTimeZone});
            } else if (toRet.equals(this.confTimeZone)) {
                toRet = null;
            }
        } else {
            Reporter.addMessage(Job.getMessages(), (String)"WRN7014", (String)Job.getUniqueId(), (String[])new String[]{timeZoneOffset, Job.getAttr("JOBNAME"), muName});
        }
        return toRet;
    }

    public boolean isCtmTz(String tz) {
        return this.controlmTimeZones.values().contains(tz);
    }
}

