/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseDefs;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseSessionAttributes;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseTaskAttributes;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseUprAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DollarUniverseReferencedEntitiesHandler {
    protected DollarUniverseDefs defs;
    private final Map<String, DollarUniverseTaskAttributes> TasksForTemplateUprocsMap;
    private final List<IAttrHolder> listOfTasksForTemplateUprocs;
    private final List<String> listOfNodes;
    private Boolean dataWithoutNodes;

    public DollarUniverseReferencedEntitiesHandler(DollarUniverseDefs dollarUniverseDefs) {
        this.defs = dollarUniverseDefs;
        this.TasksForTemplateUprocsMap = new HashMap<String, DollarUniverseTaskAttributes>();
        this.listOfTasksForTemplateUprocs = new ArrayList<IAttrHolder>();
        this.listOfNodes = new ArrayList<String>();
        this.dataWithoutNodes = false;
    }

    public void generateTasksForTemplateUprs() {
        List<String> nodesList = this.getAllNodes();
        if (nodesList.isEmpty()) {
            this.dataWithoutNodes = true;
            this.listOfTasksForTemplateUprocs.addAll(this.getTemplateUprocsTaskAttributesForNode(""));
        } else {
            for (String node : nodesList) {
                this.listOfTasksForTemplateUprocs.addAll(this.getTemplateUprocsTaskAttributesForNode(node));
            }
        }
    }

    private List<IAttrHolder> getTemplateUprocsTaskAttributesForNode(String nodeName) {
        ArrayList<IAttrHolder> listOfTaskAttributes = new ArrayList<IAttrHolder>();
        List<String> repeatedUprocs = nodeName.isEmpty() ? this.getTemplates("") : this.getTemplatesByNodeMap().get(nodeName);
        if (repeatedUprocs != null) {
            for (String uprocName : repeatedUprocs) {
                String sessionName = "TemplateJobs_" + nodeName;
                String taskID = uprocName + "_" + nodeName;
                AttrHolder taskAttributes = DollarUniverseDefs.getTaskAttr(taskID, sessionName, uprocName, nodeName);
                this.TasksForTemplateUprocsMap.put(taskID, new DollarUniverseTaskAttributes((IAttrHolder)taskAttributes));
                listOfTaskAttributes.add((IAttrHolder)taskAttributes);
                if (this.listOfNodes.contains(nodeName)) continue;
                this.listOfNodes.add(nodeName);
            }
        }
        return listOfTaskAttributes;
    }

    private List<String> getTemplates(String node) {
        Map<String, DollarUniverseUprAttributes> node_Uprs = this.defs.getUprsByNode(node);
        Map<String, DollarUniverseSessionAttributes> node_Sessions = this.defs.getSessionsByNode(node);
        List<String> UprsUsedOnSessions = this.getListOfUprsUsedOnSessions(node_Sessions);
        List<String> repeatedUprs = node_Uprs.values().stream().map(attributes -> attributes.getAttributes().getAttr("upr")).filter(uprName -> Collections.frequency(UprsUsedOnSessions, uprName) > 1).distinct().collect(Collectors.toList());
        return repeatedUprs;
    }

    private Map<String, List<String>> getTemplatesByNodeMap() {
        HashMap<String, List<String>> uprTemplatesByNodeMap = new HashMap<String, List<String>>();
        List<String> nodesList = this.getAllNodes();
        for (String node : nodesList) {
            List<String> repeatedUprs = this.getTemplates(node);
            if (repeatedUprs.isEmpty()) continue;
            uprTemplatesByNodeMap.put(node, repeatedUprs);
        }
        return uprTemplatesByNodeMap;
    }

    private List<String> getAllNodes() {
        return this.defs.getUprs().values().stream().map(value -> value.getAttributes().getAttr("node_name")).distinct().filter(it -> !it.isEmpty()).collect(Collectors.toList());
    }

    private List<String> getListOfUprsUsedOnSessions(Map<String, DollarUniverseSessionAttributes> node_Sessions) {
        return node_Sessions.values().stream().flatMap(value -> value.getUsedUprs().stream().distinct()).collect(Collectors.toList());
    }

    public Map<String, DollarUniverseTaskAttributes> getTasksForTemplateUprocsMap() {
        return this.TasksForTemplateUprocsMap;
    }

    public List<String> getListOfNodes() {
        return this.listOfNodes;
    }

    public boolean isDataWithoutNodes() {
        return this.dataWithoutNodes;
    }
}

