/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseCreateConditionByNewFormat;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseSessionsToTree;
import com.bmc.ctmconvert.dollar_universe.SessionTable;
import com.bmc.ctmconvert.dollar_universe.UprTable;
import com.bmc.ctmconvert.dollar_universe.session.DollarUniverseSessionTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DollarUniverseDependencies {
    private UprTable uprTable;
    private DollarUniverseSessionsToTree sessionToTree;

    public DollarUniverseDependencies(UprTable uprTable, SessionTable sessionTable) {
        this.uprTable = uprTable;
        this.sessionToTree = new DollarUniverseSessionsToTree(sessionTable);
    }

    public List<DollarUniverseCreateConditionByNewFormat.nameToNum> getDependUprsNamesFromSession(DollarUniverseCreateConditionByNewFormat.nameToNum uprName, String session, String nodeName) {
        List<DollarUniverseSessionTree.SessionElement> uprSons = this.sessionToTree.getUprSonsByNameAndSession(uprName, session, nodeName);
        ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum> sonsNames = this.getUprNamesAndNumbers(uprSons, nodeName);
        this.removeRepeatedElement(sonsNames);
        return sonsNames;
    }

    public List<DollarUniverseCreateConditionByNewFormat.nameToNum> getDependUprsNamesFromUprTable(DollarUniverseCreateConditionByNewFormat.nameToNum uprName, String session, String nodeName) {
        return this.deleteDuplicate(this.getDependUprsNamesFromSession(uprName, session, nodeName), this.getDepconUprsNames(uprName, session, nodeName));
    }

    @NotNull
    public List<DollarUniverseCreateConditionByNewFormat.nameToNum> getDepconUprsNames(DollarUniverseCreateConditionByNewFormat.nameToNum uprName, String session, String nodeName) {
        AttrHolderList depconUprs = this.uprTable.getUprsDepconByDep(uprName.name());
        ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum> depconUprNames = this.getUprNamesFromAttrHolder(depconUprs, session, nodeName);
        this.removeRepeatedElement(depconUprNames);
        return depconUprNames;
    }

    private List<DollarUniverseCreateConditionByNewFormat.nameToNum> deleteDuplicate(List<DollarUniverseCreateConditionByNewFormat.nameToNum> sonsNames, List<DollarUniverseCreateConditionByNewFormat.nameToNum> depconUprNames) {
        ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum> mergeList = new ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum>();
        boolean exist = false;
        for (int i = 0; i < depconUprNames.size(); ++i) {
            for (int j = 0; j < sonsNames.size(); ++j) {
                if (!depconUprNames.get(i).equals(sonsNames.get(j))) continue;
                exist = true;
            }
            if (!exist) {
                mergeList.add(depconUprNames.get(i));
            }
            exist = false;
        }
        return mergeList;
    }

    public DollarUniverseCreateConditionByNewFormat.nameToNum getNameUprOK(DollarUniverseCreateConditionByNewFormat.nameToNum uprFather, String uprSon, String session, String nodeName) {
        List<DollarUniverseSessionTree.SessionElement> uprSons = this.sessionToTree.getUprSonsByNameAndSession(uprFather, session, nodeName);
        List uprsWithSameSonName = uprSons.stream().filter(it -> it.getUprOriginalName().equals(uprSon)).collect(Collectors.toList());
        if (uprsWithSameSonName.isEmpty()) {
            return new DollarUniverseCreateConditionByNewFormat.nameToNum("", "");
        }
        DollarUniverseSessionTree.SessionElement upr = (DollarUniverseSessionTree.SessionElement)uprsWithSameSonName.get(0);
        String uprID = UprTable.getUprID(upr.getUprOriginalName(), nodeName);
        String formatNumS = DollarUniverseDependencies.getFormatNumS(upr.getUprocId());
        if (this.uprTable.isSapUpr(uprID)) {
            return new DollarUniverseCreateConditionByNewFormat.nameToNum(this.getRealName(uprID), formatNumS);
        }
        return new DollarUniverseCreateConditionByNewFormat.nameToNum(upr.getUprOriginalName(), formatNumS);
    }

    public List<DollarUniverseCreateConditionByNewFormat.nameToNum> getNameUprKO(DollarUniverseCreateConditionByNewFormat.nameToNum uprFather, String session, String nodeName) {
        ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum> uprsName = new ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum>();
        List<DollarUniverseSessionTree.SessionElement> uprSons = this.sessionToTree.getUprSonsByNameAndSession(uprFather, session, nodeName);
        for (DollarUniverseSessionTree.SessionElement upr : uprSons) {
            if (upr.isPathOK()) continue;
            String uprID = UprTable.getUprID(upr.getUprOriginalName(), nodeName);
            String formatNumS = DollarUniverseDependencies.getFormatNumS(upr.getUprocId());
            if (this.uprTable.isSapUpr(uprID)) {
                uprsName.add(new DollarUniverseCreateConditionByNewFormat.nameToNum(this.getRealName(uprID), formatNumS));
                continue;
            }
            uprsName.add(new DollarUniverseCreateConditionByNewFormat.nameToNum(upr.getUprOriginalName(), formatNumS));
        }
        return uprsName;
    }

    public static String getFormatNumS(int numS) {
        if (numS < 10) {
            return "000" + numS;
        }
        if (numS < 100) {
            return "00" + numS;
        }
        if (numS < 1000) {
            return "0" + numS;
        }
        return "" + numS;
    }

    private void removeRepeatedElement(ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum> sonsNames) {
        HashSet<DollarUniverseCreateConditionByNewFormat.nameToNum> hs = new HashSet<DollarUniverseCreateConditionByNewFormat.nameToNum>();
        hs.addAll(sonsNames);
        sonsNames.clear();
        sonsNames.addAll(hs);
    }

    private List<String> mergeLists(ArrayList<String> originalList, ArrayList<String> listToAdd) {
        ArrayList<String> ret = new ArrayList<String>(originalList);
        for (String uprName : listToAdd) {
            if (originalList.contains(uprName)) continue;
            ret.add(uprName);
        }
        return ret;
    }

    public List<Integer> getAllUprNums(String upr, String session, String nodeName) {
        return this.sessionToTree.getAllUprNums(upr, session, nodeName);
    }

    private ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum> getUprNamesAndNumbers(List<DollarUniverseSessionTree.SessionElement> uprs, String nodeName) {
        ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum> uprPairs = new ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum>();
        for (DollarUniverseSessionTree.SessionElement upr : uprs) {
            DollarUniverseCreateConditionByNewFormat.nameToNum nameUprAndNum = new DollarUniverseCreateConditionByNewFormat.nameToNum(upr.getUprOriginalName(), DollarUniverseDependencies.getFormatNumS(upr.getUprocId()));
            if (uprPairs.contains(nameUprAndNum) || !upr.isPathOK()) continue;
            nameUprAndNum = this.getRealName(upr, nodeName);
            uprPairs.add(nameUprAndNum);
        }
        return uprPairs;
    }

    private DollarUniverseCreateConditionByNewFormat.nameToNum getRealName(DollarUniverseSessionTree.SessionElement upr, String nodeName) {
        String uprID = UprTable.getUprID(upr.getUprOriginalName(), nodeName);
        if (this.uprTable.isSapUpr(uprID)) {
            return new DollarUniverseCreateConditionByNewFormat.nameToNum(this.uprTable.getSapName(uprID), DollarUniverseDependencies.getFormatNumS(upr.getUprocId()));
        }
        return new DollarUniverseCreateConditionByNewFormat.nameToNum(upr.getUprOriginalName(), DollarUniverseDependencies.getFormatNumS(upr.getUprocId()));
    }

    private ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum> getUprNamesFromAttrHolder(AttrHolderList uprs, String session, String nodeName) {
        ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum> uprNames = new ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum>();
        if (uprs != null) {
            for (IAttrHolder iAttrHolder : uprs) {
                if (!iAttrHolder.getAttr("NODE").equals(nodeName)) continue;
                if (iAttrHolder.getAttr("sess").equals("samerun")) {
                    ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum> names = this.getNameAndNums(iAttrHolder, session, nodeName);
                    uprNames.addAll(names);
                    continue;
                }
                if (this.uprTable.isSapUpr("PARENT_UPR")) {
                    uprNames.add(new DollarUniverseCreateConditionByNewFormat.nameToNum(this.getRealName("PARENT_UPR"), ""));
                    continue;
                }
                uprNames.add(new DollarUniverseCreateConditionByNewFormat.nameToNum(iAttrHolder.getAttr("PARENT_UPR"), ""));
            }
        }
        return uprNames;
    }

    private String getRealName(String uprId) {
        if (this.uprTable.isSapUpr(uprId)) {
            return this.uprTable.getSapName(uprId);
        }
        return null;
    }

    private ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum> getNameAndNums(IAttrHolder upr, String session, String nodeName) {
        ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum> uprNames = new ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum>();
        Optional<DollarUniverseSessionTree> sessionTree = this.sessionToTree.getTreeBysession(session, nodeName);
        if (!sessionTree.isEmpty()) {
            List<DollarUniverseSessionTree.SessionElement> sessionList = sessionTree.get().getSessionTree().getAllElements();
            for (int i = 0; i < sessionList.size(); ++i) {
                String uprID = UprTable.getUprID(sessionList.get(i).getUprOriginalName(), nodeName);
                if (!uprID.equals(upr.getAttr("PARENT_UPR"))) continue;
                String formatNumS = DollarUniverseDependencies.getFormatNumS(sessionList.get(i).getUprocId());
                DollarUniverseCreateConditionByNewFormat.nameToNum name = this.uprTable.isSapUpr(uprID) ? new DollarUniverseCreateConditionByNewFormat.nameToNum(this.getRealName(uprID), formatNumS) : new DollarUniverseCreateConditionByNewFormat.nameToNum(sessionList.get(i).getUprOriginalName(), formatNumS);
                uprNames.add(name);
            }
        }
        return uprNames;
    }

    public ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum> getInConditionsOfSessionByNameAndSession(DollarUniverseCreateConditionByNewFormat.nameToNum uprName, String session, String sessionNodeName) {
        ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum> inConditions = new ArrayList<DollarUniverseCreateConditionByNewFormat.nameToNum>();
        Optional<DollarUniverseSessionTree.SessionElement> uprFather = this.sessionToTree.getUprFatherByNameAndSession(uprName, session, sessionNodeName);
        if (uprFather.isPresent()) {
            String uprID = uprFather.get().getUprOriginalName() + sessionNodeName;
            if (this.uprTable.isSapUpr(uprID)) {
                inConditions.add(new DollarUniverseCreateConditionByNewFormat.nameToNum(this.getRealName(uprID), ""));
            } else {
                inConditions.add(new DollarUniverseCreateConditionByNewFormat.nameToNum(uprFather.get().getUprOriginalName(), DollarUniverseDependencies.getFormatNumS(uprFather.get().getUprocId())));
            }
        }
        return inConditions;
    }
}

