/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.CsvTable;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.dollar_universe.MUTable;
import com.bmc.ctmconvert.dollar_universe.RbcGenerator;
import com.bmc.ctmconvert.dollar_universe.ResourceConvertor;
import com.bmc.ctmconvert.dollar_universe.SessionTable;
import com.bmc.ctmconvert.dollar_universe.TaskTable;
import com.bmc.ctmconvert.dollar_universe.UprTable;
import com.bmc.ctmconvert.dollar_universe.handlers.ExtensionHandler;
import com.bmc.ctmconvert.dollar_universe.handlers.HandlerDepcon;
import com.bmc.ctmconvert.dollar_universe.handlers.HandlerRescon;
import com.bmc.ctmconvert.dollar_universe.hdpmu.MuDependenciesParser;
import com.bmc.ctmconvert.dollar_universe.hdpmu.MuHierarchy;
import com.bmc.ctmconvert.io.FileUtils;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.utils.UniqueConditionNameGenerator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class DollarUniverseData {
    private SessionTable sessionTable;
    private UprTable uprTable;
    private MUTable mUTable;
    private CsvTable sapTable;
    private TaskTable taskTable;
    private MuHierarchy muHierarchy;
    private ResourceConvertor resourceConvertor;
    private RbcGenerator rbcGenerator;
    private InputStream taskSesStream;
    private InputStream taskUprStream;
    private UniqueConditionNameGenerator uniqueConditionNameGenerator;

    public DollarUniverseData(UniqueConditionNameGenerator uniqueConditionNameGenerator) {
        this.uniqueConditionNameGenerator = uniqueConditionNameGenerator;
        this.init();
    }

    private void init() {
        this.sapTable = new CsvTable();
        this.sapTable.load(Params.instance().getDatasourcePath() + "sap_jobs.csv");
        this.sapTable.setPrimeryKey("UX_JOBNAME");
        this.sessionTable = this.creatSessionTable();
        this.uprTable = this.createUprTable();
        this.mUTable = this.createMuTable();
        this.muHierarchy = new MuHierarchy(new MuDependenciesParser().parse());
        this.resourceConvertor = this.createResourceConvertor(this.uniqueConditionNameGenerator);
        this.rbcGenerator = this.createRbcGenerator();
        this.taskSesStream = FileUtils.newInputStream((String)(Params.instance().getDatasourcePath() + "task_session.csv"));
        this.taskUprStream = FileUtils.newInputStream((String)(Params.instance().getDatasourcePath() + "task_upr.csv"));
    }

    private RbcGenerator createRbcGenerator() {
        String rulesPath = Params.instance().getDatasourcePath() + "Rules.csv";
        InputStream rules = this.createFileStreamOrEmpty(rulesPath);
        return new RbcGenerator(rules, RuleManager.instance().getCurrentRules());
    }

    private ResourceConvertor createResourceConvertor(UniqueConditionNameGenerator uniqueConditionNameGenerator) {
        String resourceFile = Params.instance().getDatasourcePath() + "Resources.csv";
        String uprExtenssionFile = Params.instance().getDatasourcePath() + "UPR_EXTENSION.csv";
        InputStream resourcesCsv = this.createFileStreamOrEmpty(resourceFile);
        InputStream uprExtenssionCsv = this.createFileStreamOrEmpty(uprExtenssionFile);
        ResourceConvertor resourceConvertor = new ResourceConvertor(resourcesCsv, uprExtenssionCsv, RuleManager.instance().getCurrentRules(), uniqueConditionNameGenerator);
        return resourceConvertor;
    }

    private InputStream createFileStreamOrEmpty(String filePath) {
        FileInputStream resourcesCsv;
        try {
            resourcesCsv = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundRunException("Empty Resource Convertor file");
        }
        return resourcesCsv;
    }

    private MUTable createMuTable() {
        MUTable m_instance = new MUTable();
        m_instance.load();
        return m_instance;
    }

    private UprTable createUprTable() {
        FileInputStream csvFileExt;
        ExtensionHandler extensionHandler = new ExtensionHandler(new HandlerDepcon(), new HandlerRescon());
        UprTable uprTable = new UprTable(extensionHandler);
        String csvFile = Params.instance().getDatasourcePath() + "UPR.csv";
        InputStream input = new ByteArrayInputStream("".getBytes());
        try {
            input = new FileInputStream(csvFile);
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundRunException("UPR.csv");
        }
        uprTable.load(input);
        try {
            csvFileExt = new FileInputStream(Params.instance().getDatasourcePath() + "UPR_EXTENSION.csv");
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundRunException("UPR_EXTENSION.csv");
        }
        uprTable.loadExtension(csvFileExt);
        return uprTable;
    }

    private SessionTable creatSessionTable() {
        SessionTable session = new SessionTable();
        Path csvFile = Paths.get(Params.instance().getDatasourcePath() + "session.csv", new String[0]);
        try {
            InputStream inputStream = Files.newInputStream(csvFile, new OpenOption[0]);
            session.load(inputStream);
        }
        catch (IOException e) {
            throw new FileNotFoundRunException("session.csv");
        }
        return session;
    }

    public SessionTable getSessionTable() {
        return this.sessionTable;
    }

    public UprTable getUprTable() {
        return this.uprTable;
    }

    public MUTable getmUTable() {
        return this.mUTable;
    }

    public TaskTable getTaskTable() {
        return this.taskTable;
    }

    public CsvTable getSapTable() {
        return this.sapTable;
    }

    public MuHierarchy getMuHierarchy() {
        return this.muHierarchy;
    }

    public ResourceConvertor getResourcrConvertor() {
        return this.resourceConvertor;
    }

    public RbcGenerator getRbcGenertor() {
        return this.rbcGenerator;
    }

    public InputStream getTaskSessionStream() {
        return this.taskSesStream;
    }

    public InputStream getTaskUprStream() {
        return this.taskUprStream;
    }

    public InputStream getDataMappingStream() {
        FileInputStream csvFileExt;
        try {
            File mapFile = new File(Params.instance().getDatasourcePath() + "AgentMapping.txt");
            if (!mapFile.exists()) {
                ExceptionHandler.writeToExceptionFile((String)("Management Unit - physical nodes map file" + mapFile.getName() + "not exists"));
                return null;
            }
            csvFileExt = new FileInputStream(mapFile);
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundRunException("AgentMapping");
        }
        return csvFileExt;
    }

    public class FileNotFoundRunException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public FileNotFoundRunException(String uprFile) {
            super("required File was not found " + uprFile);
        }
    }
}

