/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.conditions.InCondition;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseCreateConditionByNewFormat;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseDependencies;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseFormulaExtension;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseGlobals;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseJob;
import com.bmc.ctmconvert.dollar_universe.DollarUniverseSessionAttributes;
import com.bmc.ctmconvert.dollar_universe.ResourceConvertor;
import com.bmc.ctmconvert.dollar_universe.SessionTable;
import com.bmc.ctmconvert.dollar_universe.UprTable;
import com.bmc.ctmconvert.dollar_universe.handlers.HandleDepCondName;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.utils.PropertiesBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DollarUniverseCreateDefaultConditions {
    private static final String STATUS = "status";
    private static final String DEPCON_STATUS_ENDED = "ended";
    private static final String DEPCON_STATUS_ABORTED = "aborted";
    private final SessionTable sessionTable;
    private final UprTable uprTable;
    private final ResourceConvertor resourceConvertor;
    private boolean sessionInConditions;
    private boolean depconInConditions;
    private boolean resconInConditions;
    private final DollarUniverseFormulaExtension formulaExtension;
    private final DollarUniverseDependencies dependencies;
    private RulesDataSet rules;
    private DollarUniverseCreateConditionByNewFormat.nameToNum uprNameToNum;

    public DollarUniverseCreateDefaultConditions(SessionTable sessionTable, UprTable uprTable, ResourceConvertor resourceConvertor, boolean sessionInConditions, boolean depconInConditions, boolean resconInConditions, RulesDataSet rules) {
        this.dependencies = new DollarUniverseDependencies(uprTable, sessionTable);
        this.sessionTable = sessionTable;
        this.uprTable = uprTable;
        this.resourceConvertor = resourceConvertor;
        this.sessionInConditions = sessionInConditions;
        this.depconInConditions = depconInConditions;
        this.resconInConditions = resconInConditions;
        this.formulaExtension = new DollarUniverseFormulaExtension();
        this.rules = rules;
    }

    public void updateNameToNum(String name, String number) {
        this.uprNameToNum = new DollarUniverseCreateConditionByNewFormat.nameToNum(name, number);
    }

    public List<Properties> getJobInconds(SchedEntity job) {
        List<Properties> uprInCondition;
        ArrayList<Properties> jobInCondition = new ArrayList<Properties>();
        if (!(((DollarUniverseJob)job).isHeaderJob() || ((DollarUniverseJob)job).isStandAloneJob() || ((DollarUniverseJob)job).getHdpExpressionHendler().ishdp() || DollarUniverseCreateConditionByNewFormat.isFolder((DollarUniverseJob)job))) {
            Optional<List<Properties>> sessionInCondition = Optional.ofNullable(this.getJobSessionInConditions((DollarUniverseJob)job));
            sessionInCondition.ifPresent(it -> jobInCondition.addAll((Collection<Properties>)it));
        }
        if ((uprInCondition = this.getJobUprInconds((DollarUniverseJob)job)) != null) {
            jobInCondition.addAll(uprInCondition);
        }
        return jobInCondition;
    }

    public List<Properties> getJobSessionInConditions(DollarUniverseJob job) {
        String numS;
        String jobName;
        if (!this.sessionInConditions) {
            return new ArrayList<Properties>();
        }
        String sessionId = job.getOriginalSessionId();
        AttrHolderList jobFathersList = this.sessionTable.getSessionsBySon(sessionId, jobName = job.getOriginalSessionSon(), numS = job.getOriginalSessionNumS());
        if (jobFathersList == null) {
            return null;
        }
        return jobFathersList.stream().filter(jobFather -> !DollarUniverseCreateDefaultConditions.isRemoveHeaderAndTrailerRuleEnabled(job) || !this.fatherIsHeader(job, (IAttrHolder)jobFather)).map(jobFather -> this.createSessionInCond(job, (IAttrHolder)jobFather)).filter(Objects::nonNull).toList();
    }

    public static boolean isRemoveHeaderAndTrailerRuleEnabled(SchedEntity job) {
        return ((DollarUniverseJob)job).isRemoveHeaderAndTrailerRuleEnabled();
    }

    private boolean fatherIsHeader(DollarUniverseJob job, IAttrHolder jobFather) {
        return jobFather.getAttr("Father").equals(this.sessionTable.sessions.get(job.getSessionId()).getHeaderUprName());
    }

    public Properties createSessionInCond(DollarUniverseJob job, IAttrHolder jobIncond) {
        String condName = "";
        String andOr = "AND";
        String odate = "ODAT";
        String sessionId = job.getOriginalSessionId();
        String jobName = job.getOriginalSessionFather();
        String numS = job.getOriginalSessionNumF();
        this.updateNameToNum(jobName, numS);
        jobName = this.getFieldEditorFormattedName();
        String path = job.getOriginalSessionPath();
        String nodeName = job.getOriginalSessionNode();
        DollarUniverseJob parent = job.getParent();
        String mu = parent.taskParameterValue("mu");
        DollarUniverseCreateConditionByNewFormat.nameToNum childUpr = this.getChildUprIfExist(jobIncond);
        if (childUpr.name().isEmpty()) {
            return null;
        }
        this.updateNameToNum(childUpr.name(), childUpr.number());
        condName = this.buildCondNameWithEndedStatus(sessionId, mu, jobName, nodeName, path, this.getFieldEditorFormattedName());
        InCondition inCondition = new InCondition(condName, andOr, odate);
        return inCondition.getProperties();
    }

    public String getFieldEditorFormattedName() {
        return this.rules.getFieldEditor().generateCTMField("JOBNAME", this::getValueForFieldConversion);
    }

    public String getValueForFieldConversion(String field) {
        String toRet = field.equalsIgnoreCase("UPROC") ? this.uprNameToNum.name() : (field.equalsIgnoreCase("NUM") ? this.uprNameToNum.number() : field);
        while (toRet.matches("^\".*\"$")) {
            toRet = toRet.replaceAll("^\"", "").replaceAll("\"$", "");
        }
        return toRet;
    }

    private DollarUniverseCreateConditionByNewFormat.nameToNum getChildUprIfExist(IAttrHolder jobIncond) {
        if (jobIncond.isFieldExist("Son")) {
            String sonUpr = jobIncond.getAttr("Son");
            DollarUniverseCreateConditionByNewFormat.nameToNum uprFather = new DollarUniverseCreateConditionByNewFormat.nameToNum(jobIncond.getAttr("Father"), DollarUniverseDependencies.getFormatNumS(Integer.parseInt(jobIncond.getAttr("NumF"))));
            String session = jobIncond.getAttr("ses");
            String nodeName = jobIncond.getAttr("node name");
            return this.dependencies.getNameUprOK(uprFather, sonUpr, session, nodeName);
        }
        return new DollarUniverseCreateConditionByNewFormat.nameToNum("", "");
    }

    public String buildCondNameWithEndedStatus(String id, String mu, String job, String nodeName, String path, String son) {
        if (path.equals("OK") || "RC".equals(path)) {
            path = "OK";
        }
        if (path.equals("KO")) {
            path = "NOTOK";
        }
        return String.format(DollarUniverseGlobals.COND_NAME_FORMAT, job, son, id, mu, nodeName, path);
    }

    public List<String> buildEndedNotOkConds(String id, String mu, String job, String num, String nodeName, String path, DollarUniverseJob jobObject, int numS) {
        String originalSessionNode = jobObject.getOriginalSessionNode();
        List<DollarUniverseCreateConditionByNewFormat.nameToNum> targetJobsNameUpr = this.dependencies.getNameUprKO(new DollarUniverseCreateConditionByNewFormat.nameToNum(job, DollarUniverseDependencies.getFormatNumS(numS)), id, originalSessionNode);
        if (targetJobsNameUpr == null) {
            return null;
        }
        return targetJobsNameUpr.stream().map(it -> {
            this.updateNameToNum(it.name(), it.number());
            return this.buildCondNameWithEndedStatus(id, mu, jobObject.applyFieldConversion("JOBNAME"), nodeName, path, this.getFieldEditorFormattedName());
        }).collect(Collectors.toList());
    }

    private Properties createUprInCondIfExist(DollarUniverseJob job, IAttrHolder jobDepconAttr, String andOr, String op, String condno) {
        Properties prop = null;
        op = op.isEmpty() ? ")" : "";
        if (jobDepconAttr != null) {
            prop = this.createUprInCond(job, jobDepconAttr, andOr, op, condno);
        }
        return prop;
    }

    public List<Properties> getJobUprInconds(DollarUniverseJob job) {
        ArrayList<Properties> propList = new ArrayList<Properties>();
        String jobName = job.getOriginalJobName();
        String jobNodeName = job.getOriginalSessionNode();
        String andOr = "AND";
        String op = "(";
        IAttrHolder jobDepconAttr = null;
        String condno = "";
        boolean addCond = false;
        String formula = this.formulaExtension.getFormulaFromJob(job);
        if (formula == null || formula.isEmpty()) {
            return null;
        }
        String[] formulaElements = formula.split(" ");
        for (int element_index = 0; element_index < formulaElements.length; ++element_index) {
            String element = formulaElements[element_index];
            if (element.isEmpty()) continue;
            if (element.startsWith("(")) {
                job.addReporterMessage("WRN7004", jobName, formula, Integer.toString(element_index));
                element = element.substring(1);
            }
            if (element.startsWith("#")) {
                job.addReporterMessage("WRN7005", jobName, formula, Integer.toString(element_index), element);
                continue;
            }
            if (element.startsWith("=C")) {
                IAttrHolder prevJobDepconAttr = jobDepconAttr;
                String prevCondno = condno;
                boolean writeMessage = true;
                condno = element.substring(2, 4);
                String uprID = UprTable.getUprID(jobName, jobNodeName);
                jobDepconAttr = this.uprTable.getUprsDepconByUpr(uprID, condno);
                if (jobDepconAttr == null) {
                    jobDepconAttr = this.uprTable.getUprsResconByUpr(uprID, condno);
                    if (jobDepconAttr != null) {
                        String res = null;
                        res = jobDepconAttr.getAttr("res");
                        if (res != null && !this.resourceConvertor.isFileRes(res)) {
                            res = null;
                        } else {
                            this.formulaExtension.writeResMesseges(job, res, this.resourceConvertor);
                        }
                        if (res == null) {
                            jobDepconAttr = null;
                        } else if (!this.resconInConditions) {
                            jobDepconAttr = null;
                            writeMessage = false;
                        }
                    } else {
                        String uprId = UprTable.getUprID(jobName, jobNodeName);
                        jobDepconAttr = this.uprTable.getUprsIncconByUpr(uprId, condno);
                        if (jobDepconAttr != null) {
                            jobDepconAttr = null;
                            writeMessage = false;
                        }
                    }
                } else if (!this.depconInConditions) {
                    jobDepconAttr = null;
                    writeMessage = false;
                }
                if (jobDepconAttr == null) {
                    if (writeMessage) {
                        job.addReporterMessage("INF7001", jobName, formula, Integer.toString(element_index), element);
                    }
                    jobDepconAttr = prevJobDepconAttr;
                    condno = prevCondno;
                    continue;
                }
                if (!addCond || prevJobDepconAttr == null) continue;
                Properties prop = this.createUprInCond(job, prevJobDepconAttr, andOr, op, prevCondno);
                if (prop != null && !prop.isEmpty()) {
                    propList.add(prop);
                }
                op = "";
                addCond = false;
                continue;
            }
            addCond = false;
            Optional<String> ret = this.formulaExtension.checkIfItsAndOrCondition(element);
            if (!ret.isPresent()) continue;
            andOr = ret.get();
            addCond = true;
        }
        Properties prop = this.createUprInCondIfExist(job, jobDepconAttr, andOr, op, condno);
        if (prop != null && !prop.isEmpty()) {
            propList.add(prop);
        }
        if (!propList.isEmpty()) {
            this.formulaExtension.validateBrackets(propList);
            return propList;
        }
        return null;
    }

    public String buildUprResCondName(DollarUniverseJob job, String upr, String res, String mu, String condno, Boolean writeMessage) {
        String parentName = job.getParent().getJobName();
        res = parentName + "_" + (String)res;
        String condName = String.format(DollarUniverseGlobals.FW_COND_NAME_FORMAT, res, condno, upr);
        if (job.getHdpExpressionHendler().ishdp()) {
            condName = job.getHdpExpressionHendler().manipulateAssitngJobCondion(mu, condName);
        }
        return condName;
    }

    private Properties createUprInCond(DollarUniverseJob job, IAttrHolder jobInCondition, String andOr, String op, String condno) {
        String condName;
        Properties props = new Properties();
        String node = job.getOriginalSessionNode();
        String type = jobInCondition.getAttr("ENTRY_TYPE");
        String session = jobInCondition.getAttr("sess");
        String dep = jobInCondition.getAttr("dep");
        String mu = jobInCondition.getAttr("mu");
        this.checkDepconFlag(job, jobInCondition, "all", dep, condno, true);
        this.checkDepconFlag(job, jobInCondition, "exclud", dep, condno, true);
        this.checkDepconFlag(job, jobInCondition, "fatal", dep, condno, true);
        if (type.equalsIgnoreCase("rescon")) {
            String uprId = jobInCondition.getAttr("PARENT_UPR");
            String res = jobInCondition.getAttr("res");
            if (!this.resourceConvertor.isFileRes(res)) {
                return props;
            }
            condName = this.buildUprResCondName(job, uprId, res, mu, condno, true);
        } else {
            String user = jobInCondition.getAttr("user");
            String status = jobInCondition.getAttr(STATUS);
            condName = this.buildUprDepCondName(job, dep, mu, session, user, status, condno, true, node);
        }
        if (condName == null) {
            return props;
        }
        String pdate = jobInCondition.getAttr("pdate");
        String odate = this.formulaExtension.checkPdate(job, session, dep, pdate);
        InCondition depconIncondition = new InCondition(condName, andOr, odate);
        if (!op.isEmpty()) {
            depconIncondition.setOp(op);
        }
        return depconIncondition.getProperties();
    }

    private void checkDepconFlag(SchedEntity job, IAttrHolder depconAttr, String flag, String dep, String condno, boolean writeMessage) {
        if (!depconAttr.isFieldExist(flag)) {
            return;
        }
        String flagValue = depconAttr.getAttr(flag);
        if (!DollarUniverseCreateDefaultConditions.checkPdateParameter(depconAttr) && flagValue != null && flagValue.equalsIgnoreCase("TRUE") && writeMessage) {
            ((DollarUniverseJob)job).addReporterMessage("INF7005", flag, dep, condno);
        }
    }

    static boolean checkPdateParameter(IAttrHolder depconAttr) {
        return depconAttr.isFieldExist("pdate") && (depconAttr.getAttr("pdate").equals("( , , )") || depconAttr.getAttr("pdate").equals("same"));
    }

    public String buildUprDepCondName(DollarUniverseJob job, String upr, String mu, String session, String user, String status, String condno, Boolean writeMessage, String node) {
        HandleDepCondName handleDepCondName = new HandleDepCondName();
        DollarUniverseJob parent = job.getParent();
        if ((mu = handleDepCondName.handleMu(job, upr, mu, condno, writeMessage, parent)) == null) {
            return null;
        }
        if ((session = handleDepCondName.handleSession(job, upr, session, condno, writeMessage)) == null) {
            return null;
        }
        user = handleDepCondName.handleUser(user, parent);
        if ((status = handleDepCondName.handleStatus(job, upr, mu, status, condno, writeMessage)) == null) {
            return null;
        }
        return String.format(DollarUniverseGlobals.UPR_COND_NAME_FORMAT, upr, mu, session, user, node, status);
    }

    public List<Properties> getJobOutconds(SchedEntity job) {
        ArrayList<Properties> outCondList = new ArrayList<Properties>();
        List<Properties> props = this.createOkOutCondition(job);
        outCondList.addAll(props);
        List<Properties> uprOutcond = this.getJobUprOutConditions((DollarUniverseJob)job);
        if (uprOutcond != null) {
            outCondList.addAll(uprOutcond);
        }
        if (outCondList.isEmpty()) {
            return null;
        }
        return outCondList;
    }

    private List<Properties> createOkOutCondition(SchedEntity job) {
        if (!DollarUniverseCreateConditionByNewFormat.isFolder((DollarUniverseJob)job)) {
            String sessionId = ((DollarUniverseJob)job).getOriginalSessionId();
            String num = ((DollarUniverseJob)job).getOriginalSessionJobNum();
            DollarUniverseCreateConditionByNewFormat.nameToNum pairJobName = new DollarUniverseCreateConditionByNewFormat.nameToNum(((DollarUniverseJob)job).getOriginalSessionJobName(), num);
            this.updateNameToNum(pairJobName.name(), pairJobName.number());
            String jobName = this.getFieldEditorFormattedName();
            String nodeName = ((DollarUniverseJob)job).getOriginalSessionNode();
            String path = "OK";
            DollarUniverseJob parent = ((DollarUniverseJob)job).getParent();
            String mu = parent != null ? parent.taskParameterValue("mu") : "";
            List<DollarUniverseCreateConditionByNewFormat.nameToNum> sons = this.dependencies.getDependUprsNamesFromSession(pairJobName, sessionId, nodeName);
            return sons.stream().filter(son -> !DollarUniverseCreateDefaultConditions.isRemoveHeaderAndTrailerRuleEnabled(job) || !son.name().equals(this.getTrailerName((DollarUniverseJob)job))).map(son -> {
                this.updateNameToNum(son.name(), son.number());
                return this.buildCondNameWithEndedStatus(sessionId, mu, jobName, nodeName, path, this.getFieldEditorFormattedName());
            }).map(this::initProps).toList();
        }
        return new ArrayList<Properties>();
    }

    private Properties initProps(String condName) {
        String addDel = "ADD";
        String odate = "ODAT";
        Properties props = new Properties();
        props.put("NAME", condName);
        props.put("SIGN", addDel);
        props.put("ODATE", odate);
        return props;
    }

    public List<Properties> getJobUprOutConditions(DollarUniverseJob job) {
        ArrayList<Properties> propList = new ArrayList<Properties>();
        HashMap<String, Boolean> condNameHash = new HashMap<String, Boolean>();
        String jobName = job.getOriginalSessionJobName();
        AttrHolderList jobDepconList = this.uprTable.getUprsDepconByDep(jobName);
        if (job.isStandAloneJob() || DollarUniverseCreateDefaultConditions.isTemplateJob(job) || jobDepconList == null) {
            return null;
        }
        for (IAttrHolder jobDepcon : jobDepconList) {
            String condName;
            Properties prop;
            if (DollarUniverseCreateDefaultConditions.isRemoveHeaderAndTrailerRuleEnabled(job) && jobDepcon.getAttr("PARENT_UPR").equals(this.getTrailerUprNameWithNode(job)) || (prop = this.createUprOutCondition(job, jobDepcon)).isEmpty() || !DollarUniverseCreateDefaultConditions.notHandledByDoCond(jobDepcon) || condNameHash.get(condName = (String)prop.get("NAME")) != null) continue;
            propList.add(prop);
            condNameHash.put(condName, true);
        }
        if (!propList.isEmpty()) {
            return propList;
        }
        return null;
    }

    private static boolean isTemplateJob(DollarUniverseJob job) {
        return job.getSession().getSessionName().equals("TemplateJobs");
    }

    @NotNull
    private String getTrailerUprNameWithNode(DollarUniverseJob job) {
        return job.getUprIdByTaskOrSession(this.getTrailerName(job));
    }

    private String getTrailerName(DollarUniverseJob job) {
        DollarUniverseSessionAttributes session = this.sessionTable.sessions.get(job.getSessionId());
        return session.getTrailerUprName();
    }

    private static boolean notHandledByDoCond(IAttrHolder jobDepcon) {
        boolean isEnded = DEPCON_STATUS_ENDED.equals(jobDepcon.getAttr(STATUS));
        boolean isAborted = DEPCON_STATUS_ABORTED.equals(jobDepcon.getAttr(STATUS));
        return !isEnded && !isAborted;
    }

    private Properties createUprOutCondition(DollarUniverseJob job, IAttrHolder jobOutcond) {
        String odate;
        Properties props = new Properties();
        String addDel = "ADD";
        String dep = jobOutcond.getAttr("dep");
        String mu = jobOutcond.getAttr("mu");
        String session = jobOutcond.getAttr("sess");
        String user = jobOutcond.getAttr("user");
        String status = jobOutcond.getAttr(STATUS);
        String node = job.getOriginalSessionNode();
        String condName = this.buildUprDepCondName(job, dep, mu, session, user, status, "", false, node);
        if (condName == null) {
            return props;
        }
        String pdate = jobOutcond.getAttr("pdate");
        if (DollarUniverseCreateDefaultConditions.isPDateODAT(pdate)) {
            odate = "ODAT";
        } else if (DollarUniverseCreateDefaultConditions.isPDateAllSame(pdate)) {
            odate = "****";
        } else {
            odate = "ODAT";
            job.addReporterMessage("INF7002", session, dep, pdate, odate);
        }
        props.put("NAME", condName);
        props.put("SIGN", addDel);
        props.put("ODATE", odate);
        return props;
    }

    private static boolean isPDateODAT(String pdate) {
        return DollarUniverseCreateDefaultConditions.isPDateAllSame(pdate) || pdate.equalsIgnoreCase("(,,)") || pdate.equalsIgnoreCase("( , , )");
    }

    private static boolean isPDateAllSame(String pdate) {
        return pdate.equalsIgnoreCase("(same,same,same)");
    }

    public void setJobInConditionTypes(Boolean session, Boolean depcon, Boolean rescon) {
        this.sessionInConditions = session;
        this.depconInConditions = depcon;
        this.resconInConditions = rescon;
    }

    public List<Properties> getResconJobInConditions(DollarUniverseJob dollarUniverseJob) {
        this.setJobInConditionTypes(false, false, true);
        List<Properties> ret = this.getJobInconds(dollarUniverseJob);
        this.setJobInConditionTypes(true, true, true);
        return ret;
    }

    public Map<Properties, List<Properties>> getOnEndedDoCond(DollarUniverseJob job) {
        return this.getOnCodeDoCond(job, DEPCON_STATUS_ENDED, "COMPSTAT EQ ANY");
    }

    @NotNull
    private Map<Properties, List<Properties>> getOnCodeDoCond(DollarUniverseJob job, String status, String onCode) {
        return Optional.ofNullable(this.uprTable.getUprsDepconByDep(job.getOriginalJobName())).map(depcon -> this.getDoFromDepConStatus(job, (AttrHolderList)depcon, status)).filter(doList -> !doList.isEmpty()).map(doList -> DollarUniverseCreateDefaultConditions.createOnCodedDo(doList, onCode)).orElse(Collections.emptyMap());
    }

    @NotNull
    private List<Properties> getDoFromDepConStatus(DollarUniverseJob job, AttrHolderList depConList, String status) {
        return depConList.stream().filter(depcon -> status.equals(depcon.getAttr(STATUS))).map(depcon -> this.createUprOutCondition(job, (IAttrHolder)depcon)).map(conditionProperties -> {
            conditionProperties.setProperty("ACTION", "DOCOND");
            return conditionProperties;
        }).collect(Collectors.toList());
    }

    @NotNull
    private static Map<Properties, List<Properties>> createOnCodedDo(List<Properties> doList, String OnCode) {
        Properties on = new PropertiesBuilder().setProperty("STMT", "*").setProperty("CODE", OnCode).build();
        LinkedHashMap<Properties, List<Properties>> onDo = new LinkedHashMap<Properties, List<Properties>>();
        onDo.put(on, doList);
        return onDo;
    }

    public Map<Properties, List<Properties>> getOnEndedNotOkDoCond(DollarUniverseJob job) {
        return this.getOnCodeDoCond(job, DEPCON_STATUS_ABORTED, "NOTOK");
    }
}

