/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dollar_universe;

import com.bmc.ctmconvert.common.calendars.CtmCalendar;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public class DollarUCal {
    private String calName;
    private ArrayList<CtmCalendar> convertedCals;
    private final Map<Integer, List<DAY_TYPE>> years = new HashMap<Integer, List<DAY_TYPE>>();
    private static final int DAY_LENGTH = 4;
    private static final Pattern currLinePattern = Pattern.compile("\\s*(ITEMS)?\\s*\\|\\s*mu\\s*:\\s*(\\S*\\s?\\S*)\\s*");
    private static final Pattern yearPattern = Pattern.compile("^\\s*year\\s*:\\s*\\d+\\s*$");
    private static final Pattern dayPattern = Pattern.compile("^\\s*[a-z]+day\\s*:.*");
    private static final Pattern wchPattern = Pattern.compile("\\d{2} [WCH]");

    public DollarUCal(List<String> rawCal) {
        ArrayList<String> yearLines = new ArrayList<String>();
        Integer year = null;
        for (String currLine : rawCal) {
            String currLineLowerCase = currLine.toLowerCase();
            if (currLinePattern.matcher(currLine).matches()) {
                this.calName = Optional.of(currLine.split("mu.*:")).filter(x -> ((String[])x).length > 1).map(x -> x[1]).map(String::trim).map(name -> FieldValidation.instance().validateAndReturnFixedValue("CAL_NAME", name)).orElse("");
            }
            if (yearPattern.matcher(currLineLowerCase).matches()) {
                if (!yearLines.isEmpty()) {
                    this.years.put(year, this.convertMatrixToArr(yearLines));
                    yearLines = new ArrayList();
                }
                year = Integer.valueOf(currLine.split(":")[1].trim());
            }
            if ((!currLineLowerCase.contains("jan") || !currLineLowerCase.contains("feb")) && !dayPattern.matcher(currLineLowerCase).matches()) continue;
            yearLines.add(currLine);
        }
        if (!yearLines.isEmpty()) {
            this.years.put(year, this.convertMatrixToArr(yearLines));
        }
    }

    private List<DAY_TYPE> convertMatrixToArr(List<String> yearLines) {
        String header = yearLines.get(0);
        String[] headerArr = header.trim().split("\\s+", 12);
        ArrayList<DAY_TYPE> retArr = new ArrayList<DAY_TYPE>();
        for (String s : headerArr) {
            int monthIndex = header.indexOf(s);
            block11: for (int i = 1; i < yearLines.size(); ++i) {
                String dayType;
                String dayDescription = yearLines.get(i).substring(monthIndex, monthIndex + 4);
                if (!wchPattern.matcher(dayDescription).matches()) continue;
                switch (dayType = dayDescription.split(" ", 2)[1]) {
                    case "W": {
                        retArr.add(DAY_TYPE.WORKING);
                        continue block11;
                    }
                    case "C": {
                        retArr.add(DAY_TYPE.CLOSED);
                        continue block11;
                    }
                    case "H": {
                        retArr.add(DAY_TYPE.HOLIDAY);
                    }
                }
            }
        }
        return retArr;
    }

    public List<CtmCalendar> toCtmCals(String dcName, String area) {
        if (this.convertedCals != null && this.convertedCals.get(0).getDcName().equals(dcName)) {
            return this.convertedCals;
        }
        this.convertedCals = new ArrayList();
        HashMap<String, CtmCalendar> newCalendars = this.initCtmCalendars(dcName, area);
        for (Integer year : this.years.keySet()) {
            GregorianCalendar tmpCal = new GregorianCalendar(year, 0, 1);
            while (tmpCal.get(1) == year.intValue()) {
                switch (this.years.get(year).get(tmpCal.get(6) - 1).ordinal()) {
                    case 0: {
                        newCalendars.get("W").addDay(tmpCal.get(1), tmpCal.get(2) + 1, tmpCal.get(5));
                        newCalendars.get("WC").addDay(tmpCal.get(1), tmpCal.get(2) + 1, tmpCal.get(5));
                        newCalendars.get("WH").addDay(tmpCal.get(1), tmpCal.get(2) + 1, tmpCal.get(5));
                        break;
                    }
                    case 1: {
                        newCalendars.get("C").addDay(tmpCal.get(1), tmpCal.get(2) + 1, tmpCal.get(5));
                        newCalendars.get("CH").addDay(tmpCal.get(1), tmpCal.get(2) + 1, tmpCal.get(5));
                        newCalendars.get("WC").addDay(tmpCal.get(1), tmpCal.get(2) + 1, tmpCal.get(5));
                        break;
                    }
                    case 2: {
                        newCalendars.get("H").addDay(tmpCal.get(1), tmpCal.get(2) + 1, tmpCal.get(5));
                        newCalendars.get("CH").addDay(tmpCal.get(1), tmpCal.get(2) + 1, tmpCal.get(5));
                        newCalendars.get("WH").addDay(tmpCal.get(1), tmpCal.get(2) + 1, tmpCal.get(5));
                        break;
                    }
                }
                tmpCal.add(5, 1);
            }
        }
        this.convertedCals.addAll(newCalendars.values());
        return this.convertedCals;
    }

    private HashMap<String, CtmCalendar> initCtmCalendars(String dcName, String area) {
        String[] calendarTypes = new String[]{"W", "C", "H", "WC", "WH", "CH"};
        String mu = this.calName.trim().replaceAll("0+$", "");
        String areaTypeMu = String.format("%s_%s%s", area, mu, mu.isEmpty() ? "" : "_");
        HashMap<String, CtmCalendar> toRet = new HashMap<String, CtmCalendar>();
        for (String calendarType : calendarTypes) {
            String ctmCalName = areaTypeMu + calendarType;
            CtmCalendar tmpCal = new CtmCalendar(ctmCalName, dcName);
            tmpCal.setDescription(this.generateCalendarDescription(calendarType, mu, area));
            toRet.put(calendarType, tmpCal);
        }
        return toRet;
    }

    private String generateCalendarDescription(String calendarType, String mu, String area) {
        if (calendarType == null || calendarType.isEmpty()) {
            return null;
        }
        StringBuilder descBuilder = new StringBuilder("Converted calendar for DollarUniverse ");
        if (area != null && !area.isEmpty()) {
            descBuilder.append("area '");
            descBuilder.append(area);
            descBuilder.append("' ");
        }
        if (mu != null && !mu.isEmpty()) {
            descBuilder.append("managemnt unit '");
            descBuilder.append(mu);
            descBuilder.append("' ");
        }
        block5: for (int i = 0; i < calendarType.length(); ++i) {
            if (i > 0) {
                descBuilder.append(" and ");
            }
            switch (calendarType.charAt(i)) {
                case 'W': {
                    descBuilder.append("working days");
                    continue block5;
                }
                case 'C': {
                    descBuilder.append("closed days");
                    continue block5;
                }
                case 'H': {
                    descBuilder.append("holidays");
                    continue block5;
                }
            }
        }
        return descBuilder.toString();
    }

    public String getMu() {
        return this.calName;
    }

    public boolean isEmpty() {
        return this.years.isEmpty();
    }

    private static enum DAY_TYPE {
        WORKING,
        CLOSED,
        HOLIDAY;

    }
}

