/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.SAP;

import com.bmc.ctmconvert.SAP.SapJob;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.sap.Step;

public class Xbp2SapStepConvert {
    static final String SAP_STEP_NUMBER = "Step_Nb";
    static final String SAP_VARIANT = "variant";
    static final String SAP_PROGRAM = "program";
    static final String SAP_USER = "user";
    public static final String SAP_LANGUAGE = "language";
    static final String SAP_OUTDEV = "outdev";
    static final String SAP_PRINT_COPIES = "prcop";
    static final String SAP_PRREQ = "prreq";
    static final String SAP_PRTITL = "prtitl";
    static final String SAP_PRIM = "prim";
    static final String SAP_PRREL = "prrel";
    static final String SAP_PRNEW = "prnew";
    static final String SAP_PRRET = "prret";
    static final String SAP_PRLIN = "prlin";
    static final String SAP_PRCOL = "prcol";
    static final String SAP_PRFORM = "prform";
    static final String SAP_PRCOVSEL = "prcovsel";
    static final String SAP_PRCOVSAP = "prcovsap";
    static final String SAP_PRREC = "prrec";
    static final String SAP_PRDEP = "prdep";
    static final String SAP_PRAUT = "praut";
    static final String SAP_PRDSN = "prdsn";
    static final String SAP_PRTYP = "prtyp";
    static final String SAP_ARCMOD = "arcmod";
    static final String SAP_PRFOOTL = "prfootl";
    static final String SAP_PRPRI = "prpri";
    static final String SAP_PRCOVSYS = "prcovsys";
    static final String SAP_ARCOBJ = "arcobj";
    static final String SAP_ARCDOC = "arcdoc";
    static final String SAP_ARCINFO = "arcinfo";
    static final String SAP_ARCTEXT = "arctext";
    private Step step = null;
    private SapJob sapJob;
    private IAttrHolder stepAttributes;
    private IAttrHolder stepPrintAttributes;
    private IAttrHolder stepArchiveAttributes;

    public Xbp2SapStepConvert(SapJob sapJob, IAttrHolder stepAttributes, IAttrHolder stepPrintAttributes, IAttrHolder stepArchiveAttributes) {
        this.sapJob = sapJob;
        this.stepAttributes = stepAttributes;
        this.stepPrintAttributes = stepPrintAttributes;
        this.stepArchiveAttributes = stepArchiveAttributes;
        if (stepAttributes != null) {
            this.step = new Step(Integer.parseInt(stepAttributes.getAttr(SAP_STEP_NUMBER)));
        }
    }

    public void setStep(Step step) {
        this.step = step;
    }

    public Step convertSapStepParameters() {
        if (this.stepAttributes != null) {
            this.step.setProgram(this.stepAttributes.getAttr(SAP_PROGRAM));
            this.step.setVariant(this.stepAttributes.getAttr(SAP_VARIANT));
            this.step.setOwner(this.stepAttributes.getAttr(SAP_USER));
            String lang = this.stepAttributes.getAttr(SAP_LANGUAGE);
            if (lang != null) {
                this.step.setLang(lang.substring(0, 1));
            }
            if (this.stepPrintAttributes != null) {
                String printPriority;
                String printFoot;
                String printType;
                String printDsn;
                this.step.setPrintDest(this.stepPrintAttributes.getAttr(SAP_OUTDEV));
                this.step.setRecipient(this.stepPrintAttributes.getAttr(SAP_PRREC));
                this.step.setListText(this.stepPrintAttributes.getAttr(SAP_PRTITL));
                this.step.setPrintNumLines(this.stepPrintAttributes.getAttr(SAP_PRLIN));
                this.step.setPrintNumColumns(this.stepPrintAttributes.getAttr(SAP_PRCOL));
                this.step.setPrintLayout(this.stepPrintAttributes.getAttr(SAP_PRFORM));
                this.step.setPrintBanner(this.stepPrintAttributes.getAttr(SAP_PRCOVSAP));
                this.step.setListName(this.stepPrintAttributes.getAttr(SAP_PRREQ));
                this.step.setDept(this.stepPrintAttributes.getAttr(SAP_PRDEP));
                this.step.setPrintAuth(this.stepPrintAttributes.getAttr(SAP_PRAUT));
                this.step.setPrintHostBanner(this.stepPrintAttributes.getAttr(SAP_PRCOVSYS));
                this.step.setPrintExpiration(this.stepPrintAttributes.getAttr(SAP_PRRET));
                String printImmed = this.stepPrintAttributes.getAttr(SAP_PRIM);
                if (printImmed != null && printImmed.equals("Y")) {
                    printImmed = "X";
                }
                if (printImmed != null && printImmed.equals("N")) {
                    printImmed = "N";
                }
                this.step.setPrintImmed(printImmed);
                String printRelease = this.stepPrintAttributes.getAttr(SAP_PRREL);
                if (printRelease != null && printRelease.equals("Y")) {
                    printRelease = "X";
                }
                this.step.setPrintRelease(printRelease);
                String newListId = this.stepPrintAttributes.getAttr(SAP_PRNEW);
                if (newListId != null && newListId.equals("Y")) {
                    newListId = "X";
                }
                this.step.setNewListId(newListId);
                String printBannerPage = this.stepPrintAttributes.getAttr(SAP_PRCOVSEL);
                if (printBannerPage != null && printBannerPage.equals("Y")) {
                    printBannerPage = "X";
                }
                this.step.setPrintBannerPage(printBannerPage);
                String printCopies = this.stepPrintAttributes.getAttr(SAP_PRINT_COPIES);
                if (printCopies != null && Integer.parseInt(printCopies) == 0) {
                    printCopies = "1";
                }
                this.step.setPrintCopies(printCopies);
                String printArchmode = this.stepPrintAttributes.getAttr(SAP_ARCMOD);
                if (printArchmode != null) {
                    switch (printArchmode) {
                        case "1": {
                            this.step.setPrintArchmode("Print");
                            break;
                        }
                        case "2": {
                            this.step.setPrintArchmode("ARCHIVE");
                            break;
                        }
                        case "3": {
                            this.step.setPrintArchmode("PRINT_ARCHIVE");
                            break;
                        }
                    }
                }
                if ((printDsn = this.stepPrintAttributes.getAttr(SAP_PRDSN)) != null) {
                    this.sapJob.addUnsupportedStepAttrMessage(SAP_PRDSN, printDsn);
                }
                if ((printType = this.stepPrintAttributes.getAttr(SAP_PRTYP)) != null) {
                    this.sapJob.addUnsupportedStepAttrMessage(SAP_PRTYP, printType);
                }
                if ((printFoot = this.stepPrintAttributes.getAttr(SAP_PRFOOTL)) != null) {
                    this.sapJob.addUnsupportedStepAttrMessage(SAP_PRFOOTL, printFoot);
                }
                if ((printPriority = this.stepPrintAttributes.getAttr(SAP_PRPRI)) != null) {
                    this.sapJob.addUnsupportedStepAttrMessage(SAP_PRPRI, printPriority);
                }
            }
            if (this.stepArchiveAttributes != null) {
                this.step.setArchiveSapObject(this.stepArchiveAttributes.getAttr(SAP_ARCOBJ));
                this.step.setArchiveObject(this.stepArchiveAttributes.getAttr(SAP_ARCDOC));
                this.step.setArchiveInfo(this.stepArchiveAttributes.getAttr(SAP_ARCINFO));
                this.step.setArchiveText(this.stepArchiveAttributes.getAttr(SAP_ARCTEXT));
            }
        }
        return this.step;
    }
}

