/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.SAP;

import com.bmc.ctmconvert.SAP.SapJob;
import com.bmc.ctmconvert.SAP.Xbp2SapStepConvert;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.sap.Step;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;

public class Xbp2SapConvertor {
    static final String SAP_JOBNAME = "jobname";
    static final String SAP_JOBCLASS = "jobclass";
    static final String SAP_JOBREC = "rec";
    static final String SAP_JOBRECTYP = "rectyp";
    static final String SAP_JOBCHILD_YES = "children";
    static final String SAP_JOBCHILD_NO = "nochild";
    private Optional<IAttrHolder> xbpAttributes;
    private SapJob sapJob;
    private AttrHolderList xbpStepAttributes;
    private AttrHolderList xbpStepPrintAttributes;
    private AttrHolderList xbpStepArchiveParameters;

    public Xbp2SapConvertor(SapJob sapJob, Optional<IAttrHolder> xbpJobAttributes, AttrHolderList stepsAttributes, AttrHolderList stepsPrintAttributes, AttrHolderList stepsArchiveParameters) {
        this.sapJob = sapJob;
        this.xbpAttributes = xbpJobAttributes;
        this.xbpStepAttributes = stepsAttributes;
        this.xbpStepPrintAttributes = stepsPrintAttributes;
        this.xbpStepArchiveParameters = stepsArchiveParameters;
    }

    public void convertSapParameters() {
        this.setName();
        this.setJobClass();
        this.setJobRec();
        this.setJobRecTyp();
        this.setJobChild();
        this.setSapStep();
        this.ReportSapConverted();
    }

    private void setJobClass() {
        if (!this.xbpAttributes.isPresent()) {
            return;
        }
        String jobClass = this.xbpAttributes.get().getAttr(SAP_JOBCLASS);
        this.sapJob.setClass(jobClass);
    }

    private void setJobRec() {
        if (!this.xbpAttributes.isPresent()) {
            return;
        }
        String jobRec = this.xbpAttributes.get().getAttr(SAP_JOBREC);
        this.sapJob.setRec(jobRec);
    }

    private void setJobRecTyp() {
        String sapJobrectyp = SAP_JOBRECTYP;
        Consumer<String> setAttr = value -> this.sapJob.setRecTyp((String)value);
        this.setAttr(sapJobrectyp, setAttr);
    }

    private void setAttr(String sapJobrectyp, Consumer<String> setAttr) {
        if (!this.xbpAttributes.isPresent()) {
            return;
        }
        String attrValue = this.xbpAttributes.get().getAttr(sapJobrectyp);
        setAttr.accept(attrValue);
    }

    private void setJobChild() {
        if (!this.xbpAttributes.isPresent()) {
            return;
        }
        String jobChild = "1";
        if (this.xbpAttributes.get().getAttr(SAP_JOBCHILD_YES) != null && this.xbpAttributes.get().getAttr(SAP_JOBCHILD_YES).equals("TRUE")) {
            jobChild = "2";
        }
        if (this.xbpAttributes.get().getAttr(SAP_JOBCHILD_NO) != null && this.xbpAttributes.get().getAttr(SAP_JOBCHILD_NO).equals("TRUE")) {
            jobChild = "1";
        }
        this.sapJob.setChild(jobChild);
    }

    private void checkNumberOfSteps() {
        if (this.xbpStepAttributes.isEmpty()) {
            return;
        }
        IAttrHolder stepAttributes = (IAttrHolder)this.xbpStepAttributes.get(0);
        String stepsNumber = stepAttributes.getAttr("Step_Nb");
        if (Integer.parseInt(stepsNumber) > 1) {
            this.sapJob.addMultipleStepsMessage();
        }
    }

    private void setName() {
        if (!this.xbpAttributes.isPresent()) {
            return;
        }
        String jobname = this.xbpAttributes.get().getAttr(SAP_JOBNAME);
        this.sapJob.setName(jobname);
    }

    private void setSapStep() {
        for (int currStep = 0; currStep < this.xbpStepAttributes.size(); ++currStep) {
            IAttrHolder stepAttributes = null;
            if (this.xbpStepAttributes != null) {
                stepAttributes = (IAttrHolder)this.xbpStepAttributes.get(currStep);
            }
            IAttrHolder stepPrintAttributes = null;
            if (this.xbpStepPrintAttributes != null && this.xbpStepPrintAttributes.size() > currStep) {
                stepPrintAttributes = (IAttrHolder)this.xbpStepPrintAttributes.get(currStep);
            }
            IAttrHolder stepArchiveAttributes = null;
            if (this.xbpStepArchiveParameters != null && this.xbpStepArchiveParameters.size() > currStep) {
                stepArchiveAttributes = (IAttrHolder)this.xbpStepArchiveParameters.get(currStep);
            }
            Xbp2SapStepConvert xbp2SapStepConvert = new Xbp2SapStepConvert(this.sapJob, stepAttributes, stepPrintAttributes, stepArchiveAttributes);
            Step step = xbp2SapStepConvert.convertSapStepParameters();
            this.sapJob.addStep(step);
        }
    }

    private void ReportSapConverted() {
        HashMap<String, String> action = new HashMap<String, String>();
        action.put("ACTENTTYPE", "SAPACC");
        action.put("JOBID", this.sapJob.getJobName());
        action.put("ACTENTNAME", this.sapJob.getAccount());
        action.put("ACTSTATUS", "0");
        Reporter.addAction(action);
    }
}

