/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.ms;

import com.bmc.ctmconvert.ms.MSGlobals;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;

public class TasksDirectories {
    public static List<String> getFirstLevelChildrenOfParent(List<String> dirsList, String parent) {
        ArrayList<CallSite> resultList = null;
        if (null != dirsList) {
            resultList = new ArrayList<CallSite>();
            for (String name : dirsList) {
                String[] tokens;
                if (!name.startsWith(parent + MSGlobals.FILESEPARATOR) || name.length() <= parent.length() || (tokens = name.substring(parent.length() - 1).split("[\\\\]")).length < 2 || resultList.contains(parent + MSGlobals.FILESEPARATOR + tokens[1])) continue;
                resultList.add((CallSite)((Object)(parent + MSGlobals.FILESEPARATOR + tokens[1])));
            }
        }
        return resultList;
    }

    public static String getTaskFullName(String fullTaskName, String startingPath) {
        return fullTaskName.substring(startingPath.length() - 1).toLowerCase().replaceAll(".xml", "");
    }

    public static String getTaskFileName(String fullTaskName) {
        if (null != fullTaskName) {
            String[] tokens = fullTaskName.split("[\\\\]");
            if (tokens.length < 1) {
                return fullTaskName;
            }
            return tokens[tokens.length - 1].substring(0, tokens[tokens.length - 1].length() - MSGlobals.iXMLPrefixLen - 1);
        }
        return null;
    }

    public static String getDirectoryLastName(String fullDirectoryPath) {
        if (null != fullDirectoryPath) {
            String[] tokens = fullDirectoryPath.split("[\\\\]");
            if (tokens.length < 2) {
                return fullDirectoryPath;
            }
            if (TasksDirectories.isTask(tokens[tokens.length - 1])) {
                return TasksDirectories.getTaskFileName(tokens[tokens.length - 1]);
            }
            return tokens[tokens.length - 1];
        }
        return null;
    }

    public static boolean isTask(String fullTaskName) {
        return fullTaskName.toLowerCase().endsWith(".xml");
    }

    public static String getParentName(String fullTaskName, String startPath) {
        String lastDirName = fullTaskName;
        String parentName = "";
        if (!TasksDirectories.isTask(fullTaskName)) {
            if (fullTaskName.endsWith(MSGlobals.FILESEPARATOR)) {
                lastDirName = fullTaskName.substring(0, fullTaskName.length() - MSGlobals.FILESEPARATOR.length() - 1);
            }
        } else {
            lastDirName = fullTaskName.substring(0, fullTaskName.lastIndexOf(MSGlobals.FILESEPARATOR));
        }
        parentName = lastDirName.substring(startPath.length() - 1);
        return parentName;
    }

    public static String[] getMachinesListInDirectory(String sPath, String sFilter) {
        final String filter = sFilter.toLowerCase();
        File directory = new File(sPath);
        String[] machinesFiles = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.toLowerCase().endsWith(filter.toLowerCase());
            }
        });
        return machinesFiles;
    }

    public static List<String> getFilesListInDirectory(String sPath) {
        ArrayList<String> resultList = new ArrayList<String>();
        File filePath = new File(sPath);
        File[] files = filePath.listFiles();
        for (int i = 0; i < files.length; ++i) {
            ArrayList<String> filesInDir;
            resultList.add(new String(files[i].getPath()));
            if (!files[i].isDirectory() || null == (filesInDir = new ArrayList<String>(TasksDirectories.getFilesListInDirectory(files[i].getPath())))) continue;
            resultList.addAll(filesInDir);
        }
        return resultList;
    }

    public static String getFullDirectoryName(String fullPath, String startPath) {
        if (fullPath.toLowerCase().endsWith(".xml")) {
            return fullPath.substring(startPath.length(), fullPath.length() - MSGlobals.iXMLPrefixLen - 1);
        }
        return fullPath.substring(startPath.length());
    }
}

