/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.ms;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.ms.CalendarUtil;
import com.bmc.ctmconvert.ms.Task;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class RBCUtil {
    private static int iRBCIndex;
    private static String RBC_Prefix;
    private static HashMap<Properties, String> Map_RBCToString_RBCName;

    public static void init() {
        Map_RBCToString_RBCName = new HashMap();
        iRBCIndex = 0;
    }

    public static List<Properties> addRBC(String machineName, List<Task.Trigger> triggersList, String jobName, String originalJobName, boolean bIgnoreDisabled, ArrayList<String> errorsList) {
        List<Properties> RBCsList = RBCUtil.getRBCs(RBC_Prefix, triggersList, jobName, originalJobName, bIgnoreDisabled, errorsList);
        if (null == RBCsList) {
            return null;
        }
        ArrayList<Properties> propertiesList = new ArrayList<Properties>(RBCsList);
        return propertiesList;
    }

    private static List<Properties> getRBCs(String RBCName, List<Task.Trigger> triggersList, String jobName, String originalJobName, boolean bIgnoreDisabled, ArrayList<String> errorsList) {
        List<Task.CalendarTrigger> calTriggersList = RBCUtil.getCalendarTriggersList(triggersList, bIgnoreDisabled, jobName, originalJobName, errorsList);
        return RBCUtil.calculateRBC(RBCName, calTriggersList, jobName, originalJobName, errorsList);
    }

    private static List<Task.CalendarTrigger> getCalendarTriggersList(List<Task.Trigger> triggersList, boolean bIgnoreDisabled, String jobName, String originalJobName, ArrayList<String> errorsList) {
        if (null == triggersList || triggersList.size() < 1) {
            return null;
        }
        ArrayList<Task.CalendarTrigger> calendarTriggersList = new ArrayList<Task.CalendarTrigger>();
        for (Task.Trigger trigger : triggersList) {
            if (!trigger.getTriggerType().equals("CalendarTrigger")) continue;
            if (bIgnoreDisabled && !trigger.getEnabled()) {
                Reporter.addMessage(errorsList, (String)"INF10002", (String)jobName, (String[])new String[]{originalJobName});
                continue;
            }
            calendarTriggersList.add((Task.CalendarTrigger)trigger);
        }
        return calendarTriggersList;
    }

    private static List<Properties> calculateRBC(String RBCName, List<Task.CalendarTrigger> triggersList, String jobName, String originalJobName, ArrayList<String> errorsList) {
        if (null == triggersList || triggersList.size() < 1) {
            return null;
        }
        Properties currentProperties = null;
        ArrayList<Properties> propertiesList = new ArrayList<Properties>(triggersList.size());
        Calendar cal = Calendar.getInstance();
        String sActiveFrom = "";
        String sActiveTill = "";
        String sRBCName = "";
        for (Task.CalendarTrigger calTrigger : triggersList) {
            List<String> months;
            StringBuilder daysList;
            if (calTrigger == null) continue;
            if (null != calTrigger.getStartBoundary()) {
                cal.setTime(calTrigger.getStartBoundary());
                sActiveFrom = String.format("%04d%02d%02d", cal.get(1), cal.get(2) + 1, cal.get(5));
            } else {
                sActiveFrom = "";
            }
            if (null != calTrigger.getEndBoundary()) {
                cal.setTime(calTrigger.getEndBoundary());
                sActiveTill = String.format("%04d%02d%02d", cal.get(1), cal.get(2) + 1, cal.get(5));
            } else {
                sActiveTill = "";
            }
            if (null != calTrigger.getScheduleByDay() && (currentProperties = RBCUtil.convertScheduleByDay(calTrigger, errorsList, jobName, originalJobName)) != null) {
                propertiesList.add(currentProperties);
            }
            if (null != calTrigger.getScheduleByMonth()) {
                currentProperties = new Properties();
                daysList = new StringBuilder();
                for (String day : calTrigger.getScheduleByMonth().getDaysOfMonth()) {
                    if (day.equalsIgnoreCase("Last")) {
                        Reporter.addMessage(errorsList, (String)"INF10006", (String)jobName, (String[])new String[]{originalJobName, "Last"});
                        continue;
                    }
                    daysList.append(day);
                    daysList.append(",");
                }
                if (daysList.length() > 1) {
                    currentProperties.put("DAYS", daysList.substring(0, daysList.length() - 1));
                }
                String[] shortMonths = new DateFormatSymbols(Locale.US).getShortMonths();
                for (int i = 0; i < 12; ++i) {
                    currentProperties.put(shortMonths[i].toUpperCase(), "0");
                }
                months = calTrigger.getScheduleByMonth().getMonthsAsStrings();
                for (String string : months) {
                    currentProperties.put(string.substring(0, 3).toUpperCase(), "1");
                }
                currentProperties.put("DAYS_AND_OR", "OR");
                currentProperties.put("ACTIVE_FROM", sActiveFrom);
                currentProperties.put("ACTIVE_TILL", sActiveTill);
                if (Map_RBCToString_RBCName.containsKey(currentProperties)) {
                    currentProperties.put("NAME", Map_RBCToString_RBCName.get(currentProperties));
                } else {
                    sRBCName = FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", RBCName + iRBCIndex++);
                    Map_RBCToString_RBCName.put(currentProperties, sRBCName);
                    currentProperties.put("NAME", sRBCName);
                }
                propertiesList.add(currentProperties);
                continue;
            }
            if (null != calTrigger.getScheduleByMonthDayOfWeek()) {
                currentProperties = new Properties();
                daysList = new StringBuilder();
                String[] shortMonths = new DateFormatSymbols(Locale.US).getShortMonths();
                for (int i = 0; i < 12; ++i) {
                    currentProperties.put(shortMonths[i].toUpperCase(), "0");
                }
                months = calTrigger.getScheduleByMonthDayOfWeek().getMonthsAsStrings();
                for (String string : months) {
                    currentProperties.put(string.substring(0, 3).toUpperCase(), "1");
                }
                int iCounter = 0;
                for (String day : calTrigger.getScheduleByMonthDayOfWeek().getDaysOfWeekAsStrings()) {
                    String dayPrefix = "D" + (GlobalFunctions.convertWeekdayToCalendarDayOfWeek((String)day) - 1) + "W";
                    for (String week : calTrigger.getScheduleByMonthDayOfWeek().getWeeks()) {
                        if (week.equalsIgnoreCase("Last")) {
                            Reporter.addMessage(errorsList, (String)"INF10006", (String)jobName, (String[])new String[]{originalJobName, "Last"});
                            continue;
                        }
                        if (++iCounter > 11) {
                            Reporter.addMessage(errorsList, (String)"WRN10002", (String)jobName, (String[])new String[]{originalJobName, "ScheduleByMonthDayOfWeek"});
                            break;
                        }
                        daysList.append(dayPrefix);
                        daysList.append(week);
                        daysList.append(",");
                    }
                    if (iCounter <= 11) continue;
                    break;
                }
                currentProperties.put("DAYS_AND_OR", "OR");
                currentProperties.put("ACTIVE_FROM", sActiveFrom);
                currentProperties.put("ACTIVE_TILL", sActiveTill);
                if (Map_RBCToString_RBCName.containsKey(currentProperties)) {
                    currentProperties.put("NAME", Map_RBCToString_RBCName.get(currentProperties));
                } else {
                    sRBCName = FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", RBCName + iRBCIndex++);
                    Map_RBCToString_RBCName.put(currentProperties, sRBCName);
                    currentProperties.put("NAME", sRBCName);
                }
                if (!daysList.toString().isEmpty()) {
                    String string = RBCUtil.validateAndReturnUpdatedWeekDaysValue(daysList.toString(), errorsList, jobName, sRBCName);
                    currentProperties.put("WEEKDAYS", string);
                }
                propertiesList.add(currentProperties);
                continue;
            }
            if (null == calTrigger.getScheduleByWeek()) continue;
            currentProperties = new Properties();
            currentProperties.put("DAYS_AND_OR", "OR");
            String[] shortMonths = new DateFormatSymbols(Locale.US).getShortMonths();
            for (int i = 0; i < 12; ++i) {
                currentProperties.put(shortMonths[i].toUpperCase(), "1");
            }
            int iWeekinterval = 1;
            if (calTrigger.getScheduleByWeek().getWeeksInterval() != null && !calTrigger.getScheduleByWeek().getWeeksInterval().isEmpty()) {
                iWeekinterval = Integer.parseInt(calTrigger.getScheduleByWeek().getWeeksInterval());
            }
            if (iWeekinterval > 1) {
                currentProperties.put("CONFCAL", CalendarUtil.getCalendarName(iWeekinterval));
                currentProperties.put("SHIFT", "IGNOREJOB");
                currentProperties.put("SHIFTNUM", "+00");
                Reporter.addMessage(errorsList, (String)"WRN10006", (String)jobName, (String[])new String[]{originalJobName});
            }
            currentProperties.put("ACTIVE_FROM", sActiveFrom);
            currentProperties.put("ACTIVE_TILL", sActiveTill);
            if (Map_RBCToString_RBCName.containsKey(currentProperties)) {
                currentProperties.put("NAME", Map_RBCToString_RBCName.get(currentProperties));
            } else {
                sRBCName = FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", RBCName + iRBCIndex++);
                Map_RBCToString_RBCName.put(currentProperties, sRBCName);
                currentProperties.put("NAME", sRBCName);
            }
            List<String> daysOfWeek = calTrigger.getScheduleByWeek().getDaysOfWeekAsStrings();
            if (daysOfWeek.size() == 7) {
                currentProperties.put("WEEKDAYS", "ALL");
            } else {
                Object sWeekDays = "";
                for (String day : daysOfWeek) {
                    sWeekDays = (String)sWeekDays + (GlobalFunctions.convertWeekdayToCalendarDayOfWeek((String)day) - 1);
                    sWeekDays = (String)sWeekDays + ",";
                }
                String string = RBCUtil.validateAndReturnUpdatedWeekDaysValue((String)sWeekDays, errorsList, jobName, sRBCName);
                currentProperties.put("WEEKDAYS", string);
            }
            propertiesList.add(currentProperties);
        }
        if (propertiesList.size() < 1) {
            return null;
        }
        return propertiesList;
    }

    @NotNull
    static String validateAndReturnUpdatedWeekDaysValue(String sWeekDays, List<String> errorsList, String jobName, String RBCName) {
        String weekStrValidated = FieldValidation.instance().validateAndReturnFixedValue("WEEKDAYS", sWeekDays);
        if (!weekStrValidated.equals(sWeekDays)) {
            weekStrValidated = RBCUtil.removeAfterLastCommaIfInvalid(sWeekDays, weekStrValidated);
            Reporter.addMessage(errorsList, (String)"WRN10008", (String)jobName, (String[])new String[]{RBCName});
        }
        return weekStrValidated;
    }

    @NotNull
    private static String removeAfterLastCommaIfInvalid(String sWeekDays, String weekStrValidated) {
        if (',' != sWeekDays.charAt(weekStrValidated.length())) {
            weekStrValidated = weekStrValidated.substring(0, weekStrValidated.lastIndexOf(44));
        }
        return weekStrValidated;
    }

    private static Properties setActivePeriodFromTrigger(Task.CalendarTrigger calTrigger, Properties RBCProperties) {
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)RBCProperties);
        Calendar cal = Calendar.getInstance();
        String sActiveFrom = "";
        String sActiveTill = "";
        if (null != calTrigger.getStartBoundary()) {
            cal.setTime(calTrigger.getStartBoundary());
            sActiveFrom = String.format("%04d%02d%02d", cal.get(1), cal.get(2) + 1, cal.get(5));
        }
        if (null != calTrigger.getEndBoundary()) {
            cal.setTime(calTrigger.getEndBoundary());
            sActiveTill = String.format("%04d%02d%02d", cal.get(1), cal.get(2) + 1, cal.get(5));
        }
        prop.put("ACTIVE_FROM", sActiveFrom);
        prop.put("ACTIVE_TILL", sActiveTill);
        return prop;
    }

    private static Properties convertScheduleByDay(Task.CalendarTrigger calTrigger, ArrayList<String> errorsList, String jobname, String OrigJobname) {
        Properties RBCProperties = new Properties();
        RBCProperties = RBCUtil.initAllMonths(RBCProperties, "1");
        String daysInterval = calTrigger.getScheduleByDay().getDaysInterval();
        try {
            RBCProperties = RBCUtil.initScheduleByDaysInterval(calTrigger, errorsList, RBCProperties, daysInterval, jobname, OrigJobname);
        }
        catch (IllegalArgumentException iae) {
            ConversionLogger.getLogger().warning(iae.getMessage());
            return null;
        }
        RBCProperties.put("DAYS_AND_OR", "OR");
        RBCProperties = RBCUtil.setActivePeriodFromTrigger(calTrigger, RBCProperties);
        RBCProperties = RBCUtil.generateRBCName(RBCProperties);
        return RBCProperties;
    }

    private static Properties initScheduleByDaysInterval(Task.CalendarTrigger calTrigger, ArrayList<String> errorsList, Properties RBCProperties, String daysInterval, String jobname, String origJobname) throws IllegalArgumentException {
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)RBCProperties);
        int dayIntervalInteger = -1;
        try {
            dayIntervalInteger = Integer.parseInt(daysInterval);
        }
        catch (NumberFormatException nfe) {
            ConversionLogger.getLogger().severe("NumberFormatException handled while parsing DaysInterval value at:\n" + nfe.getStackTrace().toString());
            return null;
        }
        if (dayIntervalInteger == 1) {
            prop.put("DAYS", "ALL");
        } else if (dayIntervalInteger == 7) {
            String weekDayAsString = RBCUtil.getWeekDayFromStartBoundary(calTrigger.getStartBoundary());
            prop.put("WEEKDAYS", weekDayAsString);
            ConversionLogger.getLogger().info("Days interval of '7' converted to weekly schedule.\nDay of week derived from the StartBoundary Date of given Trigger.");
            Reporter.addMessage(errorsList, (String)"INF10007", (String)jobname, (String[])new String[]{origJobname});
        } else {
            Reporter.addMessage(errorsList, (String)"INF10008", (String)jobname, (String[])new String[]{origJobname, String.valueOf(dayIntervalInteger)});
            throw new IllegalArgumentException("Illegal days interval value of " + dayIntervalInteger);
        }
        return prop;
    }

    private static Properties initAllMonths(Properties RBCProperties, String value) {
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)RBCProperties);
        String[] shortMonths = new DateFormatSymbols(Locale.US).getShortMonths();
        for (int i = 0; i < Globs.MONTHS_IN_YEAR; ++i) {
            prop.put(shortMonths[i].toUpperCase(), value);
        }
        return prop;
    }

    private static String getWeekDayFromStartBoundary(Date activeFrom) {
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(activeFrom);
        }
        catch (Exception e) {
            ConversionLogger.getLogger().info("Failed setting Calendar instance from StartBoundary Date Object:\n" + e.getMessage());
        }
        return String.valueOf(cal.get(7) - 1);
    }

    private static Properties generateRBCName(Properties RBCProperties) {
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)RBCProperties);
        String RBCName = "";
        if (Map_RBCToString_RBCName.containsKey(prop)) {
            prop.put("NAME", Map_RBCToString_RBCName.get(prop));
        } else {
            RBCName = FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", RBC_Prefix + iRBCIndex++);
            Map_RBCToString_RBCName.put(prop, RBCName);
            prop.put("NAME", RBCName);
        }
        return prop;
    }

    public static List<Properties> removeDuplicatedRBCs(List<Properties> inList) {
        HashMap<Properties, String> Map_RBCValues_RBCName = new HashMap<Properties, String>();
        ArrayList<Properties> retList = new ArrayList<Properties>();
        for (Properties currentProp : inList) {
            Properties toAdd = new Properties();
            toAdd.putAll((Map<?, ?>)currentProp);
            currentProp.put("NAME", "");
            if (Map_RBCValues_RBCName.containsKey(currentProp)) continue;
            Map_RBCValues_RBCName.put(currentProp, currentProp.getProperty("NAME"));
            retList.add(toAdd);
        }
        if (retList.size() > 0) {
            return retList;
        }
        return null;
    }

    static {
        RBC_Prefix = "RBC_";
        Map_RBCToString_RBCName = null;
    }
}

