/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.ms;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.CtmPriority;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.ms.MSGlobals;
import com.bmc.ctmconvert.ms.RBCUtil;
import com.bmc.ctmconvert.ms.Task;
import com.bmc.ctmconvert.ms.TasksDirectories;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

public class MSJob
implements SchedEntity {
    private static CtmPriority priorityCalc = null;
    private boolean bIgnoreDisabledTriggers = RuleManager.instance().getCurrentRules().getBooleanRule("MS rules", new String[]{"IGNORE_DISABLED_TRIGGERS"});
    private ArrayList<String> messages;
    private static String sChangeDirectoryPrefix = "cd /D ";
    private String mFilePath;
    private String mStartPath;
    private Task.Action mAction;
    private List<Task.Trigger> mTriggersList;
    private Properties mPropInCond;
    private Properties mPropOutCond;
    private String mAuthor;
    private String mOwner;
    private String mNodeId;
    private String mNodeIdOriginal;
    private String mDescription;
    private String mJobName;
    private String mParentTableName;
    private String mOriginalJobName;
    private int miPriority;
    private List<String> mRBCsList;
    private String mTimeFrom;
    private String mActiveFrom;
    private String mActiveTill;
    private Properties mShoutProperties;
    private Properties mCyclicProperties;
    private ArrayList<String> optionalAttributes;
    private LinkedHashMap<String, String> autoedits;
    private Properties mTaskTypeProperties;
    private RulesDataSet mRules = RuleManager.instance().getCurrentRules();
    private boolean bHasWarnings;
    private boolean bHasRBCs;
    private String mParentAdditionalName;

    public void setParentAdditionalName(String additionalName) {
        this.mParentAdditionalName = additionalName;
    }

    private static String calculatePriority(int origPriority) {
        if (null == priorityCalc) {
            priorityCalc = new CtmPriority(0, 10);
        }
        return priorityCalc.calculatePriority(10 - origPriority);
    }

    public MSJob(String filePath, String startPath, Task.Action action, List<Task.Trigger> inTriggersList, String author, String owner, String description, int priority, String parentTableName) {
        this.mFilePath = filePath;
        this.mStartPath = startPath;
        this.mAction = action;
        this.mPropInCond = null;
        this.mPropOutCond = null;
        this.messages = new ArrayList();
        this.mAuthor = author;
        this.mOwner = owner;
        this.mDescription = description;
        this.mParentTableName = parentTableName;
        this.mNodeIdOriginal = this.getMachineId();
        this.mNodeId = FieldValidation.instance().validateAndReturnFixedValue("NODEID", this.mNodeIdOriginal);
        this.mJobName = FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", this.mRules.getNameManipulator().manipulateName(TasksDirectories.getTaskFileName(this.mFilePath), SchedEntity.TYPE.JOB));
        this.mOriginalJobName = TasksDirectories.getTaskFullName(this.mFilePath, this.mStartPath);
        if (!this.mNodeId.equalsIgnoreCase(this.mNodeIdOriginal)) {
            String msgID = null;
            msgID = this.mNodeIdOriginal.length() != this.mNodeId.length() ? "WRN10005" : "WRN10004";
            Reporter.addMessage(this.messages, (String)msgID, (String)this.mJobName, (String[])new String[]{this.mOriginalJobName, this.mNodeIdOriginal, this.mNodeId});
        }
        this.miPriority = priority;
        this.mTimeFrom = null;
        this.mActiveFrom = null;
        this.mActiveTill = null;
        this.mRBCsList = null;
        this.bHasRBCs = false;
        this.mParentAdditionalName = null;
        this.bHasWarnings = false;
        this.mShoutProperties = null;
        this.mCyclicProperties = null;
        this.mTriggersList = null != inTriggersList ? new ArrayList<Task.Trigger>(inTriggersList) : null;
        this.convertTaskType();
    }

    public void setInCond(String condName, String condDate) {
        this.mPropInCond = new Properties();
        this.mPropInCond.put("NAME", condName);
        this.mPropInCond.put("ODATE", condDate);
        this.mPropInCond.put("AND_OR", "AND");
    }

    public void setOutCond(String condName, String condDate) {
        this.mPropOutCond = new Properties();
        this.mPropOutCond.put("NAME", condName);
        this.mPropOutCond.put("ODATE", condDate);
        this.mPropOutCond.put("SIGN", "ADD");
    }

    public SchedEntity.TYPE type() {
        return SchedEntity.TYPE.JOB;
    }

    public String originalProductID() {
        return this.mOriginalJobName;
    }

    public List<SchedEntity> getChildren() {
        return null;
    }

    public List<AssistingJob> getAssistingJobs() {
        return null;
    }

    public String getAttr(String attrName) {
        if (attrName.equals("OWNER")) {
            return this.mOwner;
        }
        if (attrName.equals("TASKTYPE") || attrName.equals("MEMNAME") || attrName.equals("CMDLINE") || attrName.equals("USE_INSTREAM_JCL") || attrName.equals("MEMLIB") || attrName.equals("INSTREAM_JCL")) {
            return this.mTaskTypeProperties.getProperty(attrName);
        }
        if (attrName.equals("NODEID")) {
            return this.mNodeId;
        }
        if (attrName.equals("NodeIdOriginal")) {
            return this.mNodeIdOriginal;
        }
        if (attrName.equals("CYCLIC")) {
            if (null == this.mCyclicProperties) {
                return "0";
            }
            return "1";
        }
        if (attrName.equals("MAXRERUN")) {
            if (null == this.mCyclicProperties) {
                return null;
            }
            return this.mCyclicProperties.getProperty(attrName);
        }
        if (attrName.equals("TAG_RELATIONSHIP")) {
            return "OR";
        }
        if (attrName.equals("AUTHOR")) {
            return this.mAuthor;
        }
        if (attrName.equals("CONFIRM")) {
            return null;
        }
        if (attrName.equals("CRITICAL")) {
            return null;
        }
        if (attrName.equals("JOBNAME")) {
            return this.mJobName;
        }
        if (attrName.equals("DESCRIPTION")) {
            return this.mDescription;
        }
        if (attrName.equals("TIMEFROM") || attrName.equals("ACTIVE_FROM") || attrName.equals("ACTIVE_TILL")) {
            if (null == this.mTriggersList) {
                return "";
            }
            return this.getTimes(attrName);
        }
        if (attrName.equals("TIMETO")) {
            return "";
        }
        if (attrName.equals("TIMEZONE")) {
            return null;
        }
        if (attrName.equals("PRIORITY")) {
            return MSJob.calculatePriority(this.miPriority);
        }
        if (attrName.equals("CYCLIC_TYPE") || attrName.equals("INTERVAL") || attrName.equals("IND_CYCLIC")) {
            if (null == this.mCyclicProperties) {
                return null;
            }
            return this.mCyclicProperties.getProperty(attrName);
        }
        return null;
    }

    public List<Properties> getInConds() {
        if (null == this.mPropInCond) {
            return null;
        }
        ArrayList<Properties> resList = new ArrayList<Properties>(1);
        resList.add(this.mPropInCond);
        return resList;
    }

    public List<Properties> getOutConds() {
        if (null == this.mPropOutCond) {
            return null;
        }
        ArrayList<Properties> resList = new ArrayList<Properties>(1);
        resList.add(this.mPropOutCond);
        return resList;
    }

    public List<Properties> getTags() {
        List<Properties> resList;
        block4: {
            block3: {
                if (null == this.mTriggersList && !this.bHasRBCs) {
                    return null;
                }
                resList = null;
                if (null == this.mRBCsList) break block3;
                resList = new ArrayList<Properties>(this.mRBCsList.size());
                Properties pro = null;
                for (String rbcName : this.mRBCsList) {
                    pro = new Properties();
                    pro.put("NAME", rbcName);
                    resList.add(pro);
                }
                break block4;
            }
            this.mRBCsList = new ArrayList<String>();
            resList = RBCUtil.addRBC(this.mNodeId, this.mTriggersList, this.mJobName, this.mOriginalJobName, this.bIgnoreDisabledTriggers, this.messages);
            if (null == resList) break block4;
            for (Properties prop : resList) {
                this.mRBCsList.add(new String(prop.getProperty("NAME")));
            }
        }
        return resList;
    }

    public List<Properties> getQuantResources() {
        return null;
    }

    public List<Properties> getCtrlResources() {
        return null;
    }

    public List<Properties> getOnStmt() {
        ArrayList<Properties> onStmtList = new ArrayList<Properties>();
        if (null != this.mAction && this.mAction.getActionType().equals("SendEmail")) {
            Task.SendEmail action = (Task.SendEmail)this.mAction;
            Properties statement = new Properties();
            statement.put("CODE", "*");
            statement.put("STMT", "*");
            statement.put("ACTION", "DOMAIL");
            if (null != action.getTo()) {
                if (action.getTo().length() > MSGlobals.CTM_MAIL_TO_MAX_LENGTH) {
                    Reporter.addMessage(this.messages, (String)"WRN10003", (String)this.mOriginalJobName, (String[])new String[]{this.mJobName, "To", Integer.toString(MSGlobals.CTM_MAIL_TO_MAX_LENGTH)});
                    this.bHasWarnings = true;
                    statement.put("DEST", action.getTo().substring(0, MSGlobals.CTM_MAIL_TO_MAX_LENGTH));
                } else {
                    statement.put("DEST", action.getTo());
                }
            }
            if (null != action.getSubject()) {
                if (action.getSubject().length() > MSGlobals.CTM_MAIL_SUBJECT_MAX_LENGTH) {
                    Reporter.addMessage(this.messages, (String)"WRN10003", (String)this.mOriginalJobName, (String[])new String[]{this.mJobName, "Subject", Integer.toString(MSGlobals.CTM_MAIL_SUBJECT_MAX_LENGTH)});
                    this.bHasWarnings = true;
                    statement.put("SUBJECT", action.getSubject().substring(0, MSGlobals.CTM_MAIL_SUBJECT_MAX_LENGTH));
                } else {
                    statement.put("SUBJECT", action.getSubject());
                }
            }
            if (null != action.getBody()) {
                if (action.getBody().length() > MSGlobals.CTM_MAIL_BODY_MAX_LENGTH) {
                    Reporter.addMessage(this.messages, (String)"WRN10003", (String)this.mOriginalJobName, (String[])new String[]{this.mJobName, "Body", Integer.toString(MSGlobals.CTM_MAIL_BODY_MAX_LENGTH)});
                    this.bHasWarnings = true;
                    statement.put("MESSAGE", action.getBody().substring(0, MSGlobals.CTM_MAIL_BODY_MAX_LENGTH));
                } else {
                    statement.put("MESSAGE", action.getBody());
                }
            }
            statement.put("URGENCY", "R");
            statement.put("ATTACH_SYSOUT", "No");
            onStmtList.add(statement);
        }
        if (null != this.mPropInCond) {
            Properties deleteInCondProp = new Properties();
            deleteInCondProp.put("CODE", "*");
            deleteInCondProp.put("STMT", "*");
            deleteInCondProp.put("ACTION", "DOCOND");
            deleteInCondProp.put("NAME", this.mPropInCond.get("NAME"));
            deleteInCondProp.put("ODATE", this.mPropInCond.get("ODATE"));
            deleteInCondProp.put("SIGN", "DEL");
            onStmtList.add(deleteInCondProp);
        }
        if (onStmtList.size() > 0) {
            return onStmtList;
        }
        return null;
    }

    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        return null;
    }

    public List<Properties> getShouts() {
        if (null == this.mShoutProperties) {
            return null;
        }
        ArrayList<Properties> retList = new ArrayList<Properties>(1);
        retList.add(this.mShoutProperties);
        return retList;
    }

    public String getJobName() {
        return this.mJobName;
    }

    public String getOriginalJobName() {
        return this.mOriginalJobName;
    }

    public String getParentName() {
        if (null != this.mParentAdditionalName) {
            return FieldValidation.instance().validateAndReturnFixedValue("PARENT_TABLE", this.mParentTableName + "/" + this.mParentAdditionalName);
        }
        return FieldValidation.instance().validateAndReturnFixedValue("PARENT_TABLE", this.mParentTableName);
    }

    public SchedEntity getParent() {
        return null;
    }

    public String getTablePathForSons() {
        return null;
    }

    public boolean isValid() {
        return true;
    }

    public boolean hasWarnings() {
        return this.bHasWarnings;
    }

    public boolean hasMessages() {
        return this.messages.size() > 0;
    }

    public boolean isDSJob() {
        return true;
    }

    public String getTableName() {
        return null;
    }

    public boolean isCyclic() {
        return null != this.mCyclicProperties;
    }

    public String applyFieldConversion(String field) {
        return null;
    }

    public String getApplication() {
        return this.mNodeId;
    }

    public String getGroup() {
        return this.mNodeId;
    }

    public LinkedHashMap<String, String> getAutoedits() {
        return this.autoedits;
    }

    public List<String> getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public ArrayList<String> getMessages() {
        return this.messages;
    }

    private String getMachineId() {
        String[] res = this.mFilePath.substring(this.mStartPath.length()).split("[\\\\]");
        return res[0];
    }

    private String getTimes(String type) {
        if (null == this.mTimeFrom || null == this.mActiveFrom || null == this.mActiveTill) {
            this.calculateTimes();
        }
        if (type.equals("TIMEFROM")) {
            return this.mTimeFrom;
        }
        if (type.equals("ACTIVE_FROM")) {
            return this.mActiveFrom;
        }
        if (type.equals("ACTIVE_TILL")) {
            return this.mActiveTill;
        }
        return "";
    }

    private String getCMDLine() {
        if (null == this.mAction) {
            return null;
        }
        if (this.mAction.getActionType().equals("SendEmail")) {
            return "echo An Email Job";
        }
        if (this.mAction.getActionType().equals("Exec")) {
            Object sResult = "";
            String sWorkingDir = ((Task.Exec)this.mAction).getWorkingDirectory();
            if (null != sWorkingDir) {
                sResult = sChangeDirectoryPrefix + sWorkingDir + " & ";
            }
            if (null != ((Task.Exec)this.mAction).getCommand()) {
                sResult = (String)sResult + ((Task.Exec)this.mAction).getCommand();
            }
            if (null != ((Task.Exec)this.mAction).getArguments()) {
                sResult = (String)sResult + " " + ((Task.Exec)this.mAction).getArguments();
            }
            if (((String)sResult).length() < 1) {
                sResult = "";
            }
            return sResult;
        }
        if (this.mAction.getActionType().equals("ShowMessage")) {
            String sBody;
            Task.ShowMessage action = (Task.ShowMessage)this.mAction;
            String sTitle = action.getTitle();
            if (null == sTitle) {
                sTitle = "";
            }
            if (null == (sBody = action.getBody())) {
                sBody = "";
            }
            if (sTitle.length() + sBody.length() + " *** ".length() + 1 > 255) {
                sBody = action.getBody().substring(0, 255 - sTitle.length() - " *** ".length() - 1);
                Reporter.addMessage(this.messages, (String)"WRN10001", (String)this.mJobName, (String[])new String[]{this.mOriginalJobName});
                this.bHasWarnings = true;
            }
            String sResult = "msg * " + sTitle + " *** " + sBody;
            return sResult;
        }
        return null;
    }

    private void calculateTimes() {
        Date currentDate = new Date();
        Date firstAvailableDateStartBoundary = new Date(Long.MAX_VALUE);
        Date firstAvailableDateEndBoundary = null;
        int iAvailableDates = 0;
        String executionLimit = null;
        String sInterval = null;
        String sDuration = null;
        boolean bStopAtDurationEnd = false;
        this.mActiveTill = "";
        this.mTimeFrom = "";
        this.mActiveFrom = "";
        for (Task.Trigger trigger : this.mTriggersList) {
            if (!trigger.getTriggerType().equals("TimeTrigger") && !trigger.getTriggerType().equals("CalendarTrigger")) continue;
            if (this.bIgnoreDisabledTriggers && !trigger.getEnabled()) {
                Reporter.addMessage(this.messages, (String)"INF10002", (String)this.mJobName, (String[])new String[]{this.mOriginalJobName, trigger.getTriggerType()});
                this.bHasWarnings = true;
                continue;
            }
            Task.Trigger iterTrigger = trigger.getTriggerType().equals("TimeTrigger") ? (Task.TimeTrigger)trigger : (Task.CalendarTrigger)trigger;
            Date iterDate = iterTrigger.getStartBoundary();
            if (null == iterDate) continue;
            ++iAvailableDates;
            if (!firstAvailableDateStartBoundary.after(iterDate)) continue;
            firstAvailableDateStartBoundary = iterDate;
            firstAvailableDateEndBoundary = iterTrigger.getEndBoundary();
            executionLimit = iterTrigger.getExecutionTimeLimit();
            if (null == iterTrigger.getRepetition()) continue;
            sInterval = iterTrigger.getRepetition().getInterval();
            sDuration = iterTrigger.getRepetition().getDuration();
            bStopAtDurationEnd = iterTrigger.getRepetition().getStopAtDurationEnd();
        }
        if (iAvailableDates > 1) {
            Reporter.addMessage(this.messages, (String)"INF10001", (String)this.mJobName, (String[])new String[]{this.mOriginalJobName});
            this.bHasWarnings = true;
        }
        Calendar cal = Calendar.getInstance();
        if (null != firstAvailableDateStartBoundary && !firstAvailableDateStartBoundary.equals(new Date(Long.MAX_VALUE))) {
            cal.setTime(firstAvailableDateStartBoundary);
            this.mTimeFrom = String.format("%02d%02d", cal.get(11), cal.get(12));
            this.mActiveFrom = String.format("%04d%02d%02d", cal.get(1), cal.get(2) + 1, cal.get(5));
        }
        if (null != firstAvailableDateEndBoundary) {
            if (firstAvailableDateEndBoundary.after(currentDate)) {
                Reporter.addMessage(this.messages, (String)"INF10005", (String)this.mJobName, (String[])new String[]{this.mOriginalJobName});
                this.bHasWarnings = true;
            }
            cal.setTime(firstAvailableDateEndBoundary);
            this.mActiveTill = String.format("%04d%02d%02d", cal.get(1), cal.get(2) + 1, cal.get(5));
        }
        if (null != executionLimit) {
            this.createShoutOnRunTime(executionLimit);
        }
        if (null != sInterval) {
            this.createCyclic(sInterval, sDuration, bStopAtDurationEnd);
        }
    }

    public void setRBCsNames(List<String> rbcsNamesList) {
        if (null != rbcsNamesList) {
            this.mRBCsList = new ArrayList<String>(rbcsNamesList);
            this.bHasRBCs = true;
        }
    }

    private void createShoutOnRunTime(String sExecutionLimit) {
        DatatypeFactory df = null;
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Exception in MSJob - createShoutOnRunTime");
            ExceptionHandler.writeToExceptionFile((Exception)e);
            return;
        }
        Duration duration = df.newDuration(sExecutionLimit);
        long iMinutes = duration.getTimeInMillis(new Date()) / 60000L;
        if (iMinutes > (long)Globs.MAXEXECTIME_int.intValue()) {
            String sMinutes = sExecutionLimit + " (" + iMinutes + " minutes)";
            Reporter.addMessage(this.messages, (String)"WRN10007", (String)this.mOriginalJobName, (String[])new String[]{this.getJobName(), this.getJobName(), sMinutes});
            this.bHasWarnings = true;
            iMinutes = Globs.MAXEXECTIME_int.intValue();
        }
        this.mShoutProperties = new Properties();
        this.mShoutProperties.setProperty("DEST", "EM");
        this.mShoutProperties.setProperty("WHEN", "EXECTIME");
        this.mShoutProperties.setProperty("TIME", ">" + iMinutes);
        this.mShoutProperties.setProperty("URGENCY", "R");
        this.mShoutProperties.setProperty("MESSAGE", "Job name %%JOBNAME run time exceeded maximum");
    }

    private void createCyclic(String sInterval, String sDuration, boolean bStopAtDurationEnd) {
        DatatypeFactory df = null;
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)"Exception in MSJob - createCyclic");
            ExceptionHandler.writeToExceptionFile((Exception)e);
            return;
        }
        long lMaxRerun = 0L;
        long lInterval = 1L;
        Duration dInterval = df.newDuration(sInterval);
        if (null != dInterval) {
            lInterval = dInterval.getTimeInMillis(new Date()) / 60000L;
        }
        if (null != sDuration) {
            Duration dDuration = null;
            try {
                dDuration = df.newDuration(sDuration);
            }
            catch (IllegalArgumentException e) {
                ConversionLogger.getLogger().info(e.toString());
                ConversionLogger.getLogger().info("In Job: " + this.getJobName() + " We found an illegal value " + sDuration + " for attribute \"Duration\", The value changed to \"PT0S\".");
                sDuration = "PT0S";
                dDuration = df.newDuration(sDuration);
            }
            if (null != dDuration) {
                long lDuration = dDuration.getTimeInMillis(new Date()) / 60000L;
                lMaxRerun = lDuration / lInterval;
            }
        }
        if (lMaxRerun > 99L) {
            Reporter.addMessage(this.messages, (String)"WRN0001", (String)this.mOriginalJobName, (String[])new String[]{String.valueOf(lMaxRerun), String.valueOf(99)});
            this.bHasWarnings = true;
            lMaxRerun = 99L;
        }
        if (bStopAtDurationEnd) {
            Reporter.addMessage(this.messages, (String)"WRN0019", (String)this.mOriginalJobName, (String[])new String[]{"MS", "StopAtDurationEnd"});
            this.bHasWarnings = true;
        }
        this.setCyclic(lInterval, lMaxRerun);
    }

    public void setCyclic(long lInterval, long lMaxRerun) {
        this.mCyclicProperties = new Properties();
        this.mCyclicProperties.put("CYCLIC", "1");
        this.mCyclicProperties.put("CYCLIC_TYPE", "Interval");
        this.mCyclicProperties.put("INTERVAL", String.format("%05dM", lInterval));
        this.mCyclicProperties.put("IND_CYCLIC", "START");
        this.mCyclicProperties.put("MAXRERUN", String.valueOf(lMaxRerun));
    }

    private void convertTaskType() {
        this.mTaskTypeProperties = new Properties();
        boolean convertToCmdline = !this.mRules.getTaskTypeHandler().isToJobType();
        Object cmdline = null;
        if (null != this.mAction) {
            cmdline = this.getCMDLine();
            if (((String)cmdline).isEmpty()) {
                Reporter.addMessage(this.messages, (String)"WRN0012", (String)this.mOriginalJobName, (String[])new String[]{Params.instance().getVendorName(), "Exec-Command"});
                this.mAction = null;
            } else {
                FieldValidation.instance().cmdLineValidateAndReportMessages((String)cmdline, this.mOriginalJobName, this.messages);
            }
        }
        if (null == cmdline) {
            cmdline = "echo No Action command was found in Task: " + this.mOriginalJobName;
        }
        if (null != this.mAction && this.mAction.getActionType().equals("Exec")) {
            if (!convertToCmdline) {
                String sWorkingDir = ((Task.Exec)this.mAction).getWorkingDirectory();
                if (null != sWorkingDir) {
                    cmdline = ((String)cmdline).substring(sChangeDirectoryPrefix.length() + sWorkingDir.length() + 3);
                }
                if (((String)cmdline).contains("&")) {
                    Object embeddedScript = "";
                    if (null != sWorkingDir) {
                        embeddedScript = (String)embeddedScript + sChangeDirectoryPrefix + sWorkingDir + " \n";
                    }
                    String[] commandsArray = ((String)cmdline).split("\\s*&\\s*");
                    for (int i = 0; i < commandsArray.length; ++i) {
                        embeddedScript = (String)embeddedScript + commandsArray[i];
                        embeddedScript = (String)embeddedScript + "\n";
                    }
                    this.mTaskTypeProperties.setProperty("TASKTYPE", "Job");
                    this.mTaskTypeProperties.setProperty("MEMNAME", this.getJobName());
                    this.mTaskTypeProperties.setProperty("USE_INSTREAM_JCL", "Y");
                    this.setOptionalAttribute("INSTREAM_JCL", (String)embeddedScript);
                } else {
                    convertToCmdline = true;
                    for (String taskTypeFilter : this.mRules.getTaskTypeHandler().getTaskTypeFilters()) {
                        convertToCmdline = convertToCmdline && !((String)cmdline).contains(taskTypeFilter);
                    }
                    if (!convertToCmdline) {
                        ArrayList cmdArgs = GlobalFunctions.cmdline2ArgArr((String)cmdline, (boolean)true);
                        if (cmdArgs == null) {
                            convertToCmdline = true;
                        } else {
                            this.mTaskTypeProperties.setProperty("TASKTYPE", "Job");
                            this.mTaskTypeProperties.setProperty("MEMLIB", (String)cmdArgs.get(0));
                            this.mTaskTypeProperties.setProperty("MEMNAME", (String)cmdArgs.get(1));
                            for (int i = 2; i < cmdArgs.size(); ++i) {
                                if (this.autoedits == null) {
                                    this.autoedits = new LinkedHashMap();
                                }
                                this.autoedits.put(String.format("%%%%PARM%d", i - 1), (String)cmdArgs.get(i));
                            }
                            if (null != sWorkingDir) {
                                Reporter.addMessage(this.messages, (String)"WRN0002", (String)this.mOriginalJobName, (String[])new String[]{"MS", "WorkingDirectory (when converting to scripted jobs)", sWorkingDir});
                                this.bHasWarnings = true;
                            }
                        }
                    }
                }
            }
            if (convertToCmdline) {
                this.mTaskTypeProperties.setProperty("TASKTYPE", "Command");
                this.mTaskTypeProperties.setProperty("CMDLINE", this.getCMDLine());
                this.mTaskTypeProperties.setProperty("MEMNAME", this.getJobName());
            }
        } else {
            this.mTaskTypeProperties.setProperty("TASKTYPE", "Command");
            this.mTaskTypeProperties.setProperty("CMDLINE", (String)cmdline);
        }
        boolean bConvertToDummy = this.mRules.getTaskTypeHandler().isToDummy();
        if (null == this.mAction || bConvertToDummy) {
            if (!Params.instance().getGUIVersion().equals("7")) {
                String sTaskType = this.mTaskTypeProperties.getProperty("TASKTYPE");
                if (null == sTaskType) {
                    sTaskType = "Job";
                }
                if (null == this.autoedits) {
                    this.autoedits = new LinkedHashMap();
                }
                this.autoedits.put("%%$BMCWAIORIGTYPE", sTaskType);
            }
            this.mTaskTypeProperties.setProperty("TASKTYPE", "Dummy");
        }
    }

    private void setOptionalAttribute(String name, String value) {
        if (this.optionalAttributes == null) {
            this.optionalAttributes = new ArrayList();
        }
        if (!this.optionalAttributes.contains(name)) {
            this.optionalAttributes.add(name);
        }
        this.mTaskTypeProperties.setProperty(name, value);
    }
}

