/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.ms;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.ms.CalendarUtil;
import com.bmc.ctmconvert.ms.MSDirectory;
import com.bmc.ctmconvert.ms.MSGlobals;
import com.bmc.ctmconvert.ms.RBCUtil;
import com.bmc.ctmconvert.ms.TaskAttrHolder;
import com.bmc.ctmconvert.ms.TaskAttrHolderList;
import com.bmc.ctmconvert.ms.TasksDirectories;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class MSDefs
implements SourceDefinitions {
    private RulesDataSet m_rules = RuleManager.instance().getCurrentRules();
    private List<String> m_MachinesNamesList;
    private static HashMap<String, List<String>> Map_Machine_FilesList = new HashMap();

    public static List<String> getFilesList(String machineId) {
        return Map_Machine_FilesList.get(machineId);
    }

    public AttrHolderList getTopLevelEntities() {
        HashMap<String, String> filterDetails = new HashMap<String, String>();
        TaskAttrHolderList res = new TaskAttrHolderList();
        for (String machine : this.m_MachinesNamesList) {
            String machineName = machine.substring(0, machine.length() - MSGlobals.iXMLPrefixLen - 1);
            filterDetails.put("Machine", machineName);
            if (!this.m_rules.getFilterHandler().isFilter(filterDetails)) continue;
            res.add((Object)new TaskAttrHolder(machineName, Params.instance().getDatasourcePath()));
        }
        try {
            int currentYear = Calendar.getInstance().get(1);
            CalendarUtil.CreateCalendarsFile(Params.instance().getDatacenterName(), currentYear - 2, currentYear + 2);
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        return res;
    }

    public AttrHolderList getChildren(String parentEntityId) {
        return null;
    }

    public void finalize_() {
    }

    public void init() throws ConvertorCancelClickException {
        RBCUtil.init();
        MSDirectory.mapMachine_AssistingJobsList = new HashMap();
        String pathDir = Params.instance().getDatasourcePath();
        this.m_MachinesNamesList = new ArrayList<String>();
        Collections.addAll(this.m_MachinesNamesList, TasksDirectories.getMachinesListInDirectory(pathDir, ".xml"));
        for (String machine : this.m_MachinesNamesList) {
            String machineName = machine.substring(0, machine.length() - MSGlobals.iXMLPrefixLen - 1);
            String machinePath = pathDir + MSGlobals.FILESEPARATOR + "Data" + MSGlobals.FILESEPARATOR + machineName + MSGlobals.FILESEPARATOR;
            ArrayList<String> filesListOfCurrentMachine = new ArrayList<String>(TasksDirectories.getFilesListInDirectory(machinePath));
            if (null == filesListOfCurrentMachine) continue;
            Map_Machine_FilesList.put(machineName, filesListOfCurrentMachine);
        }
    }

    public SchedEntity spawnJob(String table, IAttrHolder attributes) {
        String machineName = attributes.getAttr("Machine");
        String fileName = attributes.getAttr("FilePath");
        String startPath = attributes.getAttr("StartPath") + "Data" + MSGlobals.FILESEPARATOR;
        List<String> childrenList = null;
        List<String> filesOfMachine = Map_Machine_FilesList.get(machineName);
        if (null != filesOfMachine) {
            childrenList = TasksDirectories.getFirstLevelChildrenOfParent(filesOfMachine, fileName);
        }
        MSDirectory dir = new MSDirectory(fileName, startPath, SchedEntity.TYPE.SMART_TABLE, childrenList, null, "");
        return dir;
    }

    public SchedEntity spawnJob(SchedEntity parent, IAttrHolder attributes) {
        return null;
    }

    public String getIdFieldName() {
        return "Machine";
    }

    public String getEntNameFieldName() {
        return null;
    }

    public String getParentEntFieldName() {
        return null;
    }

    public boolean hasChildren(String entId) {
        List<String> tasksList = Map_Machine_FilesList.get(entId);
        return null != tasksList && tasksList.size() > 0;
    }

    public void createDependencies(String root) {
    }

    public void applyFilter(String root) {
    }

    public List<Properties> getJobInconds(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobOutconds(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobOnstmts(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobControlRes(SchedEntity job) {
        return null;
    }

    public Set<Properties> createTags(String root) {
        return null;
    }

    public boolean isStandAloneGrouped() {
        return false;
    }

    public boolean isContainerEntity(IAttrHolder entAttr) {
        return true;
    }

    public ArrayList<String> getGeneralMessages() {
        return null;
    }
}

