/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.ms;

import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.CliImporter;
import com.bmc.ctmconvert.common.CliParams;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.discovery.ManualFilesDiscovery;
import com.bmc.ctmconvert.discovery.OsDataHolder;
import com.bmc.ctmconvert.ms.DataImportMS;
import java.util.ArrayList;

public class CliImporterMs
extends CliImporter {
    private String format = "%s_%d";
    private int numberOfArgs = 1;

    public CliImporterMs() {
        this.checkParamsValidiy();
    }

    public FlowGlobals.COMPLETION_MODE doImport(String destinationFolderPath) {
        ArrayList<OsDataHolder> osDataHolderList = new ArrayList<OsDataHolder>();
        for (int i = 1; i <= this.numberOfArgs; ++i) {
            String machineName = CliParams.instance().get(String.format(this.format, "MACHINE_NAME", i));
            String dataFile = CliParams.instance().get(String.format(this.format, "DATA_FILE", i));
            String dateFormat = CliParams.instance().get(String.format(this.format, "DATE_FORMAT", i));
            if (machineName.isEmpty() || dataFile.isEmpty() || dateFormat.isEmpty()) continue;
            osDataHolderList.add(new OsDataHolder(machineName, dataFile, dateFormat, ""));
        }
        FlowGlobals.COMPLETION_MODE ended = ManualFilesDiscovery.staticCopyFilesToDestinationFolder((String)destinationFolderPath, osDataHolderList);
        DataImportMS.preformImport(destinationFolderPath, null);
        return ended;
    }

    public void checkParamsValidiy() {
        BaseFieldValidator datasourceValidator = null;
        while (CliParams.instance().containsKey(String.format(this.format, "MACHINE_NAME", this.numberOfArgs)) && CliParams.instance().containsKey(String.format(this.format, "DATE_FORMAT", this.numberOfArgs)) && CliParams.instance().containsKey(String.format(this.format, "DATA_FILE", this.numberOfArgs))) {
            datasourceValidator = new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY);
            if (!datasourceValidator.isValid(CliParams.instance().get(String.format(this.format, "MACHINE_NAME", this.numberOfArgs)))) {
                ProcessAlertsManager.instance().addMessage(String.format(this.format, "MACHINE_NAME", this.numberOfArgs) + ": " + datasourceValidator.getErrorMessage());
            }
            if (!datasourceValidator.isValid(CliParams.instance().get(String.format(this.format, "DATE_FORMAT", this.numberOfArgs)))) {
                ProcessAlertsManager.instance().addMessage(String.format(this.format, "DATE_FORMAT", this.numberOfArgs) + ": " + datasourceValidator.getErrorMessage());
            }
            if (!(datasourceValidator = new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH)).isValid(CliParams.instance().get(String.format(this.format, "DATA_FILE", this.numberOfArgs)))) {
                ProcessAlertsManager.instance().addMessage(String.format(this.format, "DATA_FILE", this.numberOfArgs) + ": " + datasourceValidator.getErrorMessage());
            }
            ++this.numberOfArgs;
        }
        --this.numberOfArgs;
        ProcessAlertsManager.instance().exitIfMessages(1);
    }
}

