/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.applications;

import com.bmc.applications.ApplicationUtils;
import com.bmc.applications.IApplicationExtractor;
import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseButtonGroup;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseComponentWrapper;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.base.BasePasswordField;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.BaseRadioButton;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.BaseTextField;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.base.ValidityListener;
import com.bmc.ctmconvert.base.table.BaseExtendedTable;
import com.bmc.ctmconvert.base.table.BaseFilterableTable;
import com.bmc.ctmconvert.base.table.BaseTableModel;
import com.bmc.ctmconvert.base.table.BaseTableToolbar;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FileFunctions;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.TextManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DataImportApplication
extends DataImportVendor
implements ActionListener {
    private BaseSection section;
    protected ImportPanels importPanels = ImportPanels.DEFAULT;
    private BaseRadioButton automaticCollection;
    private BaseRadioButton manualCollection;
    private JTextPane instruction;
    protected BaseContentPanel automaticPanel;
    protected BaseContentPanel manualPanel;
    protected boolean eligibleForNext = true;
    private DefaultTableModel model;
    private IApplicationExtractor extractor;
    private ArrayList<BaseField> loginFields;
    private ArrayList<BaseField> filterFields;
    private Properties loginInfo;

    public DataImportApplication() {
        final BaseButton button = ButtonFactory.createButton((ButtonFactory.ButtonType)ButtonFactory.ButtonType.TEST_CONNECTION, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataImportApplication.this.testConnection(true);
            }
        });
        button.setEnabled(false);
        this.section.addValidityListener(new ValidityListener(){

            public void validityActionPerformed(ConversionEvent e) {
                button.setEnabled(e.getValue() && DataImportApplication.this.automaticCollection.isSelected());
            }
        });
        ArrayList<BaseButton> componentList = new ArrayList<BaseButton>();
        componentList.add(button);
        this.importPanel = new BaseContentPanel(new BaseFooterPanel(componentList));
        this.importPanel = new BaseContentPanel();
        this.section = new BaseSection(TextManager.instance().get("SECTION_IMPORT_DATA")){

            public boolean isValid() {
                boolean toRet = true;
                if (DataImportApplication.this.loginFields != null) {
                    for (BaseField field : DataImportApplication.this.loginFields) {
                        toRet = toRet && field.getBaseComponent().isValid();
                    }
                }
                return toRet || DataImportApplication.this.manualCollection.isSelected();
            }
        };
        BaseButtonGroup dataCollectionGroup = new BaseButtonGroup();
        this.automaticCollection = new BaseRadioButton(TextManager.instance().get("DATA_IMPORT_AUTOMATIC"));
        this.automaticCollection.addActionListener((ActionListener)this);
        dataCollectionGroup.add(this.automaticCollection);
        this.section.addField(new BaseField((BaseComponent)this.automaticCollection));
        String applicationPropertiesText = ApplicationUtils.getApplicationProperties(Params.instance().getVendorName());
        try {
            Element applicationProperties = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(applicationPropertiesText.getBytes())).getDocumentElement();
            Element connection = (Element)applicationProperties.getElementsByTagName("Connection").item(0);
            NodeList connectionFields = connection.getElementsByTagName("Field");
            this.loginFields = new ArrayList();
            for (int index = 0; index < connectionFields.getLength(); ++index) {
                Element field = (Element)connectionFields.item(index);
                boolean mandatory = field.getAttribute("MANDATORY").equals("Y");
                String fieldType = field.getAttribute("TYPE");
                BaseTextField theField = null;
                if (fieldType.equals("text")) {
                    theField = new BaseTextField(mandatory ? new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY) : null);
                } else if (fieldType.equals("password")) {
                    theField = new BasePasswordField(new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
                }
                BaseField baseField = new BaseField((BaseComponent)theField, field.getAttribute("DISPLAY_NAME"), mandatory, 17);
                theField.getComponent().setName(field.getAttribute("NAME"));
                this.loginFields.add(baseField);
                this.section.addField(baseField);
            }
            Element filter = (Element)applicationProperties.getElementsByTagName("Filter").item(0);
            this.filterFields = new ArrayList();
            NodeList filterFieldsElm = filter.getElementsByTagName("Field");
            for (int index = 0; index < filterFieldsElm.getLength(); ++index) {
                Element field = (Element)filterFieldsElm.item(index);
                boolean mandatory = field.getAttribute("MANDATORY").equals("Y");
                String fieldType = field.getAttribute("TYPE");
                BaseTextField theField = null;
                if (fieldType.equals("text")) {
                    theField = new BaseTextField(mandatory ? new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY) : null);
                } else if (fieldType.equals("password")) {
                    theField = new BasePasswordField(new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
                }
                BaseField baseField = new BaseField((BaseComponent)theField, field.getAttribute("DISPLAY_NAME"), mandatory);
                this.filterFields.add(baseField);
            }
        }
        catch (SAXException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        catch (ParserConfigurationException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        this.manualCollection = new BaseRadioButton(TextManager.instance().get("DATA_IMPORT_MANUAL"));
        this.manualCollection.addActionListener((ActionListener)this);
        dataCollectionGroup.add(this.manualCollection);
        this.section.addField(new BaseField((BaseComponent)this.manualCollection));
        this.instruction = new JTextPane();
        this.instruction.setContentType("text/html");
        this.instruction.setEditable(false);
        this.instruction.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.instruction.setFont(FlowGlobals.FONT_STYLE_REGULAR);
        this.instruction.setFocusable(false);
        BaseField instructionField = new BaseField((BaseComponent)new BaseComponentWrapper((Component)this.instruction), -17);
        instructionField.setFillAllArea(true);
        instructionField.setValid(true);
        this.section.addField(instructionField);
        this.automaticCollection.doClick();
        this.importPanel.addSection(this.section);
        this.importPanel.buildContentPanel();
    }

    public DataImportVendor.ImportPosition getImportPosition() {
        switch (this.importPanels.ordinal()) {
            case 0: 
            case 3: {
                return DataImportVendor.ImportPosition.START;
            }
        }
        return DataImportVendor.ImportPosition.END;
    }

    public Component getDefaultFocusedComponent() {
        switch (this.importPanels.ordinal()) {
            case 0: {
                return this.automaticCollection.isSelected() ? this.automaticCollection.getComponent() : this.manualCollection.getComponent();
            }
        }
        return null;
    }

    public boolean eligibleForNext() {
        return this.eligibleForNext;
    }

    private boolean testConnection(boolean alert) {
        boolean success = true;
        Object message = "";
        this.extractor = ApplicationUtils.getExtractor(Params.instance().getVendorName());
        if (this.extractor != null) {
            this.loginInfo = new Properties();
            for (BaseField field : this.loginFields) {
                String key = field.getBaseComponent().getComponent().getName();
                String value = "";
                if (field.getBaseComponent().getClass().equals(BaseTextField.class)) {
                    value = ((BaseTextField)field.getBaseComponent()).getText();
                } else if (field.getBaseComponent().getClass().equals(BasePasswordField.class)) {
                    value = ((BasePasswordField)field.getBaseComponent()).getText();
                }
                this.loginInfo.setProperty(key, value);
            }
            try {
                success = this.extractor.testConnection(this.loginInfo);
            }
            catch (Exception e) {
                message = "Error: " + e.getLocalizedMessage();
                ExceptionHandler.writeToExceptionFile((Exception)e);
                success = false;
            }
            catch (Error e) {
                message = "Error: " + e.getLocalizedMessage();
                ExceptionHandler.writeToExceptionFile((String)e.getLocalizedMessage());
                success = false;
            }
        }
        if (alert) {
            if (success) {
                BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("TEST_CONNECTION_DIALOG_MSG_TITLE_STR"), (String)TextManager.instance().get("TEST_CONNECTION_DIALOG_MSG_SUCCESS"), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.SUCCESS_MESSAGE);
            } else {
                BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("TEST_CONNECTION_DIALOG_MSG_TITLE_STR"), (String)TextManager.instance().get("TEST_CONNECTION_DIALOG_MSG_FAILURE"), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.ERROR_MESSAGE, (String)message);
            }
        } else {
            ProcessAlertsManager.instance().init();
            ProcessAlertsManager.instance().addMessage((String)message);
        }
        return success;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setAutomaticEnabled(this.automaticCollection.isSelected());
        this.section.fireValidityEvent(this.section.isValid());
    }

    private void setAutomaticEnabled(boolean b) {
        for (BaseField field : this.loginFields) {
            field.setEnabled(b);
        }
    }

    public BaseContentPanel getNextPanel() {
        BaseContentPanel toRet = null;
        switch (this.importPanels.ordinal()) {
            case 0: {
                if (this.automaticCollection.isSelected()) {
                    if (this.testConnection(false)) {
                        this.eligibleForNext = true;
                        this.importPanels = ImportPanels.AUTOMATIC_DATA_IMPORT;
                        toRet = this.getAutomaticImportPanel();
                        break;
                    }
                    BaseMessageDialog.showMessageDialog((String)"Connection", (String)"Connection failed", (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.ERROR_MESSAGE, (String)ProcessAlertsManager.instance().getMessages());
                    this.eligibleForNext = false;
                    break;
                }
                this.importPanels = ImportPanels.MANUAL_DATA_IMPORT;
                toRet = this.getManualImportPanel();
                break;
            }
            case 1: 
            case 2: {
                toRet = null;
                break;
            }
            default: {
                this.importPanels = ImportPanels.DATA_IMPORT;
                toRet = this.importPanel;
            }
        }
        return toRet;
    }

    public BaseContentPanel getPrevPanel() {
        BaseContentPanel toRet = null;
        switch (this.importPanels.ordinal()) {
            case 0: {
                this.eligibleForNext = true;
                toRet = null;
                break;
            }
            case 1: 
            case 2: {
                this.importPanels = ImportPanels.DATA_IMPORT;
                toRet = this.importPanel;
                break;
            }
        }
        return toRet;
    }

    private BaseContentPanel getAutomaticImportPanel() {
        if (this.automaticPanel == null) {
            this.automaticPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("DATA_IMPORT_AUTOMATIC")));
            BaseSection filterSection = new BaseSection("Filter"){

                public boolean isValid() {
                    boolean toRet = true;
                    if (DataImportApplication.this.filterFields != null) {
                        for (BaseField field : DataImportApplication.this.filterFields) {
                            toRet = toRet && field.getBaseComponent().isValid();
                        }
                    }
                    return toRet;
                }
            };
            for (BaseField field : this.filterFields) {
                filterSection.addField(field);
            }
            this.automaticPanel.addSection(filterSection);
            this.automaticPanel.buildContentPanel();
        }
        return this.automaticPanel;
    }

    private BaseContentPanel getManualImportPanel() {
        if (this.manualPanel == null) {
            JPanel dataPanel = new JPanel();
            dataPanel.setLayout(new BorderLayout());
            dataPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.model = new BaseTableModel((Object[][])new String[0][], new String[]{"File name", "File Path"});
            this.model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    DataImportApplication.this.manualPanel.setValid(DataImportApplication.this.model.getRowCount() > 0);
                }
            });
            final BaseFilterableTable baseFilterableTable = new BaseFilterableTable();
            baseFilterableTable.setModel(this.model);
            baseFilterableTable.setColumnWidth(0, 200);
            BaseTableToolbar filtersToolbar = new BaseTableToolbar();
            BaseButton add = ButtonFactory.createButton((ButtonFactory.ButtonType)ButtonFactory.ButtonType.ADD);
            add.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BaseTextField tmp = new BaseTextField();
                    tmp.getComponent().setName(String.format("%s Data", Params.instance().getVendorName()));
                    GlobalFunctions.browseClick((JTextField)((JTextField)tmp.getComponent()), (String[])new String[]{"XML"}, (boolean)true);
                    String[] files = tmp.getText().split(";");
                    for (int index = 0; index < files.length; ++index) {
                        DataImportApplication.this.model.addRow(new String[]{files[index].substring(files[index].lastIndexOf(Globs.DIRSEP) + 1), files[index]});
                    }
                }
            });
            add.setEnabled(true);
            filtersToolbar.add((Component)add);
            filtersToolbar.add(Box.createRigidArea(new Dimension(5, 0)));
            BaseButton delete = ButtonFactory.createButton((ButtonFactory.ButtonType)ButtonFactory.ButtonType.DELETE);
            delete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    baseFilterableTable.removeRow(baseFilterableTable.getSelectedRowIndex());
                }
            });
            delete.setEnabled(true);
            filtersToolbar.add((Component)delete);
            filtersToolbar.add(Box.createRigidArea(new Dimension(5, 0)));
            BaseExtendedTable filtersList = new BaseExtendedTable(baseFilterableTable, filtersToolbar, null);
            this.manualPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("DATA_IMPORT_MANUAL")));
            dataPanel.add(filtersList.getComponent());
            this.manualPanel.setContentPanel((Component)dataPanel);
        }
        return this.manualPanel;
    }

    public FlowGlobals.COMPLETION_MODE performDataImport(String destinationFolderPath, BaseProgressBar progressBar) {
        switch (this.importPanels.ordinal()) {
            case 1: {
                return DataImportApplication.performDataImport(destinationFolderPath, this.loginInfo, null, progressBar);
            }
            case 2: {
                ArrayList<String> files = new ArrayList<String>();
                for (int index = 0; index < this.model.getRowCount(); ++index) {
                    files.add(this.model.getValueAt(index, 1).toString());
                }
                return DataImportApplication.performDataImport(destinationFolderPath, files, progressBar);
            }
        }
        return FlowGlobals.COMPLETION_MODE.FAILURE;
    }

    public static FlowGlobals.COMPLETION_MODE performDataImport(String destinationFolderPath, Properties loginInfo, Properties filterInfo, BaseProgressBar progressBar) {
        boolean rc = true;
        IApplicationExtractor applicationExtractor = ApplicationUtils.getExtractor(Params.instance().getVendorName());
        String targetFileName = destinationFolderPath + String.format("%sData-%d.xml", Params.instance().getVendorName(), 1);
        String data = applicationExtractor.getData(loginInfo, filterInfo, targetFileName);
        if (progressBar != null && progressBar.isCancelled()) {
            return FlowGlobals.COMPLETION_MODE.ABORTED;
        }
        try {
            Document sourceDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(data.getBytes()));
            StreamResult result = new StreamResult(new File(targetFileName));
            DOMSource source = new DOMSource(sourceDocument);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            xformer.transform(source, result);
        }
        catch (SAXException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            rc = false;
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            rc = false;
        }
        catch (ParserConfigurationException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            rc = false;
        }
        catch (TransformerConfigurationException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            rc = false;
        }
        catch (TransformerFactoryConfigurationError e) {
            ExceptionHandler.writeToExceptionFile((Exception)e.getException());
            rc = false;
        }
        catch (TransformerException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            rc = false;
        }
        if (progressBar != null && progressBar.isCancelled()) {
            return FlowGlobals.COMPLETION_MODE.ABORTED;
        }
        return rc ? FlowGlobals.COMPLETION_MODE.SUCCESS : FlowGlobals.COMPLETION_MODE.FAILURE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlowGlobals.COMPLETION_MODE performDataImport(String destinationFolderPath, ArrayList<String> filesPath, BaseProgressBar progressBar) {
        FlowGlobals.COMPLETION_MODE toRet = FlowGlobals.COMPLETION_MODE.FAILURE;
        if (progressBar != null) {
            progressBar.setProgressMax(filesPath.size());
        }
        for (int index = 0; index < filesPath.size(); ++index) {
            File sourceFile = new File(filesPath.get(index));
            if (progressBar != null) {
                progressBar.setLabel(String.format(TextManager.instance().get("DATA_IMPORT_SAP_PROGRESS_MESSAGE_MANUAL_FORMAT"), sourceFile.getName()));
                progressBar.setProgressValue(index);
                if (progressBar.isCancelled()) {
                    toRet = FlowGlobals.COMPLETION_MODE.ABORTED;
                    break;
                }
            }
            if (sourceFile.getName().isEmpty()) continue;
            File destinationFile = new File(String.format("%s%s_%d_%s", destinationFolderPath, "FileName", index, sourceFile.getName()));
            try {
                FileFunctions.copyFile((File)sourceFile, (File)destinationFile);
                toRet = FlowGlobals.COMPLETION_MODE.SUCCESS;
                continue;
            }
            catch (IOException e) {
                ProcessAlertsManager.instance().addMessage(String.format(TextManager.instance().get("DATA_IMPORT_COPY_FILE_ERROR_FORMAT"), sourceFile.toString(), destinationFile.toString()));
                continue;
            }
            finally {
                sourceFile = null;
                destinationFile = null;
            }
        }
        return toRet;
    }

    public String getHelpTitle() {
        return "Help title";
    }

    public String getFieldsData() {
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.toString();
    }

    public static enum ImportPanels {
        DATA_IMPORT,
        AUTOMATIC_DATA_IMPORT,
        MANUAL_DATA_IMPORT,
        DEFAULT;

    }
}

