/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.applications;

import com.bmc.ctmconvert.applications.ApplicationsDefs;
import com.bmc.ctmconvert.applications.ApplicationsEntitiy;
import com.bmc.ctmconvert.applications.ApplicationsHierarchyTree;
import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.MessageIdTable;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.message_id.MessageId;
import com.bmc.ctmconvert.rules.FieldEditor;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ApplicationsJob
implements SchedEntity {
    protected SchedEntity.TYPE entityType;
    protected ApplicationsEntitiy entityData;
    protected SchedEntity entityParent;
    protected ApplicationsDefs sourceDefinitions;
    protected boolean validEntity = true;
    protected Properties properties = new Properties();
    protected ArrayList<String> optionalProperties = new ArrayList();
    protected ArrayList<SchedEntity> children;
    protected RulesDataSet rules;
    protected ArrayList<String> messages = new ArrayList();
    protected ArrayList<Properties> inConds;
    protected ArrayList<Properties> outConds;
    protected LinkedHashMap<String, String> autoedits;
    protected ArrayList<Properties> onStmts;

    public ApplicationsJob(ApplicationsEntitiy data, SchedEntity.TYPE type, ApplicationsDefs sourceDef) {
        this.entityData = data;
        this.entityType = type;
        this.sourceDefinitions = sourceDef;
        this.initialize();
    }

    public ApplicationsJob(ApplicationsEntitiy data, SchedEntity.TYPE type, SchedEntity parent, ApplicationsDefs sourceDef) {
        this.entityData = data;
        this.entityType = type;
        this.entityParent = parent;
        this.sourceDefinitions = sourceDef;
        this.initialize();
    }

    protected ApplicationsJob(SchedEntity.TYPE entityType) {
        this.entityType = entityType;
    }

    private void initialize() {
        ArrayList<HashMap<String, String>> actions;
        this.rules = RuleManager.instance().getCurrentRules();
        HashMap<String, String> competitorValues = new HashMap<String, String>();
        switch (this.entityType) {
            case SMART_TABLE: 
            case TABLE: {
                String tableName = FieldValidation.instance().validateAndReturnFixedValue("TABLE_NAME", this.entityData.getEntityName());
                this.properties.setProperty("TABLE_NAME", tableName);
                this.properties.setProperty("JOBNAME", tableName);
                this.properties.setProperty("TABLE_USERDAILY", "");
                break;
            }
            case SUB_TABLE: {
                this.properties.setProperty("JOBNAME", FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", this.entityData.getEntityName()));
                this.properties.setProperty("PARENT_TABLE", this.getParentName());
                break;
            }
            case JOB: {
                this.properties.setProperty("JOBNAME", FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", this.entityData.getEntityName()));
                this.properties.setProperty("PARENT_TABLE", this.getParentName());
                this.properties.setProperty("CYCLIC", "0");
                this.properties.setProperty("TAG_RELATIONSHIP", "OR");
                this.properties.setProperty("ACTIVE_FROM", "");
                this.properties.setProperty("ACTIVE_TILL", "");
                this.setOptionalAttribute("MAXWAIT", "0");
                this.autoedits = new LinkedHashMap();
                NodeList fields = ((Element)this.entityData.getEntityData().getElementsByTagName("Variables").item(0)).getElementsByTagName("Field");
                for (int i = 0; i < fields.getLength(); ++i) {
                    Element attr = (Element)fields.item(i);
                    if (attr.getAttribute("AUTOEDIT").isEmpty()) continue;
                    this.autoedits.put(attr.getAttribute("AUTOEDIT"), attr.getAttribute("VALUE"));
                }
                this.properties.setProperty("TASKTYPE", "Job");
                if (RuleManager.instance().getCurrentRules().getTaskTypeHandler().isToDummy()) {
                    if (!Params.instance().getGUIVersion().equals("7") && !this.properties.getProperty("TASKTYPE").equals("Dummy")) {
                        this.autoedits.put("%%$BMCWAIORIGTYPE", this.properties.getProperty("TASKTYPE"));
                    }
                    this.properties.setProperty("TASKTYPE", "Dummy");
                }
                Properties genericJobsProperties = ApplicationsHierarchyTree.instance().getGenericJobsProperties();
                for (Object object : genericJobsProperties.keySet()) {
                    this.setOptionalAttribute((String)object, genericJobsProperties.getProperty((String)object));
                }
                break;
            }
        }
        if (this.entityData != null) {
            competitorValues.put("CONFIGURATION", "");
        }
        FieldEditor.SourceFieldGetter entityGetter = new FieldEditor.SourceFieldGetter(){

            public String getField(String fieldName) {
                return ApplicationsJob.this.resolveCompetitorFieldForFieldEditor(fieldName);
            }
        };
        this.properties.setProperty("APPLICATION", FieldValidation.instance().validateAndReturnFixedValue("APPLICATION", this.rules.getFieldEditor().generateCTMField("APPLICATION", entityGetter)));
        this.properties.setProperty("GROUP", FieldValidation.instance().validateAndReturnFixedValue("GROUP", this.rules.getFieldEditor().generateCTMField("GROUP", entityGetter)));
        this.properties.setProperty("DESCRIPTION", FieldValidation.instance().validateAndReturnFixedValue("DESCRIPTION", this.rules.getFieldEditor().generateCTMField("DESCRIPTION", entityGetter)));
        this.properties.setProperty("OWNER", FieldValidation.instance().validateAndReturnFixedValue("OWNER", this.rules.getFieldEditor().generateCTMField("OWNER", entityGetter)));
        this.properties.setProperty("AUTHOR", FieldValidation.instance().validateAndReturnFixedValue("AUTHOR", this.rules.getFieldEditor().generateCTMField("AUTHOR", entityGetter)));
        ArrayList<String> tmpMessages = this.sourceDefinitions.getJobMessages(this.getJobId());
        if (tmpMessages != null) {
            this.messages.addAll(tmpMessages);
        }
        if ((actions = this.sourceDefinitions.getJobActions(this.getJobId())) != null) {
            for (HashMap hashMap : actions) {
                Reporter.addAction((Map)hashMap);
            }
        }
    }

    protected String resolveCompetitorFieldForFieldEditor(String fieldName) {
        return null;
    }

    protected void setOptionalAttribute(String name, String value) {
        if (!this.optionalProperties.contains(name)) {
            this.optionalProperties.add(name);
        }
        this.properties.setProperty(name, value);
    }

    public SchedEntity.TYPE type() {
        return this.entityType;
    }

    public String originalProductID() {
        return null;
    }

    public List<SchedEntity> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
            switch (this.entityType) {
                case SMART_TABLE: 
                case TABLE: 
                case SUB_TABLE: {
                    for (ApplicationsEntitiy child = (ApplicationsEntitiy)this.entityData.getFirstChild(); child != null; child = (ApplicationsEntitiy)child.getNextSibling()) {
                        ApplicationsJob job = this.getApplicationsJob(child);
                        if (job == null) continue;
                        this.children.add(job);
                    }
                    break;
                }
                case JOB: {
                    break;
                }
            }
        }
        return this.children;
    }

    protected ApplicationsJob getApplicationsJob(ApplicationsEntitiy child) {
        return new ApplicationsJob(child, SchedEntity.TYPE.JOB, this.sourceDefinitions);
    }

    public List<AssistingJob> getAssistingJobs() {
        return null;
    }

    public String getAttr(String attrName) {
        return this.properties.getProperty(attrName);
    }

    public List<Properties> getInConds() {
        return this.inConds;
    }

    public List<Properties> getOutConds() {
        return this.outConds;
    }

    public List<Properties> getTags() {
        ArrayList<Properties> tags = new ArrayList<Properties>();
        Properties tag = new Properties();
        if (this.entityType == SchedEntity.TYPE.JOB) {
            tag.put("NAME", this.getParentName());
        } else {
            tag.put("NAME", this.getJobName());
            tag.put("DAYS", "ALL");
            String[] monthsArray = GlobalFunctions.getMonthsArray();
            for (int monthIndex = 0; monthIndex < monthsArray.length; ++monthIndex) {
                tag.put(monthsArray[monthIndex].toString(), "1");
            }
        }
        tags.add(tag);
        return tags;
    }

    public List<Properties> getQuantResources() {
        return null;
    }

    public List<Properties> getCtrlResources() {
        return null;
    }

    public List<Properties> getOnStmt() {
        return this.onStmts;
    }

    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        return null;
    }

    public List<Properties> getShouts() {
        return null;
    }

    public String getJobName() {
        return this.properties.getProperty("JOBNAME");
    }

    public String getJobId() {
        return this.getJobName();
    }

    public String getOriginalJobName() {
        return this.properties.getProperty("JOBNAME");
    }

    public String getParentName() {
        return this.getTablePathForSons();
    }

    public SchedEntity getParent() {
        return this.entityParent;
    }

    public String getTablePathForSons() {
        if (this.entityParent != null) {
            if (this.entityType == SchedEntity.TYPE.JOB) {
                return this.entityParent.getParentName();
            }
            if (this.entityType == SchedEntity.TYPE.SUB_TABLE) {
                return this.entityParent.getParentName() + "/" + this.getJobName();
            }
        }
        return this.getJobName();
    }

    public boolean isValid() {
        return this.validEntity;
    }

    public boolean hasWarnings() {
        if (this.messages.isEmpty()) {
            return false;
        }
        HashMap messageIds = MessageIdTable.instance().getMessageIds();
        for (String id : messageIds.keySet()) {
            if (!((MessageId)messageIds.get(id)).getMessageType(id).equals("W")) continue;
            for (String currMessage : this.messages) {
                if (!currMessage.startsWith(id)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasMessages() {
        return !this.messages.isEmpty();
    }

    public boolean isDSJob() {
        return true;
    }

    public String getTableName() {
        return this.getJobName();
    }

    public boolean isCyclic() {
        String cyclic = this.properties.getProperty("CYCLIC");
        if (cyclic == null) {
            return false;
        }
        return cyclic.equals("1");
    }

    public String applyFieldConversion(String field) {
        return null;
    }

    public String getApplication() {
        return this.properties.getProperty("APPLICATION");
    }

    public String getGroup() {
        return this.properties.getProperty("GROUP");
    }

    public LinkedHashMap<String, String> getAutoedits() {
        return this.autoedits;
    }

    public List<String> getOptionalAttributes() {
        return this.optionalProperties;
    }

    public ArrayList<String> getMessages() {
        return this.messages;
    }

    protected String getEntityValueByName(String tag, String name) {
        String value = null;
        if (this.entityData.getEntityData() != null) {
            NodeList fields = ((Element)this.entityData.getEntityData().getElementsByTagName(tag).item(0)).getElementsByTagName("Field");
            for (int i = 0; i < fields.getLength(); ++i) {
                Element attr = (Element)fields.item(i);
                if (!attr.getAttribute("NAME").equals(name)) continue;
                value = attr.getAttribute("VALUE");
                break;
            }
        }
        return value;
    }
}

