/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.deploy.steps;

import arrow.core.Either;
import com.bmc.ctmconvert.AAPIClient;
import com.bmc.ctmconvert.deploy.DeployStep;
import com.bmc.ctmconvert.deploy.ManualActionReporter;
import com.bmc.ctmconvert.migration.ManualAction;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\u0001H\u0016J5\u0010\f\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00060\u0006 \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u000f0\r*\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/bmc/ctmconvert/deploy/steps/AIJobTypesDeployStep;", "Lcom/bmc/ctmconvert/deploy/DeployStep;", "Lcom/bmc/ctmconvert/deploy/ManualActionReporter;", "aapiClient", "Lcom/bmc/ctmconvert/AAPIClient;", "outputFolder", "Ljava/nio/file/Path;", "<init>", "(Lcom/bmc/ctmconvert/AAPIClient;Ljava/nio/file/Path;)V", "getOutputFolder", "()Ljava/nio/file/Path;", "deploy", "filterNonCtmAiFiles", "", "kotlin.jvm.PlatformType", "", "(Ljava/nio/file/Path;)Ljava/util/List;", "manualActions", "Lcom/bmc/ctmconvert/migration/ManualAction;", "doesHaveAtLeastOnePluginFailedToDeploy", "", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nAIJobTypesDeployStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIJobTypesDeployStep.kt\ncom/bmc/ctmconvert/deploy/steps/AIJobTypesDeployStep\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,35:1\n1755#2,3:36\n1557#2:39\n1628#2,3:40\n*S KotlinDebug\n*F\n+ 1 AIJobTypesDeployStep.kt\ncom/bmc/ctmconvert/deploy/steps/AIJobTypesDeployStep\n*L\n33#1:36,3\n18#1:39\n18#1:40,3\n*E\n"})
public final class AIJobTypesDeployStep
extends DeployStep
implements ManualActionReporter {
    @NotNull
    private final AAPIClient aapiClient;
    @NotNull
    private final Path outputFolder;

    public AIJobTypesDeployStep(@NotNull AAPIClient aapiClient, @NotNull Path outputFolder) {
        Intrinsics.checkNotNullParameter((Object)aapiClient, (String)"aapiClient");
        Intrinsics.checkNotNullParameter((Object)outputFolder, (String)"outputFolder");
        super("Application Integrator Job Types");
        this.aapiClient = aapiClient;
        this.outputFolder = outputFolder;
    }

    @NotNull
    public final Path getOutputFolder() {
        return this.outputFolder;
    }

    @Override
    @NotNull
    public DeployStep deploy() {
        Path ctmAisDirectory = this.outputFolder.resolve("SaasAIPlugins");
        Intrinsics.checkNotNull((Object)ctmAisDirectory);
        this.announceNotFoundPathOrRun(ctmAisDirectory, "SaasAIPlugins directory cannot be found.", (Function0<Unit>)((Function0)() -> AIJobTypesDeployStep.deploy$lambda$1(this, ctmAisDirectory)));
        return this;
    }

    private final List<Path> filterNonCtmAiFiles(Path $this$filterNonCtmAiFiles) {
        return Files.walk($this$filterNonCtmAiFiles, new FileVisitOption[0]).filter(arg_0 -> AIJobTypesDeployStep.filterNonCtmAiFiles$lambda$3(AIJobTypesDeployStep::filterNonCtmAiFiles$lambda$2, arg_0)).toList();
    }

    @Override
    @NotNull
    public List<ManualAction> manualActions() {
        return this.doesHaveAtLeastOnePluginFailedToDeploy() ? CollectionsKt.listOf((Object)new ManualAction("Not all Application Integrator job types have been deployed to Control-M SaaS.")) : CollectionsKt.emptyList();
    }

    private final boolean doesHaveAtLeastOnePluginFailedToDeploy() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.result();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Either it = (Either)element$iv;
                    boolean bl2 = false;
                    if (!it.isLeft()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit deploy$lambda$1(AIJobTypesDeployStep this$0, Path $ctmAisDirectory) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNull((Object)$ctmAisDirectory);
        List<Path> list = this$0.filterNonCtmAiFiles($ctmAisDirectory);
        Intrinsics.checkNotNullExpressionValue(list, (String)"filterNonCtmAiFiles(...)");
        Iterable iterable = list;
        AIJobTypesDeployStep aIJobTypesDeployStep = this$0;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void ctmAiFile;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AAPIClient aAPIClient = this$0.aapiClient;
            Intrinsics.checkNotNull((Object)ctmAiFile);
            collection.add(aAPIClient.deployCtmAiJobTypePlugin((Path)ctmAiFile));
        }
        aIJobTypesDeployStep.setApiResultArray((List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    private static final boolean filterNonCtmAiFiles$lambda$2(Path it) {
        return StringsKt.endsWith$default((String)((Object)it.getFileName()).toString(), (String)".ctmai", (boolean)false, (int)2, null);
    }

    private static final boolean filterNonCtmAiFiles$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

