/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.Action;
import com.bmc.ctmconvert.Arguments;
import com.bmc.ctmconvert.ArgumentsParserKt;
import com.bmc.ctmconvert.HttpProxy;
import com.bmc.ctmconvert.MigrationParameterExceptionHandler;
import com.bmc.ctmconvert.PicoCliArguments;
import com.bmc.ctmconvert.databaseCommon.EmDatabaseParameters;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002J!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0002\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0017\u001a\u00020\u00182\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0002\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/bmc/ctmconvert/ArgumentsParser;", "", "version", "", "<init>", "(Ljava/lang/String;)V", "getVersion", "()Ljava/lang/String;", "parse", "Lcom/bmc/ctmconvert/Arguments;", "args", "", "([Ljava/lang/String;)Lcom/bmc/ctmconvert/Arguments;", "validateNoEmptyInteractiveParameters", "", "picoArgs", "Lcom/bmc/ctmconvert/PicoCliArguments;", "exitWithUsage", "validateArguments", "([Ljava/lang/String;)[Ljava/lang/String;", "validateParametersFile", "parametersFilePath", "addParametersFileIfMissing", "shouldPrintUsage", "", "([Ljava/lang/String;)Z", "printHelp", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nArgumentsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArgumentsParser.kt\ncom/bmc/ctmconvert/ArgumentsParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,535:1\n1#2:536\n18817#3,2:537\n1755#4,3:539\n*S KotlinDebug\n*F\n+ 1 ArgumentsParser.kt\ncom/bmc/ctmconvert/ArgumentsParser\n*L\n373#1:537,2\n376#1:539,3\n*E\n"})
public final class ArgumentsParser {
    @NotNull
    private final String version;

    public ArgumentsParser(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.version = version;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final Arguments parse(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (this.shouldPrintUsage(args)) {
            this.exitWithUsage();
        }
        PicoCliArguments picoArgs = new PicoCliArguments();
        String[] validatedArgs = this.validateArguments(args);
        int returnCone = new CommandLine((Object)picoArgs).setParameterExceptionHandler((CommandLine.IParameterExceptionHandler)new MigrationParameterExceptionHandler((Function0<Unit>)((Function0)() -> ArgumentsParser.parse$lambda$0(this)))).setCaseInsensitiveEnumValuesAllowed(true).setCommandName("migrateToSaaS").execute(Arrays.copyOf(validatedArgs, validatedArgs.length));
        if (returnCone != 0) {
            System.exit(returnCone);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        this.validateNoEmptyInteractiveParameters(picoArgs);
        String string = ArgumentsParserKt.access$automationApiEndpoint(picoArgs.getControl-m-automation-api-endpoint());
        String string2 = picoArgs.getControl-m-server-name();
        String string3 = picoArgs.getControl-m-enterprise-manager-username();
        String string4 = picoArgs.getControl-m-enterprise-manager-password();
        String string5 = picoArgs.getOutput-folder-path();
        String string6 = picoArgs.getSaasAapiEndpoint();
        String string7 = picoArgs.getSaasAapiToken();
        EmDatabaseParameters emDatabaseParameters = new EmDatabaseParameters(picoArgs.getControl-m-enterprise-manager-database-username(), picoArgs.getControl-m-enterprise-manager-database-password(), picoArgs.getControl-m-enterprise-manager-database-name(), picoArgs.getControl-m-enterprise-manager-database-hostname(), picoArgs.getControl-m-enterprise-manager-database-port(), picoArgs.getControl-m-enterprise-manager-database-type());
        String string8 = picoArgs.getDebug();
        Action action = picoArgs.getAction();
        String string9 = picoArgs.getFileListOfLibMemSym();
        String string10 = picoArgs.getTimeZoneMappingPath();
        String string11 = picoArgs.getReport-path();
        boolean bl = picoArgs.getSkipIfMissingAgents();
        String string12 = picoArgs.getOnPremiseTimeZoneFilePath();
        String string13 = picoArgs.getSaasServerName();
        String string14 = picoArgs.getDefaultHostName();
        if (string14 == null) {
            string14 = picoArgs.getControl-m-server-name();
        }
        String string15 = string14;
        HttpProxy httpProxy = HttpProxy.Companion.parseOrNull(picoArgs.getSaasAapiProxyHost(), picoArgs.getSaasAapiProxyPort());
        String string16 = picoArgs.getIdlClientEndpoint();
        return new Arguments(string, string2, string3, string4, string5, string6, string7, emDatabaseParameters, string9, string10, string8, action, bl, string11, string12, string15, string13, httpProxy, string16);
    }

    private final void validateNoEmptyInteractiveParameters(PicoCliArguments picoArgs) {
        block3: {
            block2: {
                if (StringsKt.isBlank((CharSequence)picoArgs.getControl-m-enterprise-manager-password()) || StringsKt.isBlank((CharSequence)picoArgs.getControl-m-enterprise-manager-database-password())) break block2;
                String string = picoArgs.getSaasAapiToken();
                if (!(string != null ? StringsKt.isBlank((CharSequence)string) : false)) break block3;
            }
            String string = "Password or token cannot be blank.\nIf you want to enter the value interactively remove the equals sign after the parameter's name.\n\n";
            System.out.print((Object)string);
            this.exitWithUsage();
        }
    }

    private final void exitWithUsage() {
        this.printHelp();
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private final String[] validateArguments(String[] args) {
        String parametersFilePath;
        String string;
        block2: {
            String[] stringArray = args;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                String it = string2 = stringArray[i];
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)"@", (boolean)false, (int)2, null)) continue;
                string = string2;
                break block2;
            }
            string = null;
        }
        String string3 = parametersFilePath = string != null ? StringsKt.drop(string, (int)1) : null;
        if (parametersFilePath != null) {
            this.validateParametersFile(parametersFilePath);
        }
        return this.addParametersFileIfMissing(args);
    }

    private final void validateParametersFile(String parametersFilePath) {
        if (!new File(parametersFilePath).exists()) {
            String string = StringsKt.trimMargin$default((String)("\"" + parametersFilePath + "\" file was not found\n                |\n                |\n            "), null, (int)1, null);
            System.out.print((Object)string);
            this.exitWithUsage();
        }
    }

    private final String[] addParametersFileIfMissing(String[] args) {
        boolean bl;
        block1: {
            String[] $this$none$iv = args;
            boolean $i$f$none = false;
            int n = $this$none$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$none$iv[i];
                boolean bl2 = false;
                CharSequence charSequence = it;
                if (!new Regex("[-,@]").containsMatchIn(charSequence)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl ? (String[])ArraysKt.plus((Object[])args, (Object)"@inputParameters/parameters.txt") : args;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldPrintUsage(String[] args) {
        String it;
        if (args.length == 0) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        Object[] objectArray = new String[]{"-h", "--help"};
        Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl2 = false;
        } while (!ArraysKt.contains((Object[])args, (Object)it));
        return true;
    }

    private final void printHelp() {
        String string = "Expected input argument, use one of the following arguments [q or qualification, m or migration]\nFor example: \"migrateToSaaS.bat q\" will run the Control-M SaaS Migration Tool in qualification mode.\n\nOptional: If you want to use an input parameters file in a custom location add @<path to parameter file>\nFor example: \"migrateToSaaS.bat m @C:\\InputParametersFile.txt\" will run the Control-M SaaS Migration Tool in migration mode using the input parameters from \"C:\\InputParametersFile.txt\"\nNote: if not mentioned, \"<home>\\inputParameters\\parameters.txt\" will be used by default.\n\nversion " + this.version + "\n";
        System.out.print((Object)string);
    }

    private static final Unit parse$lambda$0(ArgumentsParser this$0) {
        this$0.printHelp();
        return Unit.INSTANCE;
    }
}

