/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.messages;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.messages.ActionMessage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.TreeMap;

public class ActionTable
extends CsvFile {
    private TreeMap<String, ActionMessage> m_messages;
    private TreeMap<String, ActionMessage> m_messages_byJobId;

    public ActionTable() {
    }

    public ActionTable(String tableName) {
        this.m_messages = new TreeMap();
        this.m_messages_byJobId = new TreeMap();
        this.load(tableName);
    }

    public TreeMap<String, ActionMessage> getMessages() {
        return this.m_messages;
    }

    public TreeMap<String, ActionMessage> getMessagesByJobId() {
        return this.m_messages_byJobId;
    }

    @Override
    protected void handleRecord(IAttrHolder action_entry, int record_number) {
        Object hashKey = "";
        ActionMessage action_message = new ActionMessage(action_entry);
        hashKey = action_entry.getAttr("ACTENTTYPE") + "|" + action_entry.getAttr("ACTENTNAME") + "|" + action_entry.getAttr("JOBID") + "|" + Integer.toString(record_number);
        this.m_messages.put((String)hashKey, action_message);
        hashKey = action_entry.getAttr("JOBID") + "|" + action_entry.getAttr("ACTENTTYPE") + "|" + action_entry.getAttr("ACTENTNAME") + "|" + Integer.toString(record_number);
        this.m_messages_byJobId.put((String)hashKey, action_message);
    }

    public void saveCsv(TreeMap<String, AttrHolderList> boxes, File csvFile) {
        boolean headerWriten = false;
        try {
            if (csvFile.exists()) {
                csvFile.delete();
            }
            csvFile.createNewFile();
            BufferedWriter fileBW = new BufferedWriter(new FileWriter(csvFile, true));
            for (String key : boxes.keySet()) {
                if (!headerWriten) {
                    IAttrHolder tmpAH = (IAttrHolder)boxes.get(key).get(0);
                    fileBW.write(tmpAH.getCsvHeader());
                    fileBW.write("\n");
                    headerWriten = true;
                }
                AttrHolderList list = boxes.get(key);
                for (IAttrHolder job : list) {
                    String csvRow = job.toString();
                    fileBW.write(csvRow);
                    fileBW.write("\n");
                }
            }
            fileBW.close();
        }
        catch (FileNotFoundException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
    }
}

