/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.GenerateScripts;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;

public class UserDailyScriptGenerator {
    private Map<Object, Object> userDailyList;
    private FileSystem fileSystem;

    public UserDailyScriptGenerator(Map<Object, Object> userDailyList) {
        this(FileSystems.getDefault(), userDailyList);
    }

    public UserDailyScriptGenerator(FileSystem fileSystem, Map<Object, Object> userDailyList) {
        this.fileSystem = fileSystem;
        this.userDailyList = userDailyList;
    }

    public boolean generateScripts() {
        if (this.userDailyList == null || this.userDailyList.isEmpty()) {
            return false;
        }
        Path path = this.getPostConversionScriptsPath();
        GenerateScripts.createFolder(path);
        try {
            if (SettingsBooleanKeys.isSaas()) {
                this.generateSaaSScripts(path);
            } else {
                this.generateOnPremScripts(path);
            }
        }
        catch (IOException e) {
            ConversionLogger.getLogger().info(e.getMessage());
            ExceptionHandler.writeToExceptionFile(e);
        }
        return true;
    }

    private void generateSaaSScripts(Path path) throws IOException {
    }

    private void generateOnPremScripts(Path path) throws IOException {
        Path file = this.fileSystem.getPath(String.valueOf(path) + Globs.DIRSEP + "DAILY", new String[0]);
        RulesDataSet m_rules = RuleManager.instance().getCurrentRules();
        String schedtab = m_rules.getStringRule("Mainframe", new String[]{"SCHEDTAB"});
        if (schedtab == null) {
            schedtab = "SITE.SCHEDULE";
        }
        try (BufferedWriter output = Files.newBufferedWriter(file, new OpenOption[0]);){
            for (Map.Entry<Object, Object> entry : this.userDailyList.entrySet()) {
                String userDailyName = (String)entry.getKey();
                output.write("\tORDER DSN=" + schedtab + " MEMBER=" + userDailyName + "\n");
            }
        }
    }

    public Path getPostConversionScriptsPath() {
        return this.fileSystem.getPath(ConversionEntitiesService.getCurrentConversionPostDirectory(), new String[0]);
    }
}

