/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.draftwriter.json.writers.JacksonWriter;
import com.bmc.ctmconvert.generated.json.models.Workspace;
import com.bmc.ctmconvert.io.FileUtils;
import com.bmc.ctmconvert.io.csv.CsvWriter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DraftSplitter {
    private final JacksonWriter jsonWriter;
    private final Path draft;
    private final int maxEntitiesInDraft;
    private final HashMap<Integer, ArrayList<EntityCounter>> result;
    private final WriterGetter writerGetter;
    private final FolderMappingsWriter folderMappingsWriter;

    public DraftSplitter(Path draft, int maxEntitiesInDraft, WriterGetter writerGetter, Path folderMappingsPath) {
        this.draft = draft;
        this.maxEntitiesInDraft = maxEntitiesInDraft;
        this.jsonWriter = new JacksonWriter();
        this.result = new HashMap();
        this.writerGetter = writerGetter;
        this.folderMappingsWriter = new FolderMappingsWriter(folderMappingsPath);
    }

    public void splitDraft() throws IOException {
        Stream<Map.Entry<String, JsonNode>> folders = this.readFoldersFromDraft();
        HashMap<Integer, ArrayList<EntityCounter>> groupedFolders = folders.map(EntityCounter::new).collect(this.groupFoldersByAllowedJobCount());
        this.writeFoldersToFiles(groupedFolders);
    }

    private void writeFoldersToFiles(HashMap<Integer, ArrayList<EntityCounter>> groupedFolders) throws IOException {
        Set nonEmptyResults = groupedFolders.entrySet().stream().filter(s -> !((ArrayList)s.getValue()).isEmpty()).collect(Collectors.toSet());
        for (Map.Entry folders : nonEmptyResults) {
            Workspace workspace = new Workspace();
            Integer draftIndex = (Integer)folders.getKey();
            Writer writer = this.writerGetter.get(draftIndex);
            try {
                for (EntityCounter folder : (ArrayList)folders.getValue()) {
                    workspace.setAdditionalProperty(folder.getName(), (Object)folder.getData());
                    this.folderMappingsWriter.add(DraftSplitter.createDraftName(draftIndex), folder.getName());
                }
                this.jsonWriter.toJson(workspace, writer);
            }
            finally {
                if (writer == null) continue;
                writer.close();
            }
        }
        this.folderMappingsWriter.write();
    }

    private Stream<Map.Entry<String, JsonNode>> readFoldersFromDraft() throws IOException {
        String json = Files.readString(this.draft);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(json);
        Iterator root = jsonNode.fields();
        return this.toStream(root);
    }

    private Stream<Map.Entry<String, JsonNode>> toStream(Iterator<Map.Entry<String, JsonNode>> root) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(root, 16), false);
    }

    private Collector<EntityCounter, HashMap<Integer, ArrayList<EntityCounter>>, HashMap<Integer, ArrayList<EntityCounter>>> groupFoldersByAllowedJobCount() {
        AtomicInteger draftIndex = new AtomicInteger();
        return Collector.of(() -> this.result, (left, right) -> {
            ArrayList items = left.computeIfAbsent(draftIndex.get(), ArrayList::new);
            Integer sum = Stream.concat(items.stream(), Stream.of(right)).map(EntityCounter::getCount).reduce(0, Integer::sum);
            if (sum <= this.maxEntitiesInDraft) {
                items.add(right);
            } else {
                left.computeIfAbsent(draftIndex.incrementAndGet(), ArrayList::new).add(right);
            }
        }, (l, r) -> null, new Collector.Characteristics[0]);
    }

    public static Writer getWriter(int draftIndex) throws IOException {
        String draftName = DraftSplitter.createDraftName(draftIndex);
        Path target = Paths.get(Globs.TEMP_DRAFT_PATH, new String[0]).resolve(draftName);
        return FileUtils.createNewBufferedWriter(target, new OpenOption[0]);
    }

    private static String createDraftName(int draftIndex) {
        return String.format("draft%02d.json", draftIndex);
    }

    @FunctionalInterface
    public static interface WriterGetter {
        public Writer get(int var1) throws IOException;
    }

    static class FolderMappingsWriter {
        private static final String[] HEADERS = new String[]{"draftName", "folderName"};
        private final Path path;
        private final Map<String, Collection<String>> data;

        FolderMappingsWriter(Path path) {
            this.path = path;
            this.data = new HashMap<String, Collection<String>>();
        }

        void add(String draftName, String folderName) {
            Collection folderNames = this.data.getOrDefault(draftName, new HashSet());
            folderNames.add(folderName);
            this.data.put(draftName, folderNames);
        }

        void write() throws IOException {
            try (CsvWriter csvWriter = new CsvWriter(Files.newBufferedWriter(this.path, new OpenOption[0]));){
                csvWriter.writeRecord(HEADERS);
                List sortedData = this.data.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
                for (Map.Entry entry : sortedData) {
                    for (String folderName : (Collection)entry.getValue()) {
                        String[] record = new String[]{(String)entry.getKey(), folderName};
                        csvWriter.writeRecord(record);
                    }
                }
            }
        }
    }

    private static class EntityCounter {
        private final Map.Entry<String, JsonNode> folder;

        public EntityCounter(Map.Entry<String, JsonNode> folder) {
            this.folder = folder;
        }

        public int getCount() {
            return this.getChildrenCount(this.getData().fields());
        }

        private int getChildrenCount(Iterator<Map.Entry<String, JsonNode>> fields) {
            int childCount = 0;
            while (fields.hasNext()) {
                Map.Entry<String, JsonNode> item = fields.next();
                JsonNode data = item.getValue();
                if ("Jobs".equals(item.getKey()) && data.isArray()) {
                    childCount += data.size();
                }
                if (data.has("Type")) {
                    String type = data.get("Type").asText();
                    childCount += this.countSubFolder(type);
                }
                childCount += this.getChildrenCount(data.fields());
            }
            return childCount;
        }

        public JsonNode getData() {
            return this.folder.getValue();
        }

        public String getName() {
            return this.folder.getKey();
        }

        private int countSubFolder(String type) {
            return type.equals("SubFolder") ? 1 : 0;
        }
    }
}

