/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.ConnectionProfileGenerator;
import com.bmc.ctmconvert.common.AttrHolder;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class DBConnectionProfilesGenerator
extends ConnectionProfileGenerator {
    public List<String> writeDBConnectionProfilesJSON(Path dirPath, Map<String, String> databaseMap, Map<String, Set<String>> nodeGroupMap) {
        HashMap<String, JSONObject> dbCpObjects = new HashMap<String, JSONObject>();
        databaseMap.forEach((key, value) -> {
            String cpType;
            AttrHolder atrrHolder = this.getAsAttrHolder((String)value);
            String string = cpType = atrrHolder.getAttr("DBCPTYPE") == null ? "" : atrrHolder.getAttr("DBCPTYPE");
            if (!cpType.isEmpty()) {
                try {
                    dbCpObjects.put((String)key, this.createJson(atrrHolder, cpType));
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    // empty catch block
                }
            }
        });
        return this.createJsonFiles(dirPath, dbCpObjects, nodeGroupMap);
    }

    private JSONObject createJson(AttrHolder attribs, String cpType) throws NoSuchFieldException, IllegalAccessException {
        JSONObject objCP = this.getJsonObject_PreserveOrder();
        String password = attribs.getAttr("DBCPPWD");
        objCP.put("Type", (Object)("ConnectionProfile:Database:" + cpType));
        objCP.put("TargetAgent", (Object)attribs.getAttr("DBCPTARGETAGENT"));
        objCP.put("Host", (Object)attribs.getAttr("DBCPHOST"));
        objCP.put("User", (Object)attribs.getAttr("DBCPUSER"));
        objCP.put("Port", (Object)attribs.getAttr("DBCPPORT"));
        objCP.put("Password", (Object)(password == null || password.isEmpty() ? "password" : password));
        objCP.put("DatabaseName", (Object)attribs.getAttr("DBCPDATABASENAME"));
        objCP.put("DatabaseVersion", (Object)("MSSQL".equals(cpType) ? "2016" : "Any"));
        objCP.put("MaxConcurrentConnections", (Object)"9");
        objCP.put("ConnectionRetryTimeOut", (Object)attribs.getAttr("DBCPCONNECTIONRETYTIMEOUT"));
        objCP.put("ConnectionIdleTime", (Object)"45");
        objCP.put("TargetCTM", (Object)attribs.getAttr("SERVER"));
        return objCP;
    }
}

