/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.ConversionSaveResults;
import com.bmc.ctmconvert.DraftSplitter;
import com.bmc.ctmconvert.DraftWriterSupplier;
import com.bmc.ctmconvert.MessageMappingGetter;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FileFunctions;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.FlowGlobalsStrings;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.draftwriter.DataAccumulator;
import com.bmc.ctmconvert.common.draftwriter.DraftFormat;
import com.bmc.ctmconvert.common.draftwriter.DraftWriter;
import com.bmc.ctmconvert.common.draftwriter.JobMessage;
import com.bmc.ctmconvert.common.draftwriter.MessageMappingInterface;
import com.bmc.ctmconvert.common.draftwriter.json.JSONDraftWriter;
import com.bmc.ctmconvert.common.draftwriter.xml.XMLDraftWriter;
import com.bmc.ctmconvert.common.exceptions.ConversionRuntimeException;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.exceptions.ConvertorException;
import com.bmc.ctmconvert.common.exceptions.XMLValidatorException;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.message.MessageRegistry;
import com.bmc.ctmconvert.interfaces.VendorData;
import com.bmc.ctmconvert.io.FileUtils;
import com.bmc.ctmconvert.messages.FullReportTable;
import com.bmc.ctmconvert.rules.FieldEditor;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.services.DraftFormatRule;
import com.bmc.ctmconvert.services.VendorDataManager;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import com.bmc.ctmconvert.vc.DraftStructureValidator;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingWorker;

public class ConversionExecuter {
    private final RuleManager ruleManager;
    private BaseProgressBar progressBar;
    private final String reportTablePath;
    private boolean appendMsgId;
    private boolean appendMessageText;
    private FlowGlobals.COMPLETION_MODE completionStatus;
    private static String failureMessage = "";
    private boolean isCli;
    private Predicate<File> resultCopyFilter;

    public ConversionExecuter() {
        this(RuleManager.instance());
    }

    public ConversionExecuter(RuleManager ruleManager) {
        this.ruleManager = ruleManager;
        this.reportTablePath = Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP + "Results.csv";
        this.resultCopyFilter = x -> true;
    }

    public boolean execute(boolean isCli) {
        this.isCli = isCli;
        ConversionExecuter.reCreateTempDir();
        if (!isCli) {
            Task task = new Task();
            this.progressBar = new BaseProgressBar(TextManager.instance().get("CONVERSION_PROGRESS_BAR_TITLE"), task);
            task.execute();
            this.progressBar.setVisible(true);
        } else {
            this.doConvert();
        }
        this.conversionFinished(isCli);
        return this.completionStatus.equals((Object)FlowGlobals.COMPLETION_MODE.SUCCESS);
    }

    public boolean execute() {
        return this.execute(false);
    }

    private void conversionFinished(boolean isCli) {
        switch (this.completionStatus) {
            case SUCCESS: {
                this.saveConversionStatistics();
                this.copyConversionFiles();
                break;
            }
            case FAILURE: {
                this.showFailureDialogIfNotCLI(isCli);
                break;
            }
        }
    }

    private void showFailureDialogIfNotCLI(boolean isCli) {
        if (!isCli) {
            this.showFailureMessageDialog();
        }
    }

    private void showFailureMessageDialog() {
        BaseMessageDialog.showMessageDialog(TextManager.instance().get("CONVERSION_PANEL_CONVERSION_ENDED_DIALOG_TITLE"), TextManager.instance().get("CONVERSION_PANEL_CONVERSION_FAILED"), BaseMessageDialog.TYPE.ERROR_MESSAGE, failureMessage);
    }

    public void runXMLValidityCheck() throws XMLValidatorException {
        File dir = new File(Globs.TEMP_EVALUATION_DIR);
        File[] fileList = Optional.ofNullable(dir.listFiles()).orElse(new File[0]);
        int pbPrecent = 75;
        int precentPerFile = 25;
        int draftCnt = 0;
        for (File file : fileList) {
            if (!file.isFile() || !file.getName().startsWith("draft")) continue;
            precentPerFile = 25 / ++draftCnt;
        }
        this.appendMsgId = FieldEditor.isMessagesIdToDescription();
        this.appendMessageText = FieldEditor.isMessagesTextToDescription();
        DraftStructureValidator draftStructureValidator = new DraftStructureValidator();
        for (File file : fileList) {
            String currFileName = file.getName();
            if (!file.isFile() || !currFileName.matches("draft.*xml")) continue;
            this.descriptionMessagesHandling(file);
            boolean skipDraftValidation = SettingsTable.instance().getProperty(SettingsBooleanKeys.SKIP_DRAFT_VALIDATION);
            if (!skipDraftValidation) {
                draftStructureValidator.runDraftValidation(file.getPath());
            }
            pbPrecent += precentPerFile;
            if (this.progressBar == null) continue;
            this.progressBar.setProgressValue(pbPrecent);
        }
    }

    private void descriptionMessagesHandling(File draft) {
        if (draft.exists()) {
            String draftName = draft.getName();
            File origFile = new File(draft.getAbsolutePath().replace(draftName, "orig" + draftName));
            if (origFile.isFile()) {
                origFile.delete();
            }
            draft.renameTo(origFile);
            String jobIDPatternStr = "^\\s*DESCRIPTION=\".*?(\\[JOBIDFORMESSAGES=(\\d+)])[^\"]*\"";
            Pattern jobIDPattern = Pattern.compile(jobIDPatternStr);
            try (BufferedReader bufferedReader = FileUtils.createNewBufferedReader(Paths.get(origFile.getAbsolutePath(), new String[0]));
                 BufferedWriter bufferedWriter = FileUtils.createNewBufferedWriter(Paths.get(draft.getAbsolutePath(), new String[0]), new OpenOption[0]);){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    Matcher jobIDMatcher = jobIDPattern.matcher(line);
                    if (jobIDMatcher.matches()) {
                        String jobID = jobIDMatcher.group(2);
                        if ((this.appendMsgId || this.appendMessageText) && jobID != null && !jobID.isEmpty()) {
                            ArrayList<JobMessage> messagesList = FullReportTable.instance(this.reportTablePath).getMessagesListByJobId(jobID);
                            String messageIDFormat = "%s%s\t: %s (%s)";
                            String messageDescriptionFormat = "%s%s\t: %s.";
                            StringBuilder description = new StringBuilder();
                            if (messagesList != null && !messagesList.isEmpty()) {
                                description.append("== Conversion Messages Start ==");
                                for (JobMessage message : messagesList) {
                                    if (this.appendMsgId && !message.getMessageID().isEmpty()) {
                                        description.append("\r\n").append(String.format(messageIDFormat, "\r\n", "Message ID", message.getMessageID(), message.getID()));
                                    }
                                    if (!this.appendMessageText || message.getMessageText().isEmpty()) continue;
                                    description.append(String.format(messageDescriptionFormat, "\r\n", "Description", message.getMessageText()));
                                }
                                description.append("\r\n").append("\r\n").append("== Conversion Messages End ==").append("\r\n");
                            }
                            line = line.replace(jobIDMatcher.group(1), GlobalFunctions.EncodeXMLString(FieldValidation.instance().validateAndReturnFixedValue("DESCRIPTION", description.toString())));
                        } else {
                            line = line.replace(jobIDMatcher.group(1), "");
                        }
                    }
                    bufferedWriter.write(line);
                    bufferedWriter.newLine();
                }
                origFile.delete();
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile(e);
            }
        }
    }

    public void copyConversionFiles() {
        ConversionSaveResults csr = new ConversionSaveResults(Params.instance().getConversionName(), Params.instance().getConversionDescription(), this.resultCopyFilter);
        try {
            csr.save();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
    }

    public void saveConversionStatistics() {
        Properties conversionResult = new Properties();
        Reporter reporter = Reporter.instance();
        int entitiesConvertedWithWarnings = reporter.getTotalConvertedWithWarningEntities();
        int entitiesNotConverted = reporter.getTotalNotConvertedEntities();
        conversionResult.put("ENTITIES_CONVERTED_WITH_WARNINGS", String.valueOf(entitiesConvertedWithWarnings));
        conversionResult.put("ENTITIES_NOT_CONVERTED", String.valueOf(entitiesNotConverted));
        conversionResult.put("ENTITIES_TOTAL", String.valueOf(entitiesConvertedWithWarnings + entitiesNotConverted));
        int smartTablesCreated = reporter.getSmartTablesCreated();
        int subTablesCreated = reporter.getSubTablesCreated();
        int jobsCreated = reporter.getJobsCreated();
        int totalCreated = smartTablesCreated + subTablesCreated + jobsCreated;
        conversionResult.put("SMART_TABLES_CREATED", String.valueOf(smartTablesCreated));
        conversionResult.put("SUB_TABLES_CREATED", String.valueOf(subTablesCreated));
        conversionResult.put("JOBS_CREATED", String.valueOf(jobsCreated));
        conversionResult.put("ENTITIES_CONTROLM_TOTAL", String.valueOf(totalCreated));
        try (FileWriter fileWriter = new FileWriter(Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP + "ConversionStatistics.properties");
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            conversionResult.store(bufferedWriter, null);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
    }

    public static void setFailureMessage(String message) {
        failureMessage = message + "\n" + ProcessAlertsManager.instance().getMessages();
    }

    public static void reCreateTempDir() {
        ProcessAlertsManager.instance().init();
        File file = new File(Globs.TEMP_EVALUATION_DIR);
        FileFunctions.deleteDirectory(file);
        file.mkdir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doConvert() {
        SourceDefinitions input = null;
        boolean finlaized = false;
        this.setDraftFormat();
        MessageMappingGetter getter = new MessageMappingGetter();
        MessageMappingInterface msgMapping = getter.getConversionMessagesMapper();
        DataAccumulator dataAccumulator = new DataAccumulator(msgMapping);
        try {
            if (this.progressBar != null) {
                this.progressBar.setLabel(FlowGlobalsStrings.CONVERSION_STEP[0]);
                this.progressBar.setProgressValue(0);
            }
            Params.instance().initFirstDayOfTheWeek();
            Reporter.instance().initReporter();
            input = VendorDataManager.instance().getSourceDefinitions(Params.instance().getVendorName(), this.progressBar);
            new MessageRegistry(input);
            input.init();
            dataAccumulator.setProgressBar(this.progressBar);
            DraftWriter draftWriter = this.createDraftWriter(input, dataAccumulator);
            if (this.progressBar != null) {
                this.progressBar.setLabel(FlowGlobalsStrings.CONVERSION_STEP[1]);
                this.progressBar.setProgressValue(25);
            }
            this.writeDraftToFile(draftWriter);
            if (this.progressBar != null) {
                this.progressBar.setLabel(FlowGlobalsStrings.CONVERSION_STEP[2]);
                this.progressBar.setProgressValue(75);
            }
            dataAccumulator.updateReporter(Reporter.instance());
            input.finalize_();
            finlaized = true;
            if (this.progressBar != null) {
                this.progressBar.setLabel(FlowGlobalsStrings.CONVERSION_STEP[3]);
                this.progressBar.setProgressValue(75);
            }
            if (SettingsBooleanKeys.JSON_DRAFT_FORMAT.isEnabled()) {
                this.splitDraftIfNeeded(dataAccumulator);
            } else {
                this.validateXml();
            }
            if (this.progressBar != null && this.progressBar.getTask().isCancelled()) {
                this.completionStatus = FlowGlobals.COMPLETION_MODE.ABORTED;
                if (this.progressBar != null) {
                    this.progressBar.dispose();
                }
            }
            if (this.progressBar != null) {
                this.progressBar.setProgressValue(100);
            }
            this.completionStatus = FlowGlobals.COMPLETION_MODE.SUCCESS;
        }
        catch (ConvertorException ex) {
            this.handleException(ex, FlowGlobals.COMPLETION_MODE.FAILURE);
        }
        catch (ConvertorCancelClickException ex) {
            this.handleException(ex, FlowGlobals.COMPLETION_MODE.ABORTED);
        }
        catch (ConversionRuntimeException be) {
            ConversionExecuter.setFailureMessage(be.getMessage());
            this.completionStatus = FlowGlobals.COMPLETION_MODE.FAILURE;
        }
        catch (Throwable e) {
            this.completionStatus = FlowGlobals.COMPLETION_MODE.FAILURE;
            this.handleException(e, FlowGlobals.COMPLETION_MODE.FAILURE);
        }
        finally {
            dataAccumulator.updateReporter(Reporter.instance());
            if (this.completionStatus == FlowGlobals.COMPLETION_MODE.SUCCESS) {
                msgMapping.writeMappingFile();
            }
            if (!finlaized && input != null) {
                input.finalize_();
            }
            if (this.progressBar != null) {
                this.progressBar.dispose();
            }
        }
    }

    private void setDraftFormat() {
        DraftFormatRule draftFormatRule = this.ruleManager.getDraftFormatRule();
        switch (draftFormatRule) {
            case JSON: {
                SettingsBooleanKeys.JSON_DRAFT_FORMAT.enable();
                break;
            }
            case XML: {
                SettingsBooleanKeys.JSON_DRAFT_FORMAT.disable();
            }
        }
    }

    private void splitDraftIfNeeded(DataAccumulator dataAccumulator) throws IOException {
        boolean shouldSplitDraft;
        Integer numberOfJobsInDraft = this.getNumberOfJobsInDraft().orElse(dataAccumulator.getCreatedJobsCount());
        boolean bl = shouldSplitDraft = dataAccumulator.getCreatedJobsCount() > numberOfJobsInDraft;
        if (shouldSplitDraft) {
            this.resultCopyFilter = file -> !file.getAbsolutePath().equals(this.getTempDraftFileName());
            Path tempDraftFile = Paths.get(this.getTempDraftFileName(), new String[0]);
            new DraftSplitter(tempDraftFile, numberOfJobsInDraft, DraftSplitter::getWriter, this.getFolderMappingsFileName()).splitDraft();
        }
    }

    Optional<Integer> getNumberOfJobsInDraft() {
        String splitBy;
        boolean isRuleOn = RuleManager.instance().getCurrentRules().getStringRule("SplitJsonDraft", new String[]{"SPLIT_JSON_DRAFT"}).equals("MULTIPLE_FILES");
        if (isRuleOn && GlobalFunctions.isNumber(splitBy = RuleManager.instance().getCurrentRules().getStringRule("SplitJsonDraft", new String[]{"SPLIT_BY"}))) {
            return Optional.of(Integer.parseInt(splitBy));
        }
        return Optional.empty();
    }

    private Path getFolderMappingsFileName() {
        return Paths.get(Globs.TEMP_DRAFT_PATH, new String[0]).resolve("FoldersMapping.csv");
    }

    private void validateXml() {
        try {
            this.runXMLValidityCheck();
        }
        catch (XMLValidatorException e) {
            this.handleException(e, FlowGlobals.COMPLETION_MODE.FAILURE);
            this.showFailureDialogIfNotCLI(this.isCli);
        }
    }

    private void writeDraftToFile(DraftWriter draftWriter) throws ConvertorException {
        try (BufferedWriter output = FileUtils.createNewBufferedWriter(Paths.get(this.getTempDraftFileName(), new String[0]), new OpenOption[0]);){
            draftWriter.writeDraft(output);
        }
        catch (IOException e) {
            ConvertorException ce = new ConvertorException("Error when attempting to write to " + this.getTempDraftFileName());
            ConversionLogger.getLogger().severe("Failed to write to output draft, caught IOException: " + e.getMessage());
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
    }

    private String getTempDraftFileName() {
        return Globs.TEMP_DRAFT_PATH + GlobalFunctions.getDraftFileName();
    }

    DraftWriter createDraftWriter(SourceDefinitions input, DataAccumulator dataAccumulators) {
        if (SettingsBooleanKeys.JSON_DRAFT_FORMAT.isEnabled()) {
            return this.createJsonDraftWriter(input, dataAccumulators);
        }
        return this.createXmlDraftWriter(input, dataAccumulators);
    }

    private DraftWriter createJsonDraftWriter(SourceDefinitions input, DataAccumulator dataAccumulators) {
        return new JSONDraftWriter(input, dataAccumulators);
    }

    private DraftWriter createXmlDraftWriter(SourceDefinitions input, DataAccumulator dataAccumulator) {
        VendorData appData = VendorDataManager.instance().getVendorData();
        if (appData instanceof DraftWriterSupplier) {
            return ((DraftWriterSupplier)((Object)appData)).getDraftWriter(dataAccumulator);
        }
        return new XMLDraftWriter(input, dataAccumulator, DraftFormat.instance());
    }

    private void handleException(Throwable ex, FlowGlobals.COMPLETION_MODE completionMode) {
        if (ex instanceof Exception) {
            ExceptionHandler.writeToExceptionFile((Exception)ex);
        }
        String stackTraceString = GlobalFunctions.getStackTraceStringFromException(ex);
        ConversionExecuter.setFailureMessage("Unexpected error encountered during Conversion process.\r\nIf the problem continues, please contact BMC Support.\r\nError Stacktrace below -\r\n" + stackTraceString);
        this.completionStatus = completionMode;
    }

    private class Task
    extends SwingWorker<Void, Void> {
        private Task() {
        }

        @Override
        public Void doInBackground() {
            ConversionExecuter.this.doConvert();
            return null;
        }
    }
}

