/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.ConnectionProfileGenerator;
import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.Globs;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class AFTAccountsGenerator
extends ConnectionProfileGenerator {
    public List<String> writeAFTAccountsJSON(Path dirPath, Map<String, String> map, Map<String, Set<String>> nodeGroupMap) throws IOException {
        HashMap<String, JSONObject> aftObjects = new HashMap<String, JSONObject>();
        map.forEach((key, value) -> {
            AttrHolder atrrHolder = this.getAsAttrHolder((String)value);
            String cpType = atrrHolder.getAttr("AFTCPTYPE");
            if (key.contains("+")) {
                String accountLName = key.substring(0, key.indexOf(43));
                String accountRName = key.substring(key.indexOf(43) + 1);
                try {
                    if (cpType.equals(Globs.AFT_ACCOUNT_TYPES.LOCAL_TO_LOCAL.name())) {
                        this.addLocalToLocalAccounts(aftObjects, accountLName, atrrHolder);
                    } else if (cpType.equals(Globs.AFT_ACCOUNT_TYPES.LOCAL_TO_FTP.name())) {
                        this.addLocalToFtpAccounts(aftObjects, accountLName, accountRName, atrrHolder);
                    } else if (cpType.equals(Globs.AFT_ACCOUNT_TYPES.FTP_TO_FTP.name())) {
                        this.addFtpToFtpAccounts(aftObjects, accountLName, accountRName, atrrHolder);
                    }
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    // empty catch block
                }
            }
        });
        List<String> filesPath = this.createJsonFiles(dirPath, aftObjects, nodeGroupMap);
        return filesPath;
    }

    private void addLocalToLocalAccounts(Map<String, JSONObject> aftObjects, String key, AttrHolder atrrHolder) throws NoSuchFieldException, IllegalAccessException {
        aftObjects.put(key, this.getlocalAFTAccount(atrrHolder.getAttr("AFTLUSER"), atrrHolder.getAttr("AFTLOSTYPE"), atrrHolder.getAttr("AFTLTARGETAGENT"), atrrHolder.getAttr("SERVER")));
    }

    private void addFtpToFtpAccounts(Map<String, JSONObject> aftObjects, String accountLName, String accountRName, AttrHolder atrrHolder) throws NoSuchFieldException, IllegalAccessException {
        aftObjects.put(accountLName, this.getRemoteAFTAccount(atrrHolder.getAttr("AFTLUSER"), atrrHolder.getAttr("AFTLOSTYPE"), atrrHolder.getAttr("AFTLHOST"), atrrHolder.getAttr("AFTLTARGETAGENT"), atrrHolder.getAttr("SERVER")));
        aftObjects.put(accountRName, this.getRemoteAFTAccount(atrrHolder.getAttr("AFTRUSER"), atrrHolder.getAttr("AFTROSTYPE"), atrrHolder.getAttr("AFTRHOST"), atrrHolder.getAttr("AFTRARGETAGENT"), atrrHolder.getAttr("SERVER")));
    }

    private void addLocalToFtpAccounts(Map<String, JSONObject> aftObjects, String accountLName, String accountRName, AttrHolder atrrHolder) throws NoSuchFieldException, IllegalAccessException {
        aftObjects.put(accountLName, this.getlocalAFTAccount(atrrHolder.getAttr("AFTLUSER"), atrrHolder.getAttr("AFTLOSTYPE"), atrrHolder.getAttr("AFTLTARGETAGENT"), atrrHolder.getAttr("SERVER")));
        aftObjects.put(accountRName, this.getRemoteAFTAccount(atrrHolder.getAttr("AFTRUSER"), atrrHolder.getAttr("AFTROSTYPE"), atrrHolder.getAttr("AFTRHOST"), atrrHolder.getAttr("AFTRARGETAGENT"), atrrHolder.getAttr("SERVER")));
    }

    private JSONObject getlocalAFTAccount(String user, String osType, String targetAgent, String server) throws NoSuchFieldException, IllegalAccessException {
        JSONObject objAftAccount = this.getJsonObject_PreserveOrder();
        JSONObject password = new JSONObject();
        password.put("Secret", (Object)String.format("%s_%s", user, targetAgent));
        objAftAccount.put("Type", (Object)"ConnectionProfile:FileTransfer:Local");
        objAftAccount.append("WorkloadAutomationUsers", (Object)"");
        objAftAccount.put("User", (Object)user);
        objAftAccount.put("OsType", (Object)osType);
        objAftAccount.put("Port", (Object)"0");
        objAftAccount.put("HostName", (Object)"Local");
        objAftAccount.put("Password", (Object)password);
        objAftAccount.put("TargetAgent", (Object)targetAgent);
        objAftAccount.put("TargetCTM", (Object)server);
        return objAftAccount;
    }

    private JSONObject getRemoteAFTAccount(String user, String osType, String host, String targetAgent, String server) throws NoSuchFieldException, IllegalAccessException {
        JSONObject objAftAccount = this.getJsonObject_PreserveOrder();
        JSONObject password = new JSONObject();
        password.put("Secret", (Object)String.format("%s_%s", user, host));
        objAftAccount.put("Type", (Object)"ConnectionProfile:FileTransfer:FTP");
        objAftAccount.append("WorkloadAutomationUsers", (Object)"");
        objAftAccount.put("User", (Object)user);
        objAftAccount.put("Passive", (Object)"noSubstituteIP");
        objAftAccount.put("OsType", (Object)osType);
        objAftAccount.put("HostName", (Object)host);
        objAftAccount.put("Password", (Object)password);
        objAftAccount.put("TargetAgent", (Object)targetAgent);
        objAftAccount.put("TargetCTM", (Object)server);
        return objAftAccount;
    }
}

