/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.flowpanels;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseComponentWrapper;
import com.bmc.ctmconvert.base.BaseDialog;
import com.bmc.ctmconvert.base.RoundedCornerButton;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.configuration.ThemeConfiguration;
import com.bmc.ctmconvert.configuration.themes.WelcomePageTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class WelcomeWindow {
    private static WelcomeWindow instance;
    private final WelcomePageTheme theme = ThemeConfiguration.get().getWelcomePageTheme();
    private BaseDialog welcome = new BaseDialog();
    private JTextPane contentText;

    public static WelcomeWindow instance() {
        if (instance == null) {
            instance = new WelcomeWindow();
        } else {
            WelcomeWindow.instance.welcome.setVisible(true);
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    private WelcomeWindow() {
        this.welcome.setSize(new Dimension(800, 818));
        this.welcome.addNavegationListener(e -> this.welcome.dispose());
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 1));
        JPanel imageContainer = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics page) {
                super.paintComponent(page);
                Image img = new ImageIcon(this.getClass().getResource(FlowGlobals.WELLCOME_BACKGROUND_ICON_URL)).getImage();
                page.drawImage(img, 0, page.getClip().getBounds().height - 409, null);
                page.drawImage(img, 0, page.getClip().getBounds().height, null);
            }
        };
        imageContainer.setLayout(new BoxLayout(imageContainer, 1));
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 0));
        contentPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        contentPanel.setOpaque(false);
        this.contentText = new JTextPane();
        this.contentText.setContentType("text/html");
        this.contentText.setEditable(false);
        this.contentText.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.contentText.setFont(FlowGlobals.FONT_STYLE_WELCOME);
        this.contentText.setForeground(this.theme.textColor);
        this.contentText.setBackground(null);
        this.contentText.setOpaque(false);
        this.contentText.setFocusable(false);
        this.contentText.setText(this.getWelcomeText());
        this.contentText.addHyperlinkListener(new HyperlinkListener(this){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        Desktop.getDesktop().browse(new URI(String.valueOf(e.getURL())));
                    }
                    catch (IOException | URISyntaxException e1) {
                        ConversionLogger.getLogger().info(e1.toString());
                    }
                }
            }
        });
        JButton continueButton = this.createContinueButton("Continue...");
        contentPanel.add(this.contentText);
        contentPanel.add(Box.createHorizontalGlue());
        imageContainer.add(contentPanel);
        imageContainer.add(continueButton);
        imageContainer.add(Box.createVerticalStrut(110));
        imageContainer.setBackground(new Color(this.theme.backgroundColor));
        this.welcome.setContent((BaseComponent)new BaseComponentWrapper((Component)imageContainer));
        this.welcome.setVisible(true);
    }

    private JButton createContinueButton(String buttonText) {
        RoundedCornerButton continueButton = new RoundedCornerButton(buttonText);
        continueButton.setFocusable(false);
        continueButton.setBackground(new Color(this.theme.continueBackgroundColor));
        continueButton.setAlignmentX(0.5f);
        Dimension ButtonSize = new Dimension(115, 43);
        continueButton.setMaximumSize(ButtonSize);
        continueButton.setPreferredSize(ButtonSize);
        continueButton.setFont(FlowGlobals.FONT_STYLE_WELCOME.deriveFont(1));
        continueButton.addActionListener(e -> this.welcome.dispose());
        continueButton.setForeground(this.theme.continueForegroundColor);
        return continueButton;
    }

    private String getWelcomeText() {
        StringBuilder result = new StringBuilder();
        String controlmName = this.theme.controlmName;
        String validationStep = this.theme.validationStepText;
        String videoLink = this.theme.videoLinkText;
        String textColorHex = this.theme.textColorHex;
        result.append("<html>").append("     <p><font style='font-size: 18px; color: #" + textColorHex + ";'><b>Welcome to " + controlmName + " Conversion Tool!</b></font></p>").append("     <p><font style='font-size: 13px;'>Want to generate " + controlmName + " jobs from your existing tool?<br>You have come to the right place!</font></p>").append("     <p>The " + controlmName + " Conversion Tool wizard will guide you through the process.</p>").append(videoLink).append("     <p>Below is a quick summary of the conversion steps.</p>").append("     <p><font style='color: #" + textColorHex + "';><b>Create a conversion project</b></font>.<br>Select the scheduler from which you want to convert data.</p>").append("     <p><font style='color: #" + textColorHex + "';><b>Evaluate your data</b></font>.<br>Import your data and view a report of the jobs and other entities that the data contains.</p>").append("     <p><font style='color: #" + textColorHex + "';><b>Convert your data</b></font>.<br>Run the conversion. You can define rules and settings that affect the conversion results.</p>").append("     <p><font style='color: #" + textColorHex + "';><b>View the conversion results</b></font>.<br>View a report that indicates which jobs have been converted, and which jobs need further attention.</p>").append(validationStep).append("     <p><font style='color: #" + textColorHex + "';><b>Load the results into " + controlmName + "</b></font>.<br>View the jobs in " + controlmName + " Workload Automation.</p>").append("</html>");
        return result.toString();
    }
}

