/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.flowpanels;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseNavigationPanel;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.BaseTextArea;
import com.bmc.ctmconvert.base.BaseTextField;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.ValidityListener;
import com.bmc.ctmconvert.base.list.BaseDetailedList;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.services.VendorDataManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Properties;

public class NewProjectDialog
extends BasePanel {
    private BaseTextField name;
    private BaseTextArea description;
    private BaseDetailedList vendors;
    private boolean isValidToContinue;

    public NewProjectDialog() {
        this.initialize();
    }

    private void initialize() {
        this.isValidToContinue = false;
        this.baseContentPanel = new BaseContentPanel(new BaseTitlePanel("Project Characteristics"), new BaseFooterPanel(""));
        this.setNavigationPanel(new BaseNavigationPanel(new ButtonFactory.ButtonType[]{ButtonFactory.ButtonType.CREATE}));
        this.navigationPanel.setEnabled(ButtonFactory.ButtonType.CREATE, false);
        BaseSection section = new BaseSection("");
        section.addValidityListener(new ValidityListener(){

            public void validityActionPerformed(ConversionEvent e) {
                NewProjectDialog.this.navigationPanel.setEnabled(ButtonFactory.ButtonType.CREATE, e.getValue());
                NewProjectDialog.this.isValidToContinue = e.getValue();
            }
        });
        this.name = new BaseTextField(new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.DATASOURCE_NAME));
        section.addField(new BaseField((BaseComponent)this.name, TextManager.instance().get("CAPTURE_DATA_PROJECT_NAME_TEXT"), true, "Enter a unique project name."));
        this.description = new BaseTextArea();
        section.addField(new BaseField((BaseComponent)this.description, TextManager.instance().get("CAPTURE_DATA_PROJECT_DESCRIPTION_TEXT"), false, "Enter extra description about this project."));
        MouseAdapter doubleClickListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (!NewProjectDialog.this.isValidToContinue) {
                        return;
                    }
                    String actionCommand = TextManager.instance().get("MAIN_NAVIGATION_CREATE");
                    NewProjectDialog.this.fireNavegationEvent(actionCommand);
                }
            }
        };
        List vendorsList = VendorDataManager.instance().getVendorsList();
        Properties settings = new Properties();
        settings.setProperty("DISPLAY_BY", "NAME");
        settings.setProperty("GROUP_BY", "GROUP");
        settings.setProperty("SORT_BY", "GROUP_PRIORITY_AND_NAME");
        settings.setProperty("DELETE_ITEM_ENABLED", "NO");
        this.vendors = new BaseDetailedList(vendorsList, settings, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.VENDORS_LIST));
        this.vendors.setDetailsEnabled(false);
        this.vendors.addMouseListener((MouseListener)doubleClickListener);
        section.addField(new BaseField((BaseComponent)this.vendors, "Project Type", true, "Choose the Vendor you would like to convert from."));
        this.baseContentPanel.addSection(section);
        this.baseContentPanel.buildContentPanel();
        this.setContentPanel(this.baseContentPanel);
    }

    public void setFocusComponent() {
        this.name.getComponent().requestFocus();
    }

    public String getName() {
        return this.name.getText();
    }

    public String getDescription() {
        return this.description.getText();
    }

    public String getVendor() {
        return this.vendors.getSelectedItemProperties().getProperty("ID");
    }

    public String getVendorFullName() {
        return this.vendors.getSelectedItemProperties().getProperty("NAME");
    }
}

