/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.flowpanels;

import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseButtonGroup;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseComponentWrapper;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseExpander;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseImagePanel;
import com.bmc.ctmconvert.base.BaseLabel;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.base.BaseNavigationPanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.BaseRadioButton;
import com.bmc.ctmconvert.base.BaseTabbedPane;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.gui.flow.ConversionReportManager;
import com.bmc.ctmconvert.gui.flowpanels.FlowPanel;
import com.bmc.ctmconvert.gui.flowpanels.PostConversion;
import com.bmc.ctmconvert.gui.report.FullReportPanel;
import com.bmc.ctmconvert.messages.FullReportTable;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConversionResultsPanel
extends FlowPanel {
    private static ConversionResultsPanel instance;
    private static String conversionName;
    private static boolean loadReportAborted;
    private FullReportPanel reports;
    private final BaseTabbedPane reportsTabs;
    private final JLabel viewByTitle;
    private final BaseRadioButton messageType;
    private final BaseRadioButton job;
    private final BaseButton postActionsButton;
    private final BaseButton exportReport;
    private final JPanel messagesReportContainer;
    private final JPanel actionReport;
    private final JPanel resultContainer;

    public static ConversionResultsPanel instance() {
        if (instance == null || !ConversionEntitiesService.getCurrentConversionName().equals(conversionName) || loadReportAborted) {
            conversionName = ConversionEntitiesService.getCurrentConversionName();
            instance = new ConversionResultsPanel();
        }
        return instance;
    }

    public static void destroy() {
        FullReportTable.destroy();
        instance = null;
    }

    public static void destroy(String conversion) {
        if (conversion.equals(conversionName)) {
            ConversionResultsPanel.destroy();
        }
    }

    private ConversionResultsPanel() {
        ArrayList<Object> fromEndComponentList = new ArrayList<Object>();
        this.exportReport = ButtonFactory.createButton((ButtonFactory.ButtonType)ButtonFactory.ButtonType.EXPORT, e -> this.reports.export2File());
        fromEndComponentList.add(this.exportReport);
        fromEndComponentList.add(Box.createRigidArea(new Dimension(6, 0)));
        fromEndComponentList.add(ButtonFactory.createButton((ButtonFactory.ButtonType)ButtonFactory.ButtonType.DETACH, e -> ConversionReportManager.instance().viewConversionReport()));
        ArrayList<Object> componentList = new ArrayList<Object>();
        this.postActionsButton = ButtonFactory.createButton((ButtonFactory.ButtonType)ButtonFactory.ButtonType.GENERATE_SCRIPTS);
        this.postActionsButton.addActionListener(e -> {
            PostConversion postConversion = new PostConversion();
            postConversion.setVisible(true);
        });
        componentList.add(this.postActionsButton);
        this.viewByTitle = new JLabel("View By: ");
        this.viewByTitle.setBackground(FlowGlobals.ConversionGray);
        this.viewByTitle.setFont(FlowGlobals.FONT_STYLE_BOLD);
        componentList.add(this.viewByTitle);
        BaseButtonGroup viewByGroup = new BaseButtonGroup();
        this.messageType = new BaseRadioButton("Message Type");
        this.messageType.setBackground(FlowGlobals.ConversionGray);
        viewByGroup.add(this.messageType);
        componentList.add(Box.createRigidArea(new Dimension(6, 0)));
        componentList.add(this.messageType.getComponent());
        this.messageType.addActionListener(this::viewByAction);
        this.job = new BaseRadioButton("Job");
        this.job.setBackground(FlowGlobals.ConversionGray);
        viewByGroup.add(this.job);
        componentList.add(Box.createRigidArea(new Dimension(6, 0)));
        componentList.add(this.job.getComponent());
        this.job.addActionListener(this::viewByAction);
        this.baseContentPanel = new BaseContentPanel(new BaseTitlePanel("\"" + ConversionEntitiesService.getCurrentConversionName() + "\" " + TextManager.instance().get("CONVERSION_RESULTS_TITLE_CONVERSION_RESULT")), new BaseFooterPanel(this.getStatisticsPanel(), componentList, fromEndComponentList, false));
        this.setImagePanel(new BaseImagePanel(((Object)((Object)this)).getClass().getResource(FlowGlobals.SIDE_IMAGE_5_PATH)));
        this.setNavigationPanel(new BaseNavigationPanel(new ButtonFactory.ButtonType[]{ButtonFactory.ButtonType.BACK, ButtonFactory.ButtonType.NEXT, ButtonFactory.ButtonType.QUIT}));
        this.reportsTabs = new BaseTabbedPane();
        this.reportsTabs.addChangeListener(e -> this.setRportMode());
        this.messagesReportContainer = new JPanel(new CardLayout());
        this.reportsTabs.addTab("Messages", (Component)this.messagesReportContainer);
        this.actionReport = new JPanel(new BorderLayout());
        this.reportsTabs.addTab("Actions", (Component)this.actionReport);
        this.resultContainer = new JPanel(new BorderLayout());
        this.baseContentPanel.setContentPanel((Component)this.resultContainer);
        this.baseContentPanel.setScrollable(false);
        this.setContentPanel(this.baseContentPanel);
        this.setValid(true);
        Thread loadConversionReport = new Thread(this::loadReport);
        loadConversionReport.start();
    }

    private void loadReport() {
        BaseProgressBar progressBar = new BaseProgressBar(TextManager.instance().get("TITLE_CONVERSION_REPORT"));
        progressBar.setLabel(TextManager.instance().get("LOADING_CONVERSION_REPORT"));
        progressBar.setSnakeLook(true);
        Thread loadConversionReport = new Thread(() -> {
            loadReportAborted = false;
            this.reports = ConversionReportManager.instance().getConversionReport();
            if (this.reports != null) {
                this.messagesReportContainer.add(this.reports.getView(FullReportPanel.VIEW_MODE_BY_RESULT).getComponent(), "Message Type");
                this.messagesReportContainer.add(this.reports.getView(FullReportPanel.VIEW_MODE_BY_JOB).getComponent(), "Job");
                this.actionReport.add(this.reports.getView(FullReportPanel.VIEW_MODE_BY_ACTION).getComponent(), "Center");
                this.resultContainer.add(this.reportsTabs.getComponent(), "Center");
                this.messageType.doClick();
                this.reports.setViewMode(this.reportsTabs.getSelectedIndex());
                this.resultContainer.validate();
                this.resultContainer.repaint();
            }
            progressBar.dispose();
        });
        loadConversionReport.start();
        progressBar.setVisible(true);
        if (progressBar.isCancelled()) {
            loadReportAborted = true;
            this.resultContainer.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            JLabel loadReportStatusLabel = new JLabel();
            loadReportStatusLabel.setFont(FlowGlobals.FONT_STYLE_BOLD_TITLE);
            loadReportStatusLabel.setForeground(FlowGlobals.ConversionBlue);
            loadReportStatusLabel.setIcon(BaseMessageDialog.getImageIconByType((BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.WARNING_MESSAGE));
            loadReportStatusLabel.setText(TextManager.instance().get("LOADING_CONVERSION_REPORT_ABORTED"));
            this.resultContainer.add((Component)loadReportStatusLabel, "North");
            this.messageType.setEnabled(false);
            this.job.setEnabled(false);
            this.exportReport.setEnabled(false);
            this.resultContainer.validate();
            this.resultContainer.repaint();
            loadConversionReport.stop();
        }
    }

    private void viewByAction(ActionEvent e) {
        String cardName = ((Component)e.getSource()).getName();
        this.messagesReportContainer.getLayout();
        CardLayout cl = (CardLayout)this.messagesReportContainer.getLayout();
        cl.show(this.messagesReportContainer, cardName);
        this.setRportMode();
    }

    private void setRportMode() {
        int selectetReport = this.reportsTabs.getSelectedIndex();
        int reportViewMode = FullReportPanel.VIEW_MODE_BY_RESULT;
        if (selectetReport == 0) {
            if (this.messageType.isSelected()) {
                reportViewMode = FullReportPanel.VIEW_MODE_BY_RESULT;
            } else if (this.job.isSelected()) {
                reportViewMode = FullReportPanel.VIEW_MODE_BY_JOB;
            } else {
                ConversionLogger.getLogger().info("Error: Conversion report unknown report");
            }
            this.viewByTitle.setVisible(true);
            this.messageType.getComponent().setVisible(true);
            this.job.getComponent().setVisible(true);
            this.postActionsButton.setVisible(false);
        } else if (selectetReport == 1) {
            reportViewMode = FullReportPanel.VIEW_MODE_BY_ACTION;
            this.viewByTitle.setVisible(false);
            this.messageType.getComponent().setVisible(false);
            this.job.getComponent().setVisible(false);
            this.postActionsButton.setVisible(true);
        } else {
            ConversionLogger.getLogger().info("Error: Conversion report unknown report");
        }
        if (this.reports != null) {
            this.reports.setViewMode(reportViewMode);
        }
    }

    private Component getStatisticsPanel() {
        JPanel resultStatisticsContainer = new JPanel();
        resultStatisticsContainer.setBackground(FlowGlobals.ConversionGray);
        GridBagLayout grid = new GridBagLayout();
        int gridy = 0;
        int padding = 10;
        int[] columnWidths = new int[]{padding, padding, 180, padding, 100, padding, padding, 180, padding, 100, 1};
        grid.columnWidths = columnWidths;
        resultStatisticsContainer.setLayout(grid);
        GridBagConstraints gridConstraints = new GridBagConstraints();
        gridConstraints.fill = 2;
        gridConstraints.anchor = 21;
        gridConstraints.insets = new Insets(10, 0, 0, 0);
        try {
            Properties conversionResult = new Properties();
            FileReader fileReader = new FileReader(ConversionEntitiesService.getCurrentConversionDirectory() + "ConversionStatistics.properties");
            conversionResult.load(fileReader);
            fileReader.close();
            JLabel controlMStatisticsTitle = new JLabel(TextManager.instance().get("CONVERSION_RESULTS_SECTION_OUTPUT_SUMMARY"));
            controlMStatisticsTitle.setFont(FlowGlobals.FONT_STYLE_BOLD);
            controlMStatisticsTitle.setForeground(FlowGlobals.ConversionBlue);
            gridConstraints.gridwidth = 4;
            gridConstraints.gridx = 1;
            gridConstraints.gridy = gridy;
            resultStatisticsContainer.add((Component)controlMStatisticsTitle, gridConstraints);
            JLabel vendorMStatisticsTitle = new JLabel(TextManager.instance().get("CONVERSION_RESULTS_SECTION_CONVERSION_SUMMARY"));
            vendorMStatisticsTitle.setFont(FlowGlobals.FONT_STYLE_BOLD);
            vendorMStatisticsTitle.setForeground(FlowGlobals.ConversionBlue);
            gridConstraints.gridwidth = 4;
            gridConstraints.gridx = 6;
            gridConstraints.gridy = gridy++;
            gridConstraints.weightx = 0.0;
            resultStatisticsContainer.add((Component)vendorMStatisticsTitle, gridConstraints);
            gridConstraints.gridwidth = 1;
            gridConstraints.gridx = 2;
            gridConstraints.gridy = gridy;
            resultStatisticsContainer.add((Component)new BaseLabel(TextManager.instance().get("CONVERSION_RESULTS_FIELD_SMART_TABLES_COUNT")).getComponent(), gridConstraints);
            gridConstraints.gridx = 4;
            gridConstraints.gridy = gridy;
            resultStatisticsContainer.add((Component)new BaseLabel(conversionResult.getProperty("SMART_TABLES_CREATED")).getComponent(), gridConstraints);
            gridConstraints.gridx = 7;
            gridConstraints.gridy = gridy;
            resultStatisticsContainer.add((Component)new BaseLabel(TextManager.instance().get("CONVERSION_RESULTS_FIELD_CONVERTED_WITH_WARNINGS")).getComponent(), gridConstraints);
            gridConstraints.gridx = 9;
            gridConstraints.gridy = gridy++;
            resultStatisticsContainer.add((Component)new BaseLabel(conversionResult.getProperty("ENTITIES_CONVERTED_WITH_WARNINGS")).getComponent(), gridConstraints);
            gridConstraints.gridx = 2;
            gridConstraints.gridy = gridy;
            resultStatisticsContainer.add((Component)new BaseLabel(TextManager.instance().get("CONVERSION_RESULTS_FIELD_SUB_TABLES_COUNT")).getComponent(), gridConstraints);
            gridConstraints.gridx = 4;
            gridConstraints.gridy = gridy;
            resultStatisticsContainer.add((Component)new BaseLabel(conversionResult.getProperty("SUB_TABLES_CREATED")).getComponent(), gridConstraints);
            gridConstraints.gridx = 7;
            gridConstraints.gridy = gridy;
            resultStatisticsContainer.add((Component)new BaseLabel(TextManager.instance().get("CONVERSION_RESULTS_FIELD_NOT_CONVERTED")).getComponent(), gridConstraints);
            gridConstraints.gridx = 9;
            gridConstraints.gridy = gridy++;
            resultStatisticsContainer.add((Component)new BaseLabel(conversionResult.getProperty("ENTITIES_NOT_CONVERTED")).getComponent(), gridConstraints);
            gridConstraints.gridx = 2;
            gridConstraints.gridy = gridy;
            resultStatisticsContainer.add((Component)new BaseLabel(TextManager.instance().get("CONVERSION_RESULTS_FIELD_JOBS_COUNT")).getComponent(), gridConstraints);
            gridConstraints.gridx = 4;
            gridConstraints.gridy = gridy++;
            resultStatisticsContainer.add((Component)new BaseLabel(conversionResult.getProperty("JOBS_CREATED")).getComponent(), gridConstraints);
            gridConstraints.gridx = 2;
            gridConstraints.gridy = gridy++;
            gridConstraints.gridwidth = columnWidths.length - 2;
            gridConstraints.insets = new Insets(-4, 0, 0, 0);
            BaseLabel separator = new BaseLabel("_____________________________________________________________________________________________________________________");
            resultStatisticsContainer.add((Component)separator.getComponent(), gridConstraints);
            gridConstraints.insets = new Insets(8, 0, 0, 0);
            gridConstraints.gridwidth = 1;
            gridConstraints.gridx = 2;
            gridConstraints.gridy = gridy;
            resultStatisticsContainer.add((Component)new BaseLabel(TextManager.instance().get("CONVERSION_RESULTS_FIELD_TOTAL"), FlowGlobals.FONT_STYLE_BOLD).getComponent(), gridConstraints);
            gridConstraints.gridx = 4;
            gridConstraints.gridy = gridy;
            resultStatisticsContainer.add((Component)new BaseLabel(conversionResult.getProperty("ENTITIES_CONTROLM_TOTAL")).getComponent(), gridConstraints);
            gridConstraints.gridx = 9;
            gridConstraints.gridy = gridy++;
            resultStatisticsContainer.add((Component)new BaseLabel(conversionResult.getProperty("ENTITIES_TOTAL")).getComponent(), gridConstraints);
            gridConstraints.gridwidth = columnWidths.length;
            gridConstraints.gridx = 0;
            gridConstraints.gridy = gridy;
            gridConstraints.weightx = 1.0;
            gridConstraints.weighty = 1.0;
            gridConstraints.fill = 1;
            resultStatisticsContainer.add(Box.createRigidArea(new Dimension(0, 0)), gridConstraints);
        }
        catch (IOException exception) {
            ExceptionHandler.writeToExceptionFile((Exception)exception);
        }
        BaseExpander expander = new BaseExpander("Conversion Summary");
        expander.add((BaseComponent)new BaseComponentWrapper((Component)resultStatisticsContainer));
        expander.setBackground(FlowGlobals.ConversionGray);
        JPanel container = new JPanel(new BorderLayout());
        container.add(expander.getComponent());
        return container;
    }

    @Override
    public boolean performNextOperation() {
        return true;
    }

    @Override
    public boolean performPrevOperation() {
        return true;
    }

    @Override
    public boolean updateData() {
        return true;
    }

    @Override
    public FlowGlobals.FlowPanels getPanelType() {
        return FlowGlobals.FlowPanels.CONVERSION_RESULT;
    }

    @Override
    public String getHelpTitle() {
        return "CONVERSION_RESULTS_PANEL";
    }
}

